/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.delta;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevisionData;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOFeatureDeltaImpl;
import org.eclipse.emf.cdo.spi.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOFeatureDelta;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.net4j.util.ObjectUtil;

public abstract class CDOSingleValueFeatureDeltaImpl
extends CDOFeatureDeltaImpl
implements InternalCDOFeatureDelta.WithIndex {
    private int index;
    private Object value;

    public CDOSingleValueFeatureDeltaImpl(EStructuralFeature feature, int index, Object value) {
        super(feature);
        this.index = index;
        this.value = value;
    }

    public CDOSingleValueFeatureDeltaImpl(CDODataInput in, EClass eClass) throws IOException {
        super(in, eClass);
        this.index = in.readXInt();
        this.value = this.readValue(in, eClass);
    }

    @Override
    public void write(CDODataOutput out, EClass eClass) throws IOException {
        super.write(out, eClass);
        out.writeXInt(this.index);
        this.writeValue(out, eClass);
    }

    protected void writeValue(CDODataOutput out, EClass eClass) throws IOException {
        this.writeValue(out, eClass, this.value);
    }

    protected void writeValue(CDODataOutput out, EClass eClass, Object value) throws IOException {
        Object valueToWrite = value;
        if (valueToWrite == UNKNOWN_VALUE) {
            throw new IOException("Value is unknown");
        }
        EStructuralFeature feature = this.getFeature();
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
            FeatureMap.Entry entry = (FeatureMap.Entry)valueToWrite;
            feature = entry.getEStructuralFeature();
            valueToWrite = entry.getValue();
            int featureID = eClass.getFeatureID(feature);
            out.writeXInt(featureID);
        }
        if (valueToWrite != null && valueToWrite != CDORevisionData.NIL && feature instanceof EReference) {
            valueToWrite = out.getIDProvider().provideCDOID(value);
        }
        out.writeCDOFeatureValue(feature, valueToWrite);
    }

    protected Object readValue(CDODataInput in, EClass eClass) throws IOException {
        EStructuralFeature feature = this.getFeature();
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
            int featureID = in.readXInt();
            feature = eClass.getEStructuralFeature(featureID);
            Object innerValue = in.readCDOFeatureValue(feature);
            return CDORevisionUtil.createFeatureMapEntry(feature, innerValue);
        }
        return in.readCDOFeatureValue(feature);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void clear() {
        this.setValue(CDOID.NULL);
    }

    @Override
    public void adjustAfterAddition(int index) {
        if (index <= this.index) {
            ++this.index;
        }
    }

    @Override
    public void adjustAfterRemoval(int index) {
        if (index < this.index && this.index > 0) {
            --this.index;
        }
    }

    @Override
    public void adjustAfterMove(int oldPosition, int newPosition) {
        if (this.index == oldPosition) {
            this.index = newPosition;
        } else {
            this.adjustAfterRemoval(oldPosition);
            this.adjustAfterAddition(newPosition);
        }
    }

    @Override
    public boolean adjustReferences(CDOReferenceAdjuster referenceAdjuster) {
        Object adjustedValue;
        if (this.value != UNKNOWN_VALUE && (adjustedValue = referenceAdjuster.adjustReference(this.value, this.getFeature(), -1)) != this.value) {
            this.value = adjustedValue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStructurallyEqual(Object obj) {
        if (!super.isStructurallyEqual(obj)) {
            return false;
        }
        CDOSingleValueFeatureDeltaImpl that = (CDOSingleValueFeatureDeltaImpl)obj;
        return this.index == that.getIndex() && ObjectUtil.equals((Object)this.value, (Object)that.getValue());
    }

    @Override
    protected String toStringAdditional() {
        if (this.index == -1) {
            return MessageFormat.format("value={0}", this.value);
        }
        return MessageFormat.format("value={0}, index={1}", this.value, this.index);
    }
}

