/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.LaunchConfigurationAction;
import org.eclipse.debug.internal.ui.actions.LaunchShortcutAction;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.debug.internal.ui.stringsubstitution.SelectedResourceManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.debug.ui.actions.OpenLaunchDialogAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public abstract class ContextualLaunchAction
implements IObjectActionDelegate,
IMenuCreator {
    private IAction fDelegateAction;
    private String fMode;
    private ILaunchGroup fGroup = null;
    private Map<String, ILaunchGroup> fGroupsByCategory = null;
    private boolean fFillMenu = true;

    public ContextualLaunchAction(String mode) {
        this.fMode = mode;
        ILaunchGroup[] groups = DebugUITools.getLaunchGroups();
        this.fGroupsByCategory = new HashMap<String, ILaunchGroup>(3);
        ILaunchGroup[] iLaunchGroupArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchGroup group = iLaunchGroupArray[n2];
            if (group.getMode().equals(mode)) {
                if (group.getCategory() == null) {
                    this.fGroup = group;
                } else {
                    this.fGroupsByCategory.put(group.getCategory(), group);
                }
            }
            ++n2;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void dispose() {
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public Menu getMenu(Menu parent) {
        Menu menu = new Menu(parent);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                if (ContextualLaunchAction.this.fFillMenu) {
                    MenuItem[] items;
                    Menu m = (Menu)e.widget;
                    MenuItem[] menuItemArray = items = m.getItems();
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MenuItem item = menuItemArray[n2];
                        item.dispose();
                        ++n2;
                    }
                    ContextualLaunchAction.this.fillMenu(m);
                    ContextualLaunchAction.this.fFillMenu = false;
                }
            }
        });
        return menu;
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fFillMenu = true;
            if (this.fDelegateAction != action) {
                this.fDelegateAction = action;
                this.fDelegateAction.setMenuCreator((IMenuCreator)this);
            }
            action.setEnabled(true);
            return;
        }
        action.setEnabled(false);
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected void fillMenu(Menu menu) {
        IStructuredSelection ss = SelectedResourceManager.getDefault().getCurrentSelection();
        int accelerator = 1;
        if (!ss.isEmpty()) {
            try {
                ILaunchConfiguration config = this.getLaunchConfigurationManager().isSharedConfig(ss.getFirstElement());
                if (config != null && config.exists() && config.supportsMode(this.fMode)) {
                    LaunchConfigurationAction action = new LaunchConfigurationAction(config, this.fMode, config.getName(), DebugUITools.getDefaultImageDescriptor(config), accelerator++);
                    ActionContributionItem item = new ActionContributionItem((IAction)action);
                    item.fill(menu, -1);
                }
            }
            catch (CoreException coreException) {}
        }
        List selection = ss.toList();
        Object o = ss.getFirstElement();
        if (o instanceof IEditorPart) {
            selection.set(0, ((IEditorPart)o).getEditorInput());
        }
        IEvaluationContext context = DebugUIPlugin.createEvaluationContext(selection);
        context.setAllowPluginActivation(true);
        context.addVariable("selection", (Object)selection);
        List<LaunchShortcutExtension> allShortCuts = this.getLaunchConfigurationManager().getLaunchShortcuts();
        ArrayList<LaunchShortcutExtension> filteredShortCuts = new ArrayList<LaunchShortcutExtension>();
        Iterator<LaunchShortcutExtension> iter = allShortCuts.iterator();
        while (iter.hasNext()) {
            LaunchShortcutExtension ext = iter.next();
            try {
                if (WorkbenchActivityHelper.filterItem((Object)ext) || !this.isApplicable(ext, context)) continue;
                filteredShortCuts.add(ext);
            }
            catch (CoreException e) {
                Status status = new Status(4, DebugUIPlugin.getUniqueIdentifier(), "Launch shortcut '" + ext.getId() + "' enablement expression caused exception. Shortcut was removed.", (Throwable)e);
                DebugUIPlugin.log((IStatus)status);
                iter.remove();
            }
        }
        if (menu.getItemCount() > 0 && filteredShortCuts.size() > 0) {
            new MenuItem(menu, 2);
        }
        ArrayList<String> categories = new ArrayList<String>();
        for (LaunchShortcutExtension ext : filteredShortCuts) {
            for (String mode : ext.getModes()) {
                if (!mode.equals(this.fMode)) continue;
                String category = ext.getCategory();
                if (category != null && !categories.contains(category)) {
                    categories.add(category);
                }
                this.populateMenuItem(mode, ext, menu, accelerator++);
            }
        }
        if (categories.isEmpty()) {
            if (accelerator > 1) {
                new MenuItem(menu, 2);
            }
            OpenLaunchDialogAction action = new OpenLaunchDialogAction(this.fGroup.getIdentifier());
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(menu, -1);
        } else {
            boolean addedSep = false;
            for (String category : categories) {
                ILaunchGroup group = this.fGroup;
                if (category != null) {
                    group = this.fGroupsByCategory.get(category);
                }
                if (group == null) continue;
                if (accelerator > 1 && !addedSep) {
                    new MenuItem(menu, 2);
                    addedSep = true;
                }
                OpenLaunchDialogAction action = new OpenLaunchDialogAction(group.getIdentifier());
                ActionContributionItem item = new ActionContributionItem((IAction)action);
                item.fill(menu, -1);
            }
        }
    }

    private boolean isApplicable(LaunchShortcutExtension ext, IEvaluationContext context) throws CoreException {
        Expression expr = ext.getContextualLaunchEnablementExpression();
        return ext.evalEnablementExpression(context, expr);
    }

    private void populateMenuItem(String mode, LaunchShortcutExtension ext, Menu menu, int accelerator) {
        String contextLabel;
        LaunchShortcutAction action = new LaunchShortcutAction(mode, ext);
        action.setActionDefinitionId(String.valueOf(ext.getId()) + "." + mode);
        String helpContextId = ext.getHelpContextId();
        if (helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, helpContextId);
        }
        StringBuilder label = new StringBuilder();
        if (accelerator >= 0 && accelerator < 10) {
            label.append('&');
            label.append(accelerator);
            label.append(' ');
        }
        label.append((contextLabel = ext.getContextLabel(mode)) != null ? contextLabel : action.getText());
        action.setText(label.toString());
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(menu, -1);
    }

    private LaunchConfigurationManager getLaunchConfigurationManager() {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager();
    }
}

