/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.lrparser.lpgextensions;

import java.util.LinkedList;
import lpg.lpgjavaruntime.ConfigurationStack;
import lpg.lpgjavaruntime.IntTuple;
import lpg.lpgjavaruntime.TokenStream;

class ParserState {
    private static final int STACK_INCREMENT = 1024;
    public int lastToken;
    public int currentAction;
    public IntTuple tokens;
    public int[] actionStack;
    public int stateStackTop;
    public int[] stateStack;
    public int actionCount;
    public int totalCommits;
    public int[] parserLocationStack;
    public int[] undoStack;
    public int[] locationStack;
    public int repair_token;
    public int trialActionCount;
    public LinkedList<Integer> trialActionStack;
    public LinkedList pendingCommits;
    public ConfigurationStack configurationStack;
    public int act;
    public int curtok;

    public ParserState(int startState, TokenStream tokStream) {
        this.reallocateStateStack();
        this.stateStackTop = 0;
        this.stateStack[0] = startState;
        tokStream.reset();
        this.tokens = new IntTuple(tokStream.getStreamLength());
        this.tokens.add(tokStream.getPrevious(tokStream.peek()));
    }

    public void allocateOtherStacks() {
        this.locationStack = new int[this.stateStack.length];
    }

    public void reallocateStateStack() {
        int old_stack_length = this.stateStack == null ? 0 : this.stateStack.length;
        int stack_length = old_stack_length + 1024;
        if (this.stateStack == null) {
            this.stateStack = new int[stack_length];
        } else {
            this.stateStack = new int[stack_length];
            System.arraycopy(this.stateStack, 0, this.stateStack, 0, old_stack_length);
        }
    }

    public void reallocateOtherStacks(int start_token_index) {
        if (this.actionStack == null) {
            this.actionStack = new int[this.stateStack.length];
            this.locationStack = new int[this.stateStack.length];
            this.actionStack[0] = 0;
            this.undoStack = new int[this.stateStack.length];
            this.locationStack[0] = start_token_index;
            this.parserLocationStack = new int[this.stateStack.length];
            this.parserLocationStack[0] = start_token_index;
        } else if (this.actionStack.length < this.stateStack.length) {
            int old_length = this.actionStack.length;
            this.actionStack = new int[this.stateStack.length];
            System.arraycopy(this.actionStack, 0, this.actionStack, 0, old_length);
            this.undoStack = new int[this.stateStack.length];
            System.arraycopy(this.undoStack, 0, this.undoStack, 0, old_length);
            this.locationStack = new int[this.stateStack.length];
            System.arraycopy(this.locationStack, 0, this.locationStack, 0, old_length);
        }
    }

    public void dumpState() {
        System.out.print(this.curtok);
        System.out.print("\t");
        System.out.print(this.act);
        System.out.print("\t");
        this.dump(this.stateStack, this.stateStackTop);
        System.out.print("\t");
        this.dump(this.parserLocationStack, this.stateStackTop);
        System.out.println();
    }

    private void dump(int[] array, int limit) {
        System.out.print("[");
        int i = 0;
        while (i < limit) {
            if (i > 0) {
                System.out.print(", ");
            }
            System.out.print(array[i]);
            ++i;
        }
        System.out.print("]");
    }
}

