/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.vprop;

import javax.xml.namespace.QName;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.NodeNameFilter;
import org.eclipse.bpel.validator.rules.CValidator;

public class PropertyAlias
extends CValidator {
    public static IFilter<INode> PARENTS = new NodeNameFilter(WSDL_ND_DEFINITIONS);
    protected String fTypeName;
    protected String fElementName;
    protected String fPropertyName;
    protected String fMessageTypeName;
    protected String fMessagePartName;
    protected String fDuplicateKey = null;

    @Override
    public void start() {
        super.start();
        this.fPropertyName = this.mNode.getAttribute(WSDL_AT_PROPERTY_NAME);
    }

    @ARule(sa=0, desc="Check the QName of the property for this propertyAlias", author="michal.chmielewski@oracle.com", date="02/15/2007")
    public void rule_CheckQName_1() {
    }

    @ARule(sa=20, desc="Either the type or element attributes MUST be present or messageType AND part.", author="michal.chmielewski@oracle.com", date="02/17/2007", tag="pass1", errors="BPELC_PROPERTY__UNSET")
    public void rule_CheckPropertyAliasDefinition_10() {
        this.fMessageTypeName = this.mNode.getAttribute(AT_MESSAGE_TYPE);
        this.fMessagePartName = this.mNode.getAttribute(AT_PART);
        this.fTypeName = this.mNode.getAttribute(AT_TYPE);
        this.fElementName = this.mNode.getAttribute(AT_ELEMENT);
        QName nn = this.mNode.nodeName();
        if (PropertyAlias.isNonEmpty(this.fMessageTypeName) && PropertyAlias.isNonEmpty(this.fMessagePartName)) {
            this.fDuplicateKey = nn + "/messageType/" + this.fMessageTypeName + "/" + this.fMessagePartName + "/" + this.fPropertyName;
        } else if (PropertyAlias.isEmpty(this.fMessageTypeName) && PropertyAlias.isEmpty(this.fMessagePartName)) {
            if (PropertyAlias.isEmpty(this.fTypeName) && PropertyAlias.isNonEmpty(this.fElementName)) {
                this.fDuplicateKey = nn + "/element/" + this.fElementName + "/" + this.fPropertyName;
            } else if (PropertyAlias.isNonEmpty(this.fTypeName) && PropertyAlias.isEmpty(this.fElementName)) {
                this.fDuplicateKey = "propertyAlias/type/" + this.fTypeName + "/" + this.fPropertyName;
            } else {
                IProblem problem = this.createError();
                problem.fill("BPELC_PROPERTY__UNSET", this.toString(this.mNode.nodeName()), AT_TYPE, AT_ELEMENT, 0);
            }
        } else {
            IProblem problem = this.createError();
            problem.fill("BPELC_PROPERTY__UNSET", this.toString(this.mNode.nodeName()), AT_MESSAGE_TYPE, AT_PART, 1);
        }
    }

    @ARule(sa=21, desc="Check types of property aliases", author="michal.chmielewski@oracle.com", date="03/18/2007", errors="BPELC__UNRESOLVED_ATTRIBUTE,BPELC_MSG__PART")
    public void rule_ChceckPropertyAliasTypes_13() {
        if (PropertyAlias.isEmpty(this.fDuplicateKey)) {
            return;
        }
        INode typeNode = null;
        if (PropertyAlias.isNonEmpty(this.fMessageTypeName) && PropertyAlias.isNonEmpty(this.fMessagePartName)) {
            INode msgType = this.mModelQuery.lookup(this.mNode.rootNode(), 7, this.fMessageTypeName);
            if (this.isUndefined(msgType)) {
                IProblem problem = this.createError();
                problem.fill("BPELC__UNRESOLVED_ATTRIBUTE", this.toString(this.mNode.nodeName()), AT_MESSAGE_TYPE, 0, this.fMessageTypeName);
            } else {
                typeNode = this.mModelQuery.lookup(msgType, 16, this.fMessagePartName);
                if (this.isUndefined(typeNode)) {
                    IProblem problem = this.createError();
                    problem.fill("BPELC_MSG__PART", this.toString(this.mNode.nodeName()), this.fMessagePartName, this.fMessageTypeName);
                }
            }
        } else if (PropertyAlias.isNonEmpty(this.fTypeName)) {
            typeNode = this.mModelQuery.lookup(this.mNode.rootNode(), 9, this.fTypeName);
            if (this.isUndefined(typeNode)) {
                IProblem problem = this.createError();
                problem.fill("BPELC__UNRESOLVED_ATTRIBUTE", this.toString(this.mNode.nodeName()), AT_TYPE, 0, this.fTypeName);
            }
        } else if (PropertyAlias.isNonEmpty(this.fElementName) && this.isUndefined(typeNode = this.mModelQuery.lookup(this.mNode.rootNode(), 8, this.fElementName))) {
            IProblem problem = this.createError();
            problem.fill("BPELC__UNRESOLVED_ATTRIBUTE", this.toString(this.mNode.nodeName()), AT_ELEMENT, 0, this.fElementName);
        }
        if (this.isDefined(typeNode)) {
            this.setValue("type", typeNode);
        }
    }

    @ARule(sa=22, desc="Detect duplicate propertyAlias definitions", author="michal.chmielewski@oracle.com", date="03/20/2007", errors="BPELC__DUPLICATE")
    public void rule_CheckDuplicatePropertyAlias_25() {
        if (PropertyAlias.isEmpty(this.fDuplicateKey)) {
            return;
        }
        if (this.containsValueKey(this.fParentNode, this.fDuplicateKey)) {
            IProblem problem = this.createError();
            problem.fill("BPELC__DUPLICATE", this.toString(this.mNode.nodeName()), this.fPropertyName);
            return;
        }
        this.setValue(this.fParentNode, this.fDuplicateKey, true);
    }
}

