/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import java.util.ArrayList;
import org.eclipse.bpel.common.ui.command.ICommandFramework;
import org.eclipse.bpel.common.ui.details.viewers.CComboViewer;
import org.eclipse.bpel.common.ui.editmodel.AbstractEditModelCommand;
import org.eclipse.bpel.common.ui.editmodel.EditModelCommandStack;
import org.eclipse.bpel.common.ui.flatui.FlatFormLayout;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.adapters.IProperty;
import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.BPELTabbedPropertySheetPage;
import org.eclipse.bpel.ui.actions.ShowPropertiesViewAction;
import org.eclipse.bpel.ui.adapters.IMarkerHolder;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.properties.EditController;
import org.eclipse.bpel.ui.proposal.providers.ModelContentProposalProvider;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.MultiObjectAdapter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyViewer;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.TabContents;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public abstract class BPELPropertySection
extends AbstractPropertySection {
    protected static final String EMPTY_STRING = "";
    protected static final IMarker[] EMPTY_MARKERS = new IMarker[0];
    protected static final MultiObjectAdapter[] EMPTY_MULTI_OBJECT_ARRAY = new MultiObjectAdapter[0];
    public static final int STANDARD_LABEL_WIDTH_SM = 105;
    public static final int STANDARD_LABEL_WIDTH_AVG = 131;
    public static final int STANDARD_LABEL_WIDTH_LRG = 157;
    public static final int STANDARD_BUTTON_WIDTH = 60;
    public static final int SHORT_BUTTON_WIDTH = 45;
    protected MultiObjectAdapter[] fAdapters;
    protected boolean isCreated;
    protected boolean isHidden;
    protected EObject fModelObject;
    protected TabbedPropertySheetWidgetFactory fWidgetFactory;
    protected BPELTabbedPropertySheetPage fTabbedPropertySheetPage;
    protected final ModelContentProposalProvider.ValueProvider inputValueProvider = new ModelContentProposalProvider.ValueProvider(){

        @Override
        public Object value() {
            return BPELPropertySection.this.getModel();
        }
    };

    public TabbedPropertySheetWidgetFactory getWidgetFactory() {
        TabbedPropertySheetWidgetFactory wf = super.getWidgetFactory();
        wf.setBorderStyle(2048);
        return wf;
    }

    public BPELPropertySection() {
        this.fAdapters = this.createAdapters();
    }

    protected MultiObjectAdapter[] createAdapters() {
        return EMPTY_MULTI_OBJECT_ARRAY;
    }

    protected void removeAllAdapters() {
        MultiObjectAdapter[] multiObjectAdapterArray = this.fAdapters;
        int n = this.fAdapters.length;
        int n2 = 0;
        while (n2 < n) {
            MultiObjectAdapter a = multiObjectAdapterArray[n2];
            a.removeFromAll();
            ++n2;
        }
    }

    protected void addAllAdapters() {
        assert (this.isCreated) : "Not yet created!";
        if (this.fAdapters.length > 0 && this.getModel() != null) {
            this.fAdapters[0].addToObject((Notifier)this.getModel());
        }
    }

    protected void refreshAdapters() {
        this.removeAllAdapters();
        this.addAllAdapters();
    }

    protected void basicSetInput(EObject newInput) {
        this.fModelObject = newInput;
    }

    protected void restoreUserContextFromInput() {
        IProperty prop = BPELUtil.adapt((Object)this.fModelObject, IProperty.class);
        if (prop != null) {
            this.restoreUserContext(prop.getProperty((Object)((Object)((Object)this)).getClass().getName()));
        }
    }

    protected void saveUserContextToInput() {
        IProperty prop = BPELUtil.adapt((Object)this.fModelObject, IProperty.class);
        if (prop != null) {
            prop.setProperty((Object)((Object)((Object)this)).getClass().getName(), this.getUserContext());
        }
    }

    public final void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object model = ((IStructuredSelection)selection).getFirstElement();
        if (model == this.fModelObject) {
            return;
        }
        this.removeAllAdapters();
        super.setInput(part, selection);
        this.basicSetInput((EObject)model);
        this.addAllAdapters();
    }

    public void aboutToBeHidden() {
        this.isHidden = true;
    }

    public void aboutToBeShown() {
        this.isHidden = false;
    }

    protected <T extends EObject> T getModel() {
        return (T)this.fModelObject;
    }

    protected final <T extends EObject> T getInput() {
        return this.getModel();
    }

    protected void refreshCCombo(CComboViewer viewer, Object selectedObject) {
        viewer.refresh();
        if (selectedObject == null) {
            viewer.setSelectionNoNotify((ISelection)StructuredSelection.EMPTY, false);
        } else {
            viewer.setSelectionNoNotify((ISelection)new StructuredSelection(selectedObject), false);
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.fTabbedPropertySheetPage = (BPELTabbedPropertySheetPage)aTabbedPropertySheetPage;
        this.fWidgetFactory = this.getWidgetFactory();
        assert (!this.isCreated) : "Not yet created!";
        Composite marginComposite = this.fWidgetFactory.createComposite(parent);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginWidth = 6;
        fillLayout.marginHeight = 3;
        marginComposite.setLayout((Layout)fillLayout);
        this.createClient(marginComposite);
        this.isHidden = true;
        this.isCreated = true;
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BPELPropertySection.this.dispose();
            }
        });
    }

    protected abstract void createClient(Composite var1);

    public void dispose() {
        if (this.isCreated) {
            this.getCommandFramework().applyCurrentChange();
            this.removeAllAdapters();
        }
        this.isCreated = false;
    }

    public void refresh() {
        super.refresh();
        this.updateStatusLabels();
    }

    protected void updateStatusLabels() {
    }

    protected IMarker[] getMarkers(Object input) {
        IMarkerHolder markerHolder = BPELUtil.adapt(input, IMarkerHolder.class);
        if (markerHolder != null) {
            ArrayList<IMarker> filteredMarkers = new ArrayList<IMarker>(4);
            IMarker[] iMarkerArray = markerHolder.getMarkers(input);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker m = iMarkerArray[n2];
                if (this.isValidMarker(m)) {
                    filteredMarkers.add(m);
                }
                ++n2;
            }
            if (filteredMarkers.size() > 0) {
                return filteredMarkers.toArray(EMPTY_MARKERS);
            }
        }
        return EMPTY_MARKERS;
    }

    protected boolean markersHaveChanged(Notification n) {
        int eventGroup = n.getEventType() / 100;
        return eventGroup == 21;
    }

    protected void updateMarkers() {
    }

    protected CompoundCommand makeCompound(Command command) {
        if (command == null) {
            return null;
        }
        if (command instanceof CompoundCommand) {
            return (CompoundCommand)command;
        }
        CompoundCommand cc = new CompoundCommand();
        cc.add(command);
        return cc;
    }

    protected void runCommand(Command command) {
        this.getCommandFramework().execute(this.wrapInShowContextCommand(command));
    }

    protected ICommandFramework getCommandFramework() {
        BPELEditor editor = this.getBPELEditor();
        if (editor != null) {
            return editor.getCommandFramework();
        }
        return null;
    }

    public BPELEditor getBPELEditor() {
        if (this.fTabbedPropertySheetPage != null) {
            return this.fTabbedPropertySheetPage.getEditor();
        }
        return null;
    }

    public Process getProcess() {
        return this.getBPELEditor().getProcess();
    }

    protected EditController createEditController() {
        return new EditController(this.getCommandFramework()){

            @Override
            public Command createApplyCommand() {
                return BPELPropertySection.this.wrapInShowContextCommand(super.createApplyCommand());
            }
        };
    }

    protected Command wrapInShowContextCommand(Command inner) {
        return this.wrapInShowContextCommand(inner, this);
    }

    protected Command wrapInShowContextCommand(final Command inner, BPELPropertySection section) {
        int sectionIndex;
        final Object previousInput = section.getInput();
        final TabbedPropertyViewer viewer = this.getTabbedPropertySheetPage().getTabbedPropertyViewer();
        final int tabIndex = viewer.getSelectionIndex();
        int n = sectionIndex = this.getTabbedPropertySheetPage().getCurrentTab() == null ? -1 : this.getTabbedPropertySheetPage().getCurrentTab().getSectionIndex((ISection)section);
        if (!inner.canExecute()) {
            System.out.println("WARNING: unexecutable command passed to wrapInShowContextCommand():");
            System.out.println("    " + inner.getDebugLabel());
        }
        return new AbstractEditModelCommand(){
            Object beforeContext;
            Object afterContext;

            public String getLabel() {
                return inner.getLabel();
            }

            public void setLabel(String label) {
                inner.setLabel(label);
            }

            public String getDebugLabel() {
                return "ShowContext wrapper:[" + inner.getDebugLabel() + "]";
            }

            public boolean canExecute() {
                return inner.canExecute();
            }

            public void execute() {
                BPELPropertySection aSection = this.getSection(sectionIndex);
                this.beforeContext = aSection == null ? null : aSection.getUserContext();
                inner.execute();
                this.afterContext = aSection == null ? null : aSection.getUserContext();
            }

            public boolean canUndo() {
                return inner.canUndo();
            }

            public void undo() {
                inner.undo();
                this.showPropertiesTab();
                BPELPropertySection aSection = this.getSection(sectionIndex);
                if (aSection != null) {
                    aSection.restoreUserContext(this.beforeContext);
                }
            }

            public void redo() {
                inner.redo();
                this.showPropertiesTab();
                BPELPropertySection aSection = this.getSection(sectionIndex);
                if (aSection != null) {
                    aSection.restoreUserContext(this.afterContext);
                }
            }

            public void dispose() {
                inner.dispose();
            }

            protected BPELPropertySection getSection(int index) {
                TabContents tab = BPELPropertySection.this.getTabbedPropertySheetPage().getCurrentTab();
                if (tab != null) {
                    return (BPELPropertySection)tab.getSectionAtIndex(sectionIndex);
                }
                return null;
            }

            protected void showPropertiesTab() {
                Object selectedTab;
                BPELPropertySection.this.getBPELEditor().selectModelObject(previousInput);
                if (tabIndex != viewer.getSelectionIndex() && (selectedTab = viewer.getElementAt(tabIndex)) != null) {
                    viewer.setSelection((ISelection)new StructuredSelection(selectedTab));
                }
            }

            public Resource[] getResources() {
                return EditModelCommandStack.getResources((Command)inner);
            }

            public Resource[] getModifiedResources() {
                return EditModelCommandStack.getModifiedResources((Command)inner);
            }
        };
    }

    protected Composite createBorderComposite(Composite parent) {
        return BPELUtil.createBorderComposite(parent, this.fWidgetFactory);
    }

    protected Composite createFlatFormComposite(Composite parent) {
        Composite result = this.fWidgetFactory.createFlatFormComposite(parent);
        FlatFormLayout formLayout = new FlatFormLayout();
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        result.setLayout((Layout)formLayout);
        return result;
    }

    public BPELTabbedPropertySheetPage getTabbedPropertySheetPage() {
        return this.fTabbedPropertySheetPage;
    }

    public IFile getBPELFile() {
        return ((IFileEditorInput)this.getBPELEditor().getEditorInput()).getFile();
    }

    public Object getUserContext() {
        return null;
    }

    public void restoreUserContext(Object userContext) {
    }

    public void gotoMarker(IMarker marker) {
    }

    public boolean isValidMarker(IMarker marker) {
        return true;
    }

    public String[] getContextNames() {
        return new String[0];
    }

    protected void selectModelObject(final EObject target) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                BPELPropertySection.this.getBPELEditor().selectModelObject(target);
                new ShowPropertiesViewAction().run();
            }
        };
        Display.getDefault().asyncExec(runnable);
    }
}

