/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.commands;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.bpel.ui.commands.util.AutoUndoCommand;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public class DeleteNonContainmentRefsCommand
extends AutoUndoCommand {
    private Set<Object> fDeletingSet;
    private Set<Object> fModelRootSet;

    public DeleteNonContainmentRefsCommand(Set<Object> deletingSet, Set<Object> modelRootSet) {
        super(new ArrayList<Object>());
        this.fDeletingSet = deletingSet;
        this.fModelRootSet = modelRootSet;
        for (Object n : modelRootSet) {
            this.addModelRoot(n);
        }
    }

    @Override
    public void doExecute() {
        if (!this.canExecute()) {
            throw new IllegalStateException();
        }
        HashSet<Object> notDeletingSet = new HashSet<Object>();
        for (Object root : this.fModelRootSet) {
            TreeIterator it2 = ModelHelper.getAllContents(root);
            while (it2.hasNext()) {
                notDeletingSet.add(it2.next());
            }
        }
        notDeletingSet.removeAll(this.fDeletingSet);
        for (Object next : notDeletingSet) {
            BPELUtil.deleteNonContainmentRefs((EObject)next, this.fDeletingSet);
        }
    }
}

