/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtjsonrpc.client.impl.ser;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsonUtils;
import com.google.gwtjsonrpc.client.impl.JsonSerializer;

public class PrimitiveArraySerializer {
    public static final PrimitiveArraySerializer INSTANCE = new PrimitiveArraySerializer();

    private void printJsonWithToString(StringBuilder sb, Object[] o) {
        sb.append('[');
        int n = o.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(o[i] != null ? o[i].toString() : "null");
        }
        sb.append(']');
    }

    public void printJson(StringBuilder sb, Boolean[] o) {
        this.printJsonWithToString(sb, o);
    }

    public void printJson(StringBuilder sb, Byte[] o) {
        this.printJsonWithToString(sb, o);
    }

    public void printJson(StringBuilder sb, Character[] o) {
        sb.append('[');
        int n = o.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            if (o[i] != null) {
                sb.append(JsonUtils.escapeValue((String)String.valueOf(o[i])));
                continue;
            }
            sb.append("null");
        }
        sb.append(']');
    }

    public void printJson(StringBuilder sb, Double[] o) {
        this.printJsonWithToString(sb, o);
    }

    public void printJson(StringBuilder sb, Float[] o) {
        this.printJsonWithToString(sb, o);
    }

    public void printJson(StringBuilder sb, Integer[] o) {
        this.printJsonWithToString(sb, o);
    }

    public void printJson(StringBuilder sb, Short[] o) {
        this.printJsonWithToString(sb, o);
    }

    public void printJson(StringBuilder sb, boolean[] o) {
        sb.append('[');
        int n = o.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(o[i]);
        }
        sb.append(']');
    }

    public void printJson(StringBuilder sb, byte[] o) {
        sb.append('[');
        int n = o.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(o[i]);
        }
        sb.append(']');
    }

    public void printJson(StringBuilder sb, char[] o) {
        sb.append('[');
        int n = o.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(o[i]);
        }
        sb.append(']');
    }

    public void printJson(StringBuilder sb, double[] o) {
        sb.append('[');
        int n = o.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(o[i]);
        }
        sb.append(']');
    }

    public void printJson(StringBuilder sb, float[] o) {
        sb.append('[');
        int n = o.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(o[i]);
        }
        sb.append(']');
    }

    public void printJson(StringBuilder sb, int[] o) {
        sb.append('[');
        int n = o.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(o[i]);
        }
        sb.append(']');
    }

    public void printJson(StringBuilder sb, short[] o) {
        sb.append('[');
        int n = o.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(o[i]);
        }
        sb.append(']');
    }

    private static final native boolean getBoolean(JavaScriptObject var0, int var1);

    private static final native byte getByte(JavaScriptObject var0, int var1);

    private static final native String getString(JavaScriptObject var0, int var1);

    private static final native double getDouble(JavaScriptObject var0, int var1);

    private static final native float getFloat(JavaScriptObject var0, int var1);

    private static final native int getInteger(JavaScriptObject var0, int var1);

    private static final native short getShort(JavaScriptObject var0, int var1);

    public void fromJson(JavaScriptObject jso, Boolean[] r) {
        for (int i = 0; i < r.length; ++i) {
            r[i] = PrimitiveArraySerializer.getBoolean(jso, i);
        }
    }

    public void fromJson(JavaScriptObject jso, Byte[] r) {
        for (int i = 0; i < r.length; ++i) {
            r[i] = PrimitiveArraySerializer.getByte(jso, i);
        }
    }

    public void fromJson(JavaScriptObject jso, Character[] r) {
        for (int i = 0; i < r.length; ++i) {
            r[i] = Character.valueOf(JsonSerializer.toChar(PrimitiveArraySerializer.getString(jso, i)));
        }
    }

    public void fromJson(JavaScriptObject jso, Double[] r) {
        for (int i = 0; i < r.length; ++i) {
            r[i] = PrimitiveArraySerializer.getDouble(jso, i);
        }
    }

    public void fromJson(JavaScriptObject jso, Float[] r) {
        for (int i = 0; i < r.length; ++i) {
            r[i] = Float.valueOf(PrimitiveArraySerializer.getFloat(jso, i));
        }
    }

    public void fromJson(JavaScriptObject jso, Integer[] r) {
        for (int i = 0; i < r.length; ++i) {
            r[i] = PrimitiveArraySerializer.getInteger(jso, i);
        }
    }

    public void fromJson(JavaScriptObject jso, Short[] r) {
        for (int i = 0; i < r.length; ++i) {
            r[i] = PrimitiveArraySerializer.getShort(jso, i);
        }
    }

    public void fromJson(JavaScriptObject jso, boolean[] r) {
        for (int i = 0; i < r.length; ++i) {
            r[i] = PrimitiveArraySerializer.getBoolean(jso, i);
        }
    }

    public void fromJson(JavaScriptObject jso, byte[] r) {
        for (int i = 0; i < r.length; ++i) {
            r[i] = PrimitiveArraySerializer.getByte(jso, i);
        }
    }

    public void fromJson(JavaScriptObject jso, char[] r) {
        for (int i = 0; i < r.length; ++i) {
            r[i] = JsonSerializer.toChar(PrimitiveArraySerializer.getString(jso, i));
        }
    }

    public void fromJson(JavaScriptObject jso, double[] r) {
        for (int i = 0; i < r.length; ++i) {
            r[i] = PrimitiveArraySerializer.getDouble(jso, i);
        }
    }

    public void fromJson(JavaScriptObject jso, float[] r) {
        for (int i = 0; i < r.length; ++i) {
            r[i] = PrimitiveArraySerializer.getFloat(jso, i);
        }
    }

    public void fromJson(JavaScriptObject jso, int[] r) {
        for (int i = 0; i < r.length; ++i) {
            r[i] = PrimitiveArraySerializer.getInteger(jso, i);
        }
    }

    public void fromJson(JavaScriptObject jso, short[] r) {
        for (int i = 0; i < r.length; ++i) {
            r[i] = PrimitiveArraySerializer.getShort(jso, i);
        }
    }
}

