/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.strategy.paste;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.requests.ShowHideRelatedLinkRequest;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;

public class ShowConstraintContextLink
extends AbstractTransactionalCommand {
    protected DiagramEditPart diagramEP;
    protected Constraint constraint;

    public ShowConstraintContextLink(TransactionalEditingDomain domain, GraphicalEditPart targetEditPart, View constraintView) {
        super(domain, "Show Constraint Context Link", null);
        this.diagramEP = DiagramEditPartsUtil.getDiagramEditPart((EditPart)targetEditPart);
        this.constraint = (Constraint)constraintView.getElement();
    }

    public ShowConstraintContextLink(TransactionalEditingDomain domain, GraphicalEditPart targetEditPart, Constraint constraint) {
        super(domain, "Show Constraint Context Link", null);
        this.diagramEP = DiagramEditPartsUtil.getDiagramEditPart((EditPart)targetEditPart);
        this.constraint = constraint;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.diagramEP != null && this.getEditingDomain() != null) {
            this.diagramEP.refresh();
            Namespace context = this.constraint.getContext();
            Collection allTopSemanticEditPart = DiagramEditPartsUtil.getAllTopSemanticEditPart((EditPart)this.diagramEP);
            EditPart constraintEditPart = this.getEditPart((NamedElement)this.constraint, allTopSemanticEditPart);
            EditPart contextEditPart = this.getEditPart((NamedElement)context, allTopSemanticEditPart);
            if (constraintEditPart != null && contextEditPart != null) {
                ArrayList<EditPart> constraintAndContext = new ArrayList<EditPart>();
                constraintAndContext.add(constraintEditPart);
                constraintAndContext.add(contextEditPart);
                ShowHideRelatedLinkRequest request = new ShowHideRelatedLinkRequest(constraintAndContext, ShowHideRelatedLinkRequest.ShowHideKind.SHOW_ALL_LINK_BETWEEN_SELECTED_ELEMENT);
                Command cmd = this.diagramEP.getCommand((Request)request);
                if (cmd != null) {
                    cmd.execute();
                }
            }
        }
        return null;
    }

    protected EditPart getEditPart(NamedElement namedElement, Collection<EditPart> editPartCollection) {
        for (EditPart editPart : editPartCollection) {
            View view;
            EObject element;
            Object model = editPart.getModel();
            if (!(model instanceof View) || !namedElement.equals(element = (view = (View)model).getElement())) continue;
            return editPart;
        }
        return null;
    }
}

