/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.changeTracking.notification.recording;

import java.util.Date;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.notification.recording.Messages;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.notification.recording.NotificationRecording;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.notification.recording.NotificationRecordingHint;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.NotificationInfo;

public class NotificationRecorder {
    private boolean recordingComplete;
    private NotificationRecording recording;

    public void record(Notification n) {
        if (this.recording == null || this.isRecordingComplete()) {
            this.newRecording();
        }
        this.recording.record(n);
        this.updateRecordingComplete();
    }

    public NotificationRecording getRecording() {
        if (this.isRecordingComplete()) {
            return this.recording;
        }
        throw new IllegalStateException(Messages.NotificationRecorder_Unfinished_Recording);
    }

    public void stopRecording() {
        if (this.recording == null) {
            throw new IllegalStateException(Messages.NotificationRecorder_Empty_Recording);
        }
        if (this.lastNotificationHasFollowUps()) {
            throw new IllegalStateException(Messages.NotificationRecorder_Notification_Followups_Available);
        }
        this.recordingComplete = true;
    }

    private void updateRecordingComplete() {
        this.recordingComplete = this.recording != null && !this.recording.empty() && !this.recording.getHint().needsManualStopOfRecording() && !this.lastNotificationHasFollowUps();
    }

    private boolean lastNotificationHasFollowUps() {
        if (this.recording == null) {
            return false;
        }
        return this.notificationHasFollowUps(this.recording.getLastRecorded());
    }

    private boolean notificationHasFollowUps(NotificationInfo n) {
        if (n == null) {
            return false;
        }
        return n.hasNext();
    }

    public void newRecording() {
        this.newRecording(NotificationRecordingHint.DEFAULT);
    }

    public void newRecording(NotificationRecordingHint aHint) {
        if (this.recording != null && !this.isRecordingComplete()) {
            String message = Messages.NotificationRecorder_Uncomplete_Chain_Present;
            ModelUtil.logException((String)message, (Throwable)new IllegalStateException(message));
        }
        this.recording = new NotificationRecording();
        this.recording.setHint(aHint);
        this.recording.setDate(new Date());
        this.recordingComplete = false;
    }

    public boolean isRecordingComplete() {
        return this.recordingComplete;
    }
}

