/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.util.CDOFetchRule;
import org.eclipse.emf.cdo.server.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndication;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOClassInfo;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.RevisionInfo;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadRevisionsIndication
extends CDOServerReadIndication {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, LoadRevisionsIndication.class);
    private RevisionInfo[] infos;
    private CDOBranchPoint branchPoint;
    private int referenceChunk;
    private int prefetchDepth;
    private Map<EClass, CDOFetchRule> fetchRules = new HashMap<EClass, CDOFetchRule>();
    private CDOID contextID = CDOID.NULL;
    private int loadRevisionCollectionChunkSize;

    public LoadRevisionsIndication(CDOServerProtocol protocol) {
        super(protocol, (short)7);
    }

    @Override
    protected void indicating(CDODataInput in) throws IOException {
        int size;
        this.branchPoint = in.readCDOBranchPoint();
        if (TRACER.isEnabled()) {
            TRACER.format("Read branchPoint: {0}", new Object[]{this.branchPoint});
        }
        this.referenceChunk = in.readXInt();
        if (TRACER.isEnabled()) {
            TRACER.format("Read referenceChunk: {0}", new Object[]{this.referenceChunk});
        }
        if ((size = in.readXInt()) < 0) {
            size = -size;
            this.prefetchDepth = in.readXInt();
            if (TRACER.isEnabled()) {
                TRACER.format("Read prefetchDepth: {0}", new Object[]{this.prefetchDepth});
            }
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Reading {0} infos", new Object[]{size});
        }
        this.infos = new RevisionInfo[size];
        int i = 0;
        while (i < size) {
            RevisionInfo info = RevisionInfo.read((CDODataInput)in, (CDOBranchPoint)this.branchPoint);
            if (TRACER.isEnabled()) {
                TRACER.format("Read info: {0}", new Object[]{info});
            }
            this.infos[i] = info;
            ++i;
        }
        int fetchSize = in.readXInt();
        if (fetchSize > 0) {
            this.loadRevisionCollectionChunkSize = in.readXInt();
            if (this.loadRevisionCollectionChunkSize < 1) {
                this.loadRevisionCollectionChunkSize = 1;
            }
            this.contextID = in.readCDOID();
            if (TRACER.isEnabled()) {
                TRACER.format("Reading fetch rules for context {0}", new Object[]{this.contextID});
            }
            int i2 = 0;
            while (i2 < fetchSize) {
                CDOFetchRule fetchRule = new CDOFetchRule(in, (CDOPackageRegistry)this.getRepository().getPackageRegistry());
                this.fetchRules.put(fetchRule.getEClass(), fetchRule);
                ++i2;
            }
        }
    }

    @Override
    protected void responding(CDODataOutput out) throws IOException {
        RevisionInfo info;
        ArrayList<CDORevision> additionalRevisions = new ArrayList<CDORevision>();
        ArrayList<RevisionInfo> additionalRevisionInfos = new ArrayList<RevisionInfo>();
        HashSet<CDOID> revisionIDs = new HashSet<CDOID>();
        int size = this.infos.length;
        if (TRACER.isEnabled()) {
            TRACER.format("Writing {0} results", new Object[]{size});
        }
        RevisionInfo[] revisionInfoArray = this.infos;
        int n = this.infos.length;
        int n2 = 0;
        while (n2 < n) {
            RevisionInfo info2 = revisionInfoArray[n2];
            revisionIDs.add(info2.getID());
            ++n2;
        }
        HashSet<CDOFetchRule> visitedFetchRules = new HashSet<CDOFetchRule>();
        if (!CDOIDUtil.isNull((CDOID)this.contextID) && this.fetchRules.size() > 0) {
            if (TRACER.isEnabled()) {
                TRACER.format("Collecting more revisions based on rules", new Object[0]);
            }
            RevisionInfo info3 = this.getRevisionInfo(this.contextID);
            InternalCDORevision revisionContext = info3.getResult();
            this.collectRevisions(revisionContext, revisionIDs, additionalRevisionInfos, additionalRevisions, visitedFetchRules);
        }
        InternalCDORevisionManager revisionManager = this.getRepository().getRevisionManager();
        InternalCDORevision[] revisions = new InternalCDORevision[size];
        int i = 0;
        while (i < size) {
            info = this.infos[i];
            info.execute(revisionManager, this.referenceChunk);
            revisions[i] = info.getResult();
            if (this.loadRevisionCollectionChunkSize > 0) {
                this.collectRevisions(revisions[i], revisionIDs, additionalRevisionInfos, additionalRevisions, visitedFetchRules);
            }
            ++i;
        }
        if (this.prefetchDepth != 0) {
            this.prefetchRevisions(this.prefetchDepth > 0 ? this.prefetchDepth : Integer.MAX_VALUE, (CDORevision[])revisions, additionalRevisionInfos, additionalRevisions);
        }
        this.getRepository().notifyReadAccessHandlers(this.getSession(), (CDORevision[])revisions, additionalRevisions);
        i = 0;
        while (i < size) {
            info = this.infos[i];
            info.setResult(revisions[i]);
            info.writeResult(out, this.referenceChunk, this.branchPoint);
            ++i;
        }
        int additionalSize = additionalRevisionInfos.size();
        if (TRACER.isEnabled()) {
            TRACER.format("Writing {0} additional revision infos", new Object[]{additionalSize});
        }
        out.writeXInt(additionalSize);
        int i2 = 0;
        while (i2 < additionalSize) {
            InternalCDORevision revision = (InternalCDORevision)additionalRevisions.get(i2);
            RevisionInfo info4 = (RevisionInfo)additionalRevisionInfos.get(i2);
            info4.setResult(revision);
            out.write(RevisionInfo.Type.MISSING.ordinal());
            out.writeCDOID(info4.getID());
            info4.writeResult(out, this.referenceChunk, this.branchPoint);
            ++i2;
        }
    }

    private RevisionInfo getRevisionInfo(CDOID id) {
        RevisionInfo.Missing info = new RevisionInfo.Missing(id, this.branchPoint);
        info.execute(this.getRepository().getRevisionManager(), this.referenceChunk);
        return info;
    }

    private void collectRevisions(InternalCDORevision revision, Set<CDOID> revisions, List<RevisionInfo> additionalRevisionInfos, List<CDORevision> additionalRevisions, Set<CDOFetchRule> visitedFetchRules) {
        if (revision == null) {
            return;
        }
        this.getSession().collectContainedRevisions(revision, this.branchPoint, this.referenceChunk, revisions, additionalRevisions);
        CDOFetchRule fetchRule = this.fetchRules.get(revision.getEClass());
        if (fetchRule == null || visitedFetchRules.contains(fetchRule)) {
            return;
        }
        visitedFetchRules.add(fetchRule);
        for (EStructuralFeature feature : fetchRule.getFeatures()) {
            RevisionInfo info;
            InternalCDORevision containedRevision;
            CDOID id;
            if (feature.isMany()) {
                CDOList list = revision.getListOrNull(feature);
                if (list == null) continue;
                int toIndex = Math.min(this.loadRevisionCollectionChunkSize, list.size()) - 1;
                int i = 0;
                while (i <= toIndex) {
                    RevisionInfo info2;
                    InternalCDORevision containedRevision2;
                    CDOID id2;
                    Object value = list.get(i);
                    if (value instanceof CDOID && !CDOIDUtil.isNull((CDOID)(id2 = (CDOID)value)) && !revisions.contains(id2) && (containedRevision2 = (info2 = this.getRevisionInfo(id2)).getResult()) != null) {
                        additionalRevisionInfos.add(info2);
                        revisions.add(containedRevision2.getID());
                        additionalRevisions.add((CDORevision)containedRevision2);
                        this.collectRevisions(containedRevision2, revisions, additionalRevisionInfos, additionalRevisions, visitedFetchRules);
                    }
                    ++i;
                }
                continue;
            }
            Object value = revision.getValue(feature);
            if (!(value instanceof CDOID) || (id = (CDOID)value).isNull() || revisions.contains(id) || (containedRevision = (info = this.getRevisionInfo(id)).getResult()) == null) continue;
            revisions.add(containedRevision.getID());
            additionalRevisions.add((CDORevision)containedRevision);
            this.collectRevisions(containedRevision, revisions, additionalRevisionInfos, additionalRevisions, visitedFetchRules);
        }
        visitedFetchRules.remove(fetchRule);
    }

    private void prefetchRevisions(int depth, CDORevision[] revisions, List<RevisionInfo> additionalRevisionInfos, List<CDORevision> additionalRevisions) {
        CDORevision revision2;
        Map map = CDOIDUtil.createMap();
        CDORevision[] cDORevisionArray = revisions;
        int n = revisions.length;
        int n2 = 0;
        while (n2 < n) {
            revision2 = cDORevisionArray[n2];
            map.put(revision2.getID(), revision2);
            ++n2;
        }
        for (CDORevision revision2 : additionalRevisions) {
            map.put(revision2.getID(), revision2);
        }
        cDORevisionArray = revisions;
        n = revisions.length;
        int n3 = 0;
        while (n3 < n) {
            revision2 = cDORevisionArray[n3];
            this.prefetchRevision(depth, (InternalCDORevision)revision2, additionalRevisionInfos, additionalRevisions, map);
            ++n3;
        }
    }

    private void prefetchRevision(int depth, InternalCDORevision revision, List<RevisionInfo> additionalRevisionInfos, List<CDORevision> additionalRevisions, Map<CDOID, CDORevision> map) {
        InternalCDOClassInfo classInfo = revision.getClassInfo();
        EStructuralFeature[] eStructuralFeatureArray = classInfo.getAllPersistentFeatures();
        int n = eStructuralFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            EReference reference;
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            if (feature instanceof EReference && (reference = (EReference)feature).isContainment()) {
                Object value = revision.getValue((EStructuralFeature)reference);
                if (value instanceof CDOID) {
                    CDOID id = (CDOID)value;
                    this.prefetchRevisionChild(depth, id, additionalRevisionInfos, additionalRevisions, map);
                } else if (value instanceof Collection) {
                    Collection c = (Collection)value;
                    for (Object e : c) {
                        if (!(e instanceof CDOID)) continue;
                        CDOID id = (CDOID)e;
                        this.prefetchRevisionChild(depth, id, additionalRevisionInfos, additionalRevisions, map);
                    }
                }
            }
            ++n2;
        }
    }

    private void prefetchRevisionChild(int depth, CDOID id, List<RevisionInfo> additionalRevisionInfos, List<CDORevision> additionalRevisions, Map<CDOID, CDORevision> map) {
        RevisionInfo info;
        if (CDOIDUtil.isNull((CDOID)id)) {
            return;
        }
        CDORevision child = map.get(id);
        if (child == null && (child = (info = this.getRevisionInfo(id)).getResult()) != null) {
            map.put(id, child);
            additionalRevisions.add(child);
            additionalRevisionInfos.add(info);
        }
        if (child != null && depth > 0) {
            this.prefetchRevision(depth - 1, (InternalCDORevision)child, additionalRevisionInfos, additionalRevisions, map);
        }
    }
}

