/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.i18n.Messages;

public class MappedTables {
    private Map tables = new HashMap();
    private String nameSpacePart;
    private String[] parameters;

    public MappedTables(String tableMappings) throws OdaException {
        String last;
        String[] temp;
        assert (tableMappings != null);
        String[] mappings = tableMappings.split("#-#");
        if (mappings.length > 0 && (temp = (last = mappings[mappings.length - 1].trim()).split("#:#")).length == 4) {
            String nameSpace = temp[3].trim();
            if (!nameSpace.startsWith("<") || !nameSpace.endsWith(">")) {
                throw new OdaException(Messages.getString("Query.InvalidQueryText"));
            }
            this.nameSpacePart = nameSpace.substring(1, nameSpace.length() - 1);
        }
        ArrayList temp2 = new ArrayList();
        HashSet detected = new HashSet();
        int i = 0;
        while (i < mappings.length) {
            Table t = new Table(mappings[i]);
            this.tables.put(t.tableName, t);
            String[] ps = t.detectParameters();
            MappedTables.addParameters(temp2, detected, ps);
            ++i;
        }
        this.parameters = new String[temp2.size()];
        i = 0;
        while (i < this.parameters.length) {
            this.parameters[i] = (String)temp2.get(i);
            ++i;
        }
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public void setParameterValue(String paraName, String value) {
        for (Table t : this.tables.values()) {
            t.setParameterValue(paraName, value);
        }
    }

    public int getColumnCount(String tableName) throws OdaException {
        Table t = (Table)this.tables.get(tableName);
        if (t != null) {
            return t.columns.length;
        }
        return 0;
    }

    public String getColumnName(String tableName, int index) throws OdaException {
        Table t = (Table)this.tables.get(tableName);
        if (t != null) {
            return t.columns[index - 1].name;
        }
        return null;
    }

    public String getColumnType(String tableName, int index) throws OdaException {
        Table t = (Table)this.tables.get(tableName);
        if (t != null) {
            return t.columns[index - 1].type;
        }
        return null;
    }

    public int getColumnIndex(String tableName, String columnName) throws OdaException {
        Table t = (Table)this.tables.get(tableName);
        if (t != null) {
            return t.getColumnIndex(columnName);
        }
        return -1;
    }

    public String getNameSpacePart() {
        return this.nameSpacePart;
    }

    public Collection getTables() {
        return this.tables.values();
    }

    private static void addParameters(List result, Set added, String[] ps) {
        int i = 0;
        while (i < ps.length) {
            String p = ps[i];
            if (!added.contains(p)) {
                added.add(p);
                result.add(p);
            }
            ++i;
        }
    }

    public static String[] detectParameters(String path) {
        assert (path != null);
        int beginFlagIndex = path.indexOf("{?");
        if (beginFlagIndex < 0) {
            return new String[0];
        }
        int endFlagIndex = path.indexOf("?}", beginFlagIndex + "{?".length());
        if (endFlagIndex < 0) {
            return new String[0];
        }
        String p = path.substring(beginFlagIndex + "{?".length(), endFlagIndex).trim();
        if (p.length() > 0) {
            if (endFlagIndex + "?}".length() < path.length()) {
                ArrayList<String> temp = new ArrayList<String>();
                temp.add(p);
                String[] others = MappedTables.detectParameters(path.substring(endFlagIndex + "?}".length()));
                int i = 0;
                while (i < others.length) {
                    if (!p.equals(others[i])) {
                        temp.add(others[i]);
                    }
                    ++i;
                }
                String[] result = new String[temp.size()];
                int i2 = 0;
                while (i2 < result.length) {
                    result[i2] = (String)temp.get(i2);
                    ++i2;
                }
                return result;
            }
            return new String[]{p};
        }
        if (endFlagIndex + "?}".length() < path.length()) {
            return MappedTables.detectParameters(path.substring(endFlagIndex + "?}".length()));
        }
        return new String[0];
    }

    public static String setParameterValue(String originalPath, String paraName, String value) {
        String regex = "\\Q{?\\E *\\Q" + paraName + "\\E" + " *\\Q" + "?}" + "\\E";
        return originalPath.replaceAll(regex, value);
    }

    public static class Column {
        private String name;
        private String type;
        private String path;

        public Column(String name, String type, String path) {
            this.name = name;
            this.type = type;
            this.path = path;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getPath() {
            return this.path;
        }

        public void setParameterValue(String paraName, String value) {
            this.path = MappedTables.setParameterValue(this.path, paraName, value);
        }
    }

    public static class Table {
        private String tableName;
        private String rowPath;
        private Column[] columns;
        private Map columnNameIndexMap = new HashMap();

        public Table(String mappingText) throws OdaException {
            ArrayList<Column> cs = new ArrayList<Column>();
            String[] temp = mappingText.trim().split("#:#");
            if (temp.length < 2) {
                throw new OdaException(Messages.getString("Query.InvalidQueryText"));
            }
            this.tableName = temp[0].trim();
            this.rowPath = temp[1].trim();
            if (!this.rowPath.startsWith("[") || !this.rowPath.endsWith("]")) {
                throw new OdaException(Messages.getString("Query.InvalidQueryText"));
            }
            this.rowPath = this.rowPath.substring(1, this.rowPath.length() - 1);
            String[] columnMappings = new String[]{};
            if (temp.length >= 3 && temp[2].trim().length() > 0) {
                columnMappings = temp[2].trim().split(",");
            }
            int i = 0;
            while (i < columnMappings.length) {
                String trimedColumn = columnMappings[i].trim();
                if (!trimedColumn.startsWith("{") || !trimedColumn.endsWith("}")) {
                    throw new OdaException(Messages.getString("Query.InvalidQueryText"));
                }
                String[] columnInfos = trimedColumn.substring(1, trimedColumn.length() - 1).split(";");
                if (columnInfos.length < 2) {
                    throw new OdaException(Messages.getString("Query.InvalidQueryText"));
                }
                String columnPath = "";
                if (columnInfos.length >= 3) {
                    columnPath = columnInfos[2].trim();
                }
                Column c = new Column(columnInfos[0].trim(), columnInfos[1].trim(), columnPath);
                cs.add(c);
                ++i;
            }
            this.columns = new Column[cs.size()];
            cs.toArray(this.columns);
            i = 0;
            while (i < this.columns.length) {
                this.columnNameIndexMap.put(this.columns[i].name, i + 1);
                ++i;
            }
        }

        public int getColumnIndex(String columnName) {
            Integer index = (Integer)this.columnNameIndexMap.get(columnName);
            return index == null ? -1 : index;
        }

        public String getName() {
            return this.tableName;
        }

        public Column[] getColumns() {
            return this.columns;
        }

        public String getRowPath() {
            return this.rowPath;
        }

        public String[] detectParameters() {
            ArrayList temp = new ArrayList();
            HashSet detected = new HashSet();
            String[] ps = MappedTables.detectParameters(this.getRowPath());
            MappedTables.addParameters(temp, detected, ps);
            int i = 0;
            while (i < this.getColumns().length) {
                ps = MappedTables.detectParameters(this.getColumns()[i].getPath());
                MappedTables.addParameters(temp, detected, ps);
                ++i;
            }
            String[] result = new String[temp.size()];
            int i2 = 0;
            while (i2 < result.length) {
                result[i2] = (String)temp.get(i2);
                ++i2;
            }
            return result;
        }

        public void setParameterValue(String paraName, String value) {
            this.rowPath = MappedTables.setParameterValue(this.rowPath, paraName, value);
            int i = 0;
            while (i < this.columns.length) {
                this.columns[i].setParameterValue(paraName, value);
                ++i;
            }
        }
    }
}

