/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal.ui.view;

import org.eclipse.cdt.testsrunner.model.ITestingSession;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ProgressBar
extends Canvas {
    private static final int DEFAULT_WIDTH = 160;
    private static final int DEFAULT_HEIGHT = 18;
    private ITestingSession testingSession;
    private int colorBarWidth;
    private Color okColor;
    private Color failureColor;
    private Color stoppedColor;

    public ProgressBar(Composite parent, ITestingSession testingSession) {
        super(parent, 0);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ProgressBar.this.updateInfoFromSession();
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ProgressBar.this.paint(e);
            }
        });
        Display display = parent.getDisplay();
        this.failureColor = new Color((Device)display, 159, 63, 63);
        this.okColor = new Color((Device)display, 95, 191, 95);
        this.stoppedColor = new Color((Device)display, 120, 120, 120);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ProgressBar.this.failureColor.dispose();
                ProgressBar.this.okColor.dispose();
                ProgressBar.this.stoppedColor.dispose();
            }
        });
        this.setTestingSession(testingSession);
    }

    public void setTestingSession(ITestingSession testingSession) {
        this.testingSession = testingSession;
        this.updateInfoFromSession();
    }

    public void updateInfoFromSession() {
        this.recalculateColorBarWidth();
        this.redraw();
    }

    private void setStatusColor(GC gc) {
        if (this.testingSession.wasStopped()) {
            gc.setBackground(this.stoppedColor);
        } else if (this.testingSession.hasErrors()) {
            gc.setBackground(this.failureColor);
        } else {
            gc.setBackground(this.okColor);
        }
    }

    private void recalculateColorBarWidth() {
        Rectangle r = this.getClientArea();
        int newColorBarWidth = this.testingSession.getTotalCounter() > 0 ? this.testingSession.getCurrentCounter() * (r.width - 2) / this.testingSession.getTotalCounter() : (this.testingSession.getCurrentCounter() > 0 ? (r.width - 2) / 2 : (this.testingSession.isFinished() ? r.width - 2 : 0));
        this.colorBarWidth = Math.max(0, newColorBarWidth);
    }

    private void drawBevelRect(GC gc, int x, int y, int w, int h, Color topleft, Color bottomright) {
        gc.setForeground(topleft);
        gc.drawLine(x, y, x + w - 1, y);
        gc.drawLine(x, y, x, y + h - 1);
        gc.setForeground(bottomright);
        gc.drawLine(x + w, y, x + w, y + h);
        gc.drawLine(x, y + h, x + w, y + h);
    }

    private void paint(PaintEvent event) {
        GC gc = event.gc;
        Display disp = this.getDisplay();
        Rectangle rect = this.getClientArea();
        gc.fillRectangle(rect);
        this.drawBevelRect(gc, rect.x, rect.y, rect.width - 1, rect.height - 1, disp.getSystemColor(18), disp.getSystemColor(20));
        this.setStatusColor(gc);
        this.colorBarWidth = Math.min(rect.width - 2, this.colorBarWidth);
        gc.fillRectangle(1, 1, this.colorBarWidth, rect.height - 2);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point size = new Point(160, 18);
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        return size;
    }
}

