/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import java.util.Locale;
import org.eclipse.bpel.common.ui.details.DelegateIValue;
import org.eclipse.bpel.common.ui.details.FocusContext;
import org.eclipse.bpel.common.ui.details.IValue;
import org.eclipse.bpel.common.ui.details.TextIValue;
import org.eclipse.bpel.common.ui.details.ViewerIValue;
import org.eclipse.bpel.common.ui.details.widgets.DecoratedLabel;
import org.eclipse.bpel.common.ui.details.widgets.StatusLabel2;
import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.model.BPELExtensibleElement;
import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.model.Documentation;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.commands.SetCommand;
import org.eclipse.bpel.ui.details.providers.LanguageContentProvider;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.bpel.ui.properties.EditController;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.MultiObjectAdapter;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class DocumentationSection
extends BPELPropertySection {
    protected Text fSourceText;
    protected StatusLabel2 fSourceLabel;
    protected StatusLabel2 fLangLabel;
    protected Text fDescription;
    protected StatusLabel2 fDescriptionLabel;
    protected Documentation fDocumentation;
    protected Combo fLangCombo;
    protected ComboViewer fLangViewer;
    EditController fValueEditHelper;
    EditController fSourceEditHelper;
    EditController fLangEditHelper;
    IValue fContext;
    BPELExtensibleElement fModelEE;

    @Override
    protected MultiObjectAdapter[] createAdapters() {
        return new MultiObjectAdapter[]{new MultiObjectAdapter(){

            @Override
            public void notify(Notification n) {
                Documentation eObj;
                if (DocumentationSection.this.markersHaveChanged(n)) {
                    DocumentationSection.this.updateMarkers();
                    return;
                }
                if (n.getFeature() == BPELPackage.eINSTANCE.getBPELExtensibleElement_Documentation() && (eObj = (Documentation)n.getNewValue()) != DocumentationSection.this.fDocumentation) {
                    DocumentationSection.this.fValueEditHelper.setInput((EObject)eObj);
                    DocumentationSection.this.fSourceEditHelper.setInput((EObject)eObj);
                    DocumentationSection.this.fLangEditHelper.setInput((EObject)eObj);
                    DocumentationSection.this.fDocumentation = eObj;
                }
            }
        }};
    }

    CompoundCommand attachDocumentationCommand() {
        CompoundCommand ccmd = null;
        if (this.fDocumentation.eContainer() == null) {
            ccmd = new CompoundCommand();
            this.fDocumentation.setSource(this.fSourceText.getText());
            this.fDocumentation.setLang(this.fLangCombo.getText());
            this.fDocumentation.setValue(this.fDescription.getText());
            ccmd.add((Command)new SetCommand((EObject)this.fModelEE, this.fDocumentation, (EStructuralFeature)BPELPackage.eINSTANCE.getBPELExtensibleElement_Documentation()));
        }
        return ccmd;
    }

    @Override
    protected void basicSetInput(EObject input) {
        this.saveUserContextToInput();
        super.basicSetInput(input);
        this.restoreUserContextFromInput();
        if (!(input instanceof BPELExtensibleElement)) {
            throw new IllegalArgumentException("input must be BPELExtensibleElement");
        }
        this.fModelEE = (BPELExtensibleElement)input;
        this.fDocumentation = this.fModelEE.getDocumentation();
        if (this.fDocumentation == null) {
            this.fDocumentation = BPELFactory.eINSTANCE.createDocumentation();
        }
        this.fValueEditHelper.setInput((EObject)this.fDocumentation);
        this.fSourceEditHelper.setInput((EObject)this.fDocumentation);
        this.fLangEditHelper.setInput((EObject)this.fDocumentation);
    }

    protected void createSourceWidgets(Composite composite) {
        DecoratedLabel nameLabel = new DecoratedLabel(composite, 16384);
        this.fWidgetFactory.adapt((Composite)nameLabel);
        nameLabel.setText(Messages.DocumentationSection_Source_1);
        this.fSourceLabel = new StatusLabel2(nameLabel);
        this.fSourceText = this.fWidgetFactory.createText(composite, "");
        this.fSourceText.setData("name", (Object)"source");
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(5, BPELUtil.calculateLabelWidth((Widget)nameLabel, 131));
        data.right = new FlatFormAttachment(100, -10);
        data.top = new FlatFormAttachment(0, 0);
        this.fSourceText.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 5);
        data.right = new FlatFormAttachment((Control)this.fSourceText, 0);
        data.top = new FlatFormAttachment((Control)this.fSourceText, 0, 0x1000000);
        nameLabel.setLayoutData((Object)data);
    }

    protected void createLanguageWidgets(Composite composite) {
        DecoratedLabel nameLabel = new DecoratedLabel(composite, 16384);
        this.fWidgetFactory.adapt((Composite)nameLabel);
        nameLabel.setText(Messages.DocumentationSection_Language_1);
        this.fLangLabel = new StatusLabel2(nameLabel);
        this.fLangCombo = new Combo(composite, 8);
        this.fWidgetFactory.adapt((Composite)this.fLangCombo);
        this.fLangCombo.setData("name", (Object)"language");
        this.fLangViewer = new ComboViewer(this.fLangCombo);
        this.fLangViewer.setContentProvider((IContentProvider)new LanguageContentProvider());
        this.fLangViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                Locale locale = (Locale)element;
                return locale.getDisplayName();
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.fLangViewer.setInput((Object)Locale.getDefault());
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(5, BPELUtil.calculateLabelWidth((Widget)nameLabel, 131));
        data.top = new FlatFormAttachment(this.fSourceLabel.getControl(), 5);
        this.fLangCombo.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 5);
        data.right = new FlatFormAttachment((Control)this.fLangCombo, 0);
        data.top = new FlatFormAttachment((Control)this.fLangCombo, 0, 0x1000000);
        nameLabel.setLayoutData((Object)data);
    }

    protected void createDescriptionWidgets(Composite composite) {
        DecoratedLabel nameLabel = new DecoratedLabel(composite, 16384);
        this.fWidgetFactory.adapt((Composite)nameLabel);
        nameLabel.setText(Messages.DocumentationSection_Description_1);
        this.fDescriptionLabel = new StatusLabel2(nameLabel);
        this.fDescription = this.fWidgetFactory.createText(composite, "", 514);
        this.fDescription.setData("name", (Object)"description");
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(5, BPELUtil.calculateLabelWidth((Widget)nameLabel, 131));
        data.right = new FlatFormAttachment(100, -10);
        data.top = new FlatFormAttachment((Control)this.fLangCombo, 5);
        data.bottom = new FlatFormAttachment(100, -12);
        this.fDescription.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 5);
        data.right = new FlatFormAttachment((Control)this.fDescription, -5);
        data.top = new FlatFormAttachment((Control)this.fDescription, 4, 128);
        nameLabel.setLayoutData((Object)data);
    }

    @Override
    protected EditController createEditController() {
        return new EditController(this.getCommandFramework()){

            @Override
            public Command createApplyCommand() {
                CompoundCommand cmd = DocumentationSection.this.attachDocumentationCommand();
                if (cmd != null) {
                    cmd.add(super.createApplyCommand());
                    return DocumentationSection.this.wrapInShowContextCommand((Command)cmd);
                }
                return DocumentationSection.this.wrapInShowContextCommand(super.createApplyCommand());
            }
        };
    }

    protected void createChangeTrackers() {
        this.fValueEditHelper = this.createEditController();
        this.fValueEditHelper.setFeature((EStructuralFeature)BPELPackage.eINSTANCE.getDocumentation_Value());
        this.fValueEditHelper.setViewIValue((IValue)new TextIValue(this.fDescription));
        this.fValueEditHelper.startListeningTo(new Control[]{this.fDescription});
        this.fSourceEditHelper = this.createEditController();
        this.fSourceEditHelper.setFeature((EStructuralFeature)BPELPackage.eINSTANCE.getDocumentation_Source());
        this.fSourceEditHelper.setViewIValue((IValue)new TextIValue(this.fSourceText));
        this.fSourceEditHelper.startListeningTo(new Control[]{this.fSourceText});
        this.fLangEditHelper = this.createEditController();
        this.fLangEditHelper.setFeature((EStructuralFeature)BPELPackage.eINSTANCE.getDocumentation_Lang());
        this.fLangEditHelper.setViewIValue((IValue)new DelegateIValue((IValue)new ViewerIValue((StructuredViewer)this.fLangViewer)){

            public Object get() {
                Locale locale = (Locale)this.fDelegate.get();
                return locale.getLanguage();
            }

            public void set(Object object) {
                this.fDelegate.set((Object)BPELUtils.lookupLocaleFor((String)((String)object)));
            }
        });
        this.fLangEditHelper.startListeningTo(new Control[]{this.fLangCombo});
    }

    @Override
    protected void createClient(Composite parent) {
        Composite composite = this.createFlatFormComposite(parent);
        this.createSourceWidgets(composite);
        this.createLanguageWidgets(composite);
        this.createDescriptionWidgets(composite);
        this.fContext = new FocusContext(new Control[]{this.fDescription, this.fSourceText, this.fLangCombo});
        this.createChangeTrackers();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.bpel.ui.property_documentation");
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    @Override
    protected void updateMarkers() {
        this.fSourceLabel.clear();
        IMarker[] iMarkerArray = this.getMarkers(this.getInput());
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker m = iMarkerArray[n2];
            this.fSourceLabel.addStatus(BPELUtil.adapt((Object)m, IStatus.class));
            ++n2;
        }
    }

    @Override
    public Object getUserContext() {
        return this.fContext.get();
    }

    @Override
    public void restoreUserContext(Object userContext) {
        this.fContext.set(userContext);
    }

    @Override
    public void gotoMarker(IMarker marker) {
    }

    @Override
    public boolean isValidMarker(IMarker marker) {
        return false;
    }
}

