/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.StyleEvent;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.core.StyledElement;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.util.CommandLabelFactory;

public class StyleRecord
extends SimpleRecord {
    protected StyledElement element = null;
    protected Object oldStyle = null;
    protected ElementRefValue newStyle = null;

    public StyleRecord(StyledElement obj, ElementRefValue newStyle) {
        assert (obj != null);
        this.element = obj;
        this.newStyle = newStyle;
        this.oldStyle = this.element.getStyle() != null ? this.element.getStyle() : this.element.getStyleName();
        this.label = CommandLabelFactory.getCommandLabel("Message.SetStyle");
    }

    @Override
    protected void perform(boolean undo) {
        if (undo) {
            if (this.oldStyle instanceof String) {
                this.element.setStyleName((String)this.oldStyle);
            } else {
                this.element.setStyle((StyleElement)this.oldStyle);
            }
        } else if (this.newStyle == null) {
            this.element.setStyle(null);
        } else {
            StyleElement tmpStyle = (StyleElement)this.newStyle.getElement();
            if (tmpStyle != null) {
                this.element.setStyle(tmpStyle);
            } else if (this.newStyle.getName() != null) {
                this.element.setStyleName(this.newStyle.getName());
            } else {
                this.element.setStyle(null);
            }
        }
    }

    @Override
    public DesignElement getTarget() {
        return this.element;
    }

    @Override
    public NotificationEvent getEvent() {
        return new StyleEvent(this.element);
    }
}

