/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.ui.script.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.birt.report.debug.internal.core.launcher.IReportLaunchConstants;
import org.eclipse.birt.report.debug.internal.core.launcher.ReportLauncher;
import org.eclipse.birt.report.debug.internal.ui.script.launcher.ReportLaunchHelper;
import org.eclipse.birt.report.debug.internal.ui.script.launcher.ScriptDebugClasspathProvider;
import org.eclipse.birt.report.debug.internal.ui.script.launcher.StandardScriptVMRunner;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaLaunchDelegate;
import org.eclipse.jdt.launching.JavaRuntime;

public class ReportStandardAppLaunchDelegate
extends JavaLaunchDelegate
implements IReportLaunchConstants {
    static final String CORE_BIN = "CoreOutput";
    static final String UI_BIN = "UIOutput";
    ReportLaunchHelper helper = new ReportLaunchHelper();

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.helper.init(configuration);
        super.launch(configuration, mode, launch, monitor);
    }

    public File verifyWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        return null;
    }

    public String[] getJavaLibraryPath(ILaunchConfiguration configuration) throws CoreException {
        return null;
    }

    public IVMRunner getVMRunner(ILaunchConfiguration configuration, String mode) throws CoreException {
        IVMInstall vm = this.verifyVMInstall(configuration);
        return new StandardScriptVMRunner(vm, this);
    }

    public String verifyMainTypeName(ILaunchConfiguration configuration) throws CoreException {
        return ReportLauncher.class.getName();
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        return super.getBuildOrder(configuration, mode);
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        boolean bool = super.finalLaunchCheck(configuration, mode, monitor);
        if (!bool) {
            return bool;
        }
        return this.helper.finalLaunchCheck(configuration, mode, monitor);
    }

    String getFileName() {
        return this.helper.fileName;
    }

    String getEngineHome() {
        return this.helper.engineHome;
    }

    String getTempFolder() {
        return this.helper.tempFolder;
    }

    String getTargetFormat() {
        return this.helper.targetFormat;
    }

    boolean isOpenTargetFile() {
        return this.helper.isOpenTargetFile;
    }

    int getDebugType() {
        return this.helper.debugType;
    }

    int getTaskType() {
        return this.helper.taskType;
    }

    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        ScriptDebugClasspathProvider provider = new ScriptDebugClasspathProvider();
        IRuntimeClasspathEntry[] entries = provider.computeExtraBootClasspath(configuration);
        entries = JavaRuntime.resolveRuntimeClasspath((IRuntimeClasspathEntry[])entries, (ILaunchConfiguration)configuration);
        ArrayList<String> userEntries = new ArrayList<String>(entries.length);
        HashSet<String> set = new HashSet<String>(entries.length);
        int i = 0;
        while (i < entries.length) {
            String location;
            if (entries[i].getClasspathProperty() == 3 && (location = entries[i].getLocation()) != null && !set.contains(location)) {
                userEntries.add(location);
                set.add(location);
            }
            ++i;
        }
        return userEntries.toArray(new String[userEntries.size()]);
    }
}

