/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.io.ByteArrayUtil;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.nativerdf.NativeStore;
import org.eclipse.rdf4j.sail.nativerdf.ValueStore;
import org.eclipse.rdf4j.sail.nativerdf.btree.RecordIterator;
import org.eclipse.rdf4j.sail.nativerdf.model.CorruptIRI;
import org.eclipse.rdf4j.sail.nativerdf.model.CorruptIRIOrBNode;
import org.eclipse.rdf4j.sail.nativerdf.model.CorruptUnknownValue;
import org.eclipse.rdf4j.sail.nativerdf.model.NativeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NativeStatementIterator
implements CloseableIteration<Statement> {
    private static final Logger logger = LoggerFactory.getLogger(NativeStatementIterator.class);
    private final RecordIterator btreeIter;
    private final ValueStore valueStore;
    private Statement nextElement;
    private boolean closed = false;

    public NativeStatementIterator(RecordIterator btreeIter, ValueStore valueStore) {
        this.btreeIter = btreeIter;
        this.valueStore = valueStore;
    }

    public Statement getNextElement() throws SailException {
        try {
            byte[] nextValue;
            try {
                nextValue = this.btreeIter.next();
            }
            catch (AssertionError | Exception e) {
                logger.error("Error while reading next value from btree iterator for {}", (Object)this.btreeIter.toString(), e);
                throw e;
            }
            if (nextValue == null) {
                return null;
            }
            int subjID = ByteArrayUtil.getInt((byte[])nextValue, (int)0);
            Object subj = (Resource)this.valueStore.getResource(subjID);
            int predID = ByteArrayUtil.getInt((byte[])nextValue, (int)4);
            IRI pred = (IRI)this.valueStore.getIRI(predID);
            int objID = ByteArrayUtil.getInt((byte[])nextValue, (int)8);
            NativeValue obj = this.valueStore.getValue(objID);
            Resource context = null;
            int contextID = ByteArrayUtil.getInt((byte[])nextValue, (int)12);
            if (contextID != 0) {
                context = (Resource)this.valueStore.getResource(contextID);
            }
            if (NativeStore.SOFT_FAIL_ON_CORRUPT_DATA_AND_REPAIR_INDEXES) {
                if (subj == null) {
                    subj = new CorruptIRIOrBNode(this.valueStore.getRevision(), subjID, null);
                }
                if (pred == null) {
                    pred = new CorruptIRI(this.valueStore.getRevision(), predID, null, null);
                }
                if (obj == null) {
                    obj = new CorruptUnknownValue(this.valueStore.getRevision(), objID, null);
                }
            }
            return this.valueStore.createStatement((Resource)subj, pred, obj, context);
        }
        catch (IOException e) {
            throw this.causeIOException(e);
        }
    }

    protected void handleClose() throws SailException {
        try {
            this.btreeIter.close();
        }
        catch (IOException e) {
            throw this.causeIOException(e);
        }
    }

    protected SailException causeIOException(IOException e) {
        return new SailException((Throwable)e);
    }

    public final boolean hasNext() {
        if (this.isClosed()) {
            return false;
        }
        try {
            return this.lookAhead() != null;
        }
        catch (NoSuchElementException logged) {
            logger.trace("LookAheadIteration threw NoSuchElementException:", (Throwable)logged);
            return false;
        }
    }

    public final Statement next() {
        if (this.isClosed()) {
            throw new NoSuchElementException("The iteration has been closed.");
        }
        Statement result = this.lookAhead();
        if (result != null) {
            this.nextElement = null;
            return result;
        }
        throw new NoSuchElementException();
    }

    private Statement lookAhead() {
        if (this.nextElement == null) {
            this.nextElement = this.getNextElement();
            if (this.nextElement == null) {
                this.close();
            }
        }
        return this.nextElement;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public final boolean isClosed() {
        return this.closed;
    }

    public final void close() {
        if (!this.closed) {
            this.closed = true;
            this.handleClose();
        }
    }
}

