/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.uri;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import no.hasmac.jsonld.StringUtils;

public final class Path {
    public static final Path EMPTY = new Path(new ArrayList<String>(), null, true);
    private final List<String> segments;
    private final String last;
    private final boolean relative;

    private Path(List<String> segments, String last, boolean relative) {
        this.segments = segments;
        this.last = last;
        this.relative = relative;
    }

    public static Path of(String path) {
        boolean relative = !path.startsWith("/");
        ArrayList<String> segments = new ArrayList<String>(Arrays.asList((relative ? path : path.substring(1)).split("/")));
        String last = path.length() > 1 && path.endsWith("/") ? null : (String)segments.remove(segments.size() - 1);
        return new Path(segments, last == null || StringUtils.isBlank(last) ? null : last, relative);
    }

    public Path relativize(String base) {
        return this.relativize(Path.of(base));
    }

    public Path relativize(Path base) {
        int i;
        int rightIndex;
        int leftIndex;
        if (this.segments.isEmpty() && base.segments.isEmpty()) {
            if (Objects.equals(this.last, base.last)) {
                return new Path(Path.EMPTY.segments, null, !base.relative);
            }
            return new Path(Path.EMPTY.segments, this.last, !this.relative && !base.relative);
        }
        if (base.segments.isEmpty() && base.last == null) {
            return new Path(this.segments, this.last, !base.relative && !this.relative);
        }
        for (leftIndex = 0; leftIndex < Math.min(this.segments.size(), base.segments.size()) && this.segments.get(leftIndex).equals(base.segments.get(leftIndex)); ++leftIndex) {
        }
        if (leftIndex == this.segments.size() && leftIndex == base.segments.size()) {
            if (Objects.equals(this.last, base.last)) {
                return EMPTY;
            }
            return new Path(Path.EMPTY.segments, this.last, !this.segments.isEmpty());
        }
        if (leftIndex >= base.segments.size()) {
            if (this.segments.size() - leftIndex == 1 && this.segments.get(leftIndex).equals(base.last)) {
                return new Path(Arrays.asList("."), this.last, true);
            }
            return new Path(this.segments.subList(leftIndex, this.segments.size()), this.last, true);
        }
        ArrayList<String> diff = new ArrayList<String>();
        for (rightIndex = 0; rightIndex < Math.min(this.segments.size(), base.segments.size()) - leftIndex && this.segments.get(this.segments.size() - rightIndex - 1).equals(base.segments.get(base.segments.size() - rightIndex - 1)); ++rightIndex) {
            diff.add("..");
        }
        for (i = 0; i < base.segments.size() - leftIndex - rightIndex; ++i) {
            diff.add("..");
        }
        for (i = 0; i < this.segments.size() - leftIndex - rightIndex; ++i) {
            diff.add(this.segments.get(i + leftIndex));
        }
        return new Path(diff, Objects.equals(this.last, base.last) ? null : this.last, true);
    }

    public boolean isEmpty() {
        return this.segments.isEmpty() && this.last == null && !this.relative;
    }

    public boolean isNotEmpty() {
        return !this.segments.isEmpty() || this.last != null || !this.relative;
    }

    public boolean isRelative() {
        return this.relative;
    }

    public String toString() {
        return (this.relative ? "" : "/").concat(String.join((CharSequence)"/", this.segments)).concat(this.segments.isEmpty() ? "" : "/").concat(this.last != null ? this.last : "");
    }

    public String getLeaf() {
        return this.last;
    }
}

