/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.util;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.ModelFactory;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.impl.DynamicModelFactory;
import org.eclipse.rdf4j.model.impl.TreeModelFactory;

public class ModelCollector
implements Collector<Statement, Model, Model> {
    private final ModelFactory factory;

    public ModelCollector() {
        this.factory = new DynamicModelFactory();
    }

    public ModelCollector(ModelFactory factory) {
        this.factory = factory;
    }

    public static ModelCollector toModel() {
        return new ModelCollector();
    }

    public static ModelCollector toTreeModel() {
        return new ModelCollector(new TreeModelFactory());
    }

    @Override
    public Supplier<Model> supplier() {
        return () -> this.factory.createEmptyModel();
    }

    @Override
    public BiConsumer<Model, Statement> accumulator() {
        return (m, s) -> {
            Model model = m;
            synchronized (model) {
                m.add(s);
            }
        };
    }

    @Override
    public BinaryOperator<Model> combiner() {
        return (m1, m2) -> {
            m1.addAll((Collection)m2);
            return m1;
        };
    }

    @Override
    public Function<Model, Model> finisher() {
        return Function.identity();
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return EnumSet.of(Collector.Characteristics.CONCURRENT, Collector.Characteristics.IDENTITY_FINISH, Collector.Characteristics.UNORDERED);
    }
}

