/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.lmdb.LmdbUtil;
import org.eclipse.rdf4j.sail.lmdb.Varint;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.lmdb.LMDB;
import org.lwjgl.util.lmdb.MDBStat;
import org.lwjgl.util.lmdb.MDBVal;

final class TxnRecordCache {
    private final Path dbDir;
    private final long env;
    private final int dbiExplicit;
    private final int dbiInferred;
    private long writeTxn;
    private long mapSize = 0x100000L;
    private long pageSize;

    public TxnRecordCache(File cacheDir) throws IOException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pp = stack.mallocPointer(1);
            LmdbUtil.E(LMDB.mdb_env_create((PointerBuffer)pp));
            this.env = pp.get(0);
            LmdbUtil.E(LMDB.mdb_env_set_maxdbs((long)this.env, (int)2));
            LmdbUtil.E(LMDB.mdb_env_set_mapsize((long)this.env, (long)this.mapSize));
            int flags = 0x250000;
            this.dbDir = Files.createTempDirectory(cacheDir.toPath(), "txncache", new FileAttribute[0]);
            LmdbUtil.E(LMDB.mdb_env_open((long)this.env, (CharSequence)this.dbDir.toAbsolutePath().toString(), (int)flags, (int)436));
            this.dbiExplicit = LmdbUtil.openDatabase(this.env, "quads", 262144, null);
            this.dbiInferred = LmdbUtil.openDatabase(this.env, "quads-inf", 262144, null);
            MDBStat stat = MDBStat.malloc((MemoryStack)stack);
            LmdbUtil.readTransaction(this.env, (stack2, txn) -> {
                LmdbUtil.E(LMDB.mdb_stat((long)txn, (int)this.dbiExplicit, (MDBStat)stat));
                this.pageSize = stat.ms_psize();
                return null;
            });
            LmdbUtil.E(LMDB.mdb_txn_begin((long)this.env, (long)0L, (int)0, (PointerBuffer)pp));
            this.writeTxn = pp.get(0);
        }
    }

    public void close() throws IOException {
        LMDB.mdb_env_close((long)this.env);
        FileUtils.deleteDirectory((File)this.dbDir.toFile());
    }

    protected void commit() throws IOException {
        if (this.writeTxn != 0L) {
            LmdbUtil.E(LMDB.mdb_txn_commit((long)this.writeTxn));
            this.writeTxn = 0L;
        }
    }

    protected boolean storeRecord(long[] quad, boolean explicit) throws IOException {
        return this.update(quad, explicit, true);
    }

    protected void removeRecord(long[] quad, boolean explicit) throws IOException {
        this.update(quad, explicit, false);
    }

    protected boolean update(long[] quad, boolean explicit, boolean add) throws IOException {
        MemoryStack stack;
        if (LmdbUtil.requiresResize(this.mapSize, this.pageSize, this.writeTxn, 0L)) {
            LmdbUtil.E(LMDB.mdb_txn_commit((long)this.writeTxn));
            this.mapSize = LmdbUtil.autoGrowMapSize(this.mapSize, this.pageSize, 0L);
            LmdbUtil.E(LMDB.mdb_env_set_mapsize((long)this.env, (long)this.mapSize));
            stack = MemoryStack.stackPush();
            try {
                PointerBuffer pp = stack.mallocPointer(1);
                LmdbUtil.E(LMDB.mdb_txn_begin((long)this.env, (long)0L, (int)0, (PointerBuffer)pp));
                this.writeTxn = pp.get(0);
            }
            finally {
                if (stack != null) {
                    stack.close();
                }
            }
        }
        stack = MemoryStack.stackPush();
        try {
            boolean found;
            MDBVal keyVal = MDBVal.malloc((MemoryStack)stack);
            MDBVal dataVal = MDBVal.calloc((MemoryStack)stack);
            ByteBuffer keyBuf = stack.malloc(36);
            Varint.writeListUnsigned(keyBuf, quad);
            keyBuf.flip();
            keyVal.mv_data(keyBuf);
            boolean foundExplicit = LmdbUtil.E(LMDB.mdb_get((long)this.writeTxn, (int)this.dbiExplicit, (MDBVal)keyVal, (MDBVal)dataVal)) == 0 && (dataVal.mv_data().get(0) & 1) != 0;
            boolean foundImplicit = !foundExplicit && LmdbUtil.E(LMDB.mdb_get((long)this.writeTxn, (int)this.dbiInferred, (MDBVal)keyVal, (MDBVal)dataVal)) == 0 && (dataVal.mv_data().get(0) & 1) != 0;
            boolean bl = found = foundExplicit || foundImplicit;
            if (add) {
                if (!found || explicit && foundImplicit) {
                    if (explicit && foundImplicit) {
                        LmdbUtil.E(LMDB.mdb_del((long)this.writeTxn, (int)this.dbiInferred, (MDBVal)keyVal, (MDBVal)dataVal));
                    }
                    dataVal.mv_data(stack.bytes((byte)1));
                    LmdbUtil.E(LMDB.mdb_put((long)this.writeTxn, (int)(explicit ? this.dbiExplicit : this.dbiInferred), (MDBVal)keyVal, (MDBVal)dataVal, (int)0));
                }
                boolean bl2 = !found;
                return bl2;
            }
            if (foundExplicit && explicit || foundImplicit && !explicit) {
                LmdbUtil.E(LMDB.mdb_del((long)this.writeTxn, (int)(explicit ? this.dbiExplicit : this.dbiInferred), (MDBVal)keyVal, (MDBVal)dataVal));
            } else {
                dataVal.mv_data(stack.bytes((byte)0));
                LmdbUtil.E(LMDB.mdb_put((long)this.writeTxn, (int)(explicit ? this.dbiExplicit : this.dbiInferred), (MDBVal)keyVal, (MDBVal)dataVal, (int)0));
            }
            boolean bl3 = true;
            return bl3;
        }
        finally {
            if (stack != null) {
                stack.close();
            }
        }
    }

    protected RecordCacheIterator getRecords(boolean explicit) throws IOException {
        return new RecordCacheIterator(explicit ? this.dbiExplicit : this.dbiInferred);
    }

    protected class RecordCacheIterator {
        private final MDBVal keyData = MDBVal.malloc();
        private final MDBVal valueData = MDBVal.malloc();
        private long txn;
        private final long cursor;
        private final int dbi;
        private final long[] quad = new long[4];

        protected RecordCacheIterator(int dbi) throws IOException {
            this.dbi = dbi;
            try (MemoryStack stack = MemoryStack.stackPush();){
                PointerBuffer pp = stack.mallocPointer(1);
                LmdbUtil.E(LMDB.mdb_txn_begin((long)TxnRecordCache.this.env, (long)0L, (int)131072, (PointerBuffer)pp));
                this.txn = pp.get(0);
                LmdbUtil.E(LMDB.mdb_cursor_open((long)this.txn, (int)dbi, (PointerBuffer)pp));
                this.cursor = pp.get(0);
            }
        }

        public Record next() {
            try {
                if (LmdbUtil.E(LMDB.mdb_cursor_get((long)this.cursor, (MDBVal)this.keyData, (MDBVal)this.valueData, (int)8)) == 0) {
                    Varint.readListUnsigned(this.keyData.mv_data(), this.quad);
                    byte op = this.valueData.mv_data().get(0);
                    Record r = new Record();
                    r.quad = this.quad;
                    r.add = op == 1;
                    return r;
                }
            }
            catch (IOException e) {
                throw new SailException(e);
            }
            this.close();
            return null;
        }

        public void close() {
            if (this.txn != 0L) {
                this.keyData.close();
                this.valueData.close();
                LMDB.mdb_cursor_close((long)this.cursor);
                LMDB.mdb_txn_abort((long)this.txn);
                this.txn = 0L;
            }
        }
    }

    static class Record {
        long[] quad;
        boolean add;

        Record() {
        }
    }
}

