/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.command;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.io.IOUtil;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.console.Util;
import org.eclipse.rdf4j.console.command.ConsoleCommand;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.repository.RepositoryReadOnlyException;
import org.eclipse.rdf4j.repository.config.ConfigTemplate;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigSchema;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.jline.reader.EndOfFileException;
import org.jline.reader.UserInterruptException;

public class Create
extends ConsoleCommand {
    private static final String TEMPLATES_SUBDIR = "templates";
    private static final String FILE_EXT = ".ttl";
    private final File templatesDir;

    @Override
    public String getName() {
        return "create";
    }

    @Override
    public String getHelpShort() {
        return "Creates a new repository";
    }

    @Override
    public String getHelpLong() {
        return "Usage:\ncreate <template>   Create a new repository using this configuration template\n  built-in: \n" + Util.formatToWidth(80, "    ", this.getBuiltinTemplates(), ", ") + "\n  template-dir (" + this.templatesDir + "):\n" + Util.formatToWidth(80, "    ", this.getUserTemplates(), ", ");
    }

    public Create(ConsoleIO consoleIO, ConsoleState state) {
        super(consoleIO, state);
        this.templatesDir = new File(state.getDataDirectory(), TEMPLATES_SUBDIR);
    }

    @Override
    public void execute(String ... tokens) {
        if (tokens.length < 2) {
            this.writeln(this.getHelpLong());
        } else {
            this.createRepository(tokens[1]);
        }
    }

    private String getOrderedTemplates(Path path) throws IOException {
        try (Stream<Path> walk = Files.walk(path, new FileVisitOption[0]);){
            String string = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(f -> f.getFileName().toString()).filter(s -> s.endsWith(FILE_EXT)).map(s -> s.substring(0, s.length() - FILE_EXT.length())).sorted().collect(Collectors.joining(", "));
            return string;
        }
    }

    private String getUserTemplates() {
        if (this.templatesDir == null || !this.templatesDir.exists() || !this.templatesDir.isDirectory()) {
            return "";
        }
        try {
            return this.getOrderedTemplates(this.templatesDir.toPath());
        }
        catch (IOException ioe) {
            this.writeError("Failed to read templates directory repository ", ioe);
            return "";
        }
    }

    private String getBuiltinTemplates() {
        block8: {
            String string;
            block9: {
                Class<RepositoryConfig> cl = RepositoryConfig.class;
                URI dir = cl.getResource(cl.getSimpleName() + ".class").toURI();
                if (!dir.getScheme().equals("jar")) break block8;
                FileSystem fs = FileSystems.newFileSystem(dir, Collections.EMPTY_MAP, null);
                try {
                    String pkg = cl.getPackage().getName().replaceAll("\\.", "/");
                    string = this.getOrderedTemplates(fs.getPath(pkg, new String[0]));
                    if (fs == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (fs != null) {
                            try {
                                fs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | NullPointerException | URISyntaxException e) {
                        this.writeError("Could not get built-in config templates from JAR", e);
                    }
                }
                fs.close();
            }
            return string;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRepository(String templateName) {
        block11: {
            try {
                String template;
                String templateFileName = templateName + FILE_EXT;
                File templateFile = new File(this.templatesDir, templateFileName);
                InputStream templateStream = this.createTemplateStream(templateName, templateFileName, this.templatesDir, templateFile);
                if (templateStream == null) break block11;
                try {
                    template = IOUtil.readString((Reader)new InputStreamReader(templateStream, StandardCharsets.UTF_8));
                }
                finally {
                    templateStream.close();
                }
                ConfigTemplate configTemplate = new ConfigTemplate(template);
                HashMap<String, String> valueMap = new HashMap<String, String>();
                Map variableMap = configTemplate.getVariableMap();
                boolean eof = this.inputParameters(valueMap, variableMap, configTemplate.getMultilineMap());
                if (!eof) {
                    boolean proceedInvalid;
                    String configString = configTemplate.render(valueMap);
                    LinkedHashModel graph = new LinkedHashModel();
                    RDFParser rdfParser = Rio.createParser((RDFFormat)RDFFormat.TURTLE, (ValueFactory)SimpleValueFactory.getInstance());
                    rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)graph));
                    rdfParser.parse((Reader)new StringReader(configString), "http://www.openrdf.org/config/repository#");
                    Resource repositoryNode = (Resource)Models.subject((Iterable)graph.getStatements(null, RDF.TYPE, (Value)RepositoryConfigSchema.REPOSITORY, new Resource[0])).orElseThrow(() -> new RepositoryConfigException("missing repository node"));
                    RepositoryConfig repConfig = RepositoryConfig.create((Model)graph, (Resource)repositoryNode);
                    repConfig.validate();
                    String overwrite = "WARNING: you are about to overwrite the configuration of an existing repository!";
                    boolean proceedOverwrite = this.state.getManager().hasRepositoryConfig(repConfig.getID()) ? this.askProceed(overwrite, false) : true;
                    String suggested = this.state.getManager().getNewRepositoryID(repConfig.getID());
                    String invalid = "WARNING: There are potentially incompatible characters in the repository id.";
                    boolean bl = proceedInvalid = !suggested.startsWith(repConfig.getID()) ? this.askProceed(invalid, false) : true;
                    if (proceedInvalid && proceedOverwrite) {
                        try {
                            this.state.getManager().addRepositoryConfig(repConfig);
                            this.writeInfo("Repository created");
                        }
                        catch (RepositoryReadOnlyException e) {
                            this.state.getManager().addRepositoryConfig(repConfig);
                            this.writeInfo("Repository created");
                        }
                    } else {
                        this.writeln("Create aborted");
                    }
                }
            }
            catch (EndOfFileException | UserInterruptException e) {
                this.writeError("Create repository aborted", (Exception)e);
                throw e;
            }
            catch (Exception e) {
                this.writeError("Failed to create repository", e);
            }
        }
    }

    private boolean inputParameters(Map<String, String> valueMap, Map<String, List<String>> variableMap, Map<String, String> multilineInput) {
        if (!variableMap.isEmpty()) {
            this.writeln("Please specify values for the following variables:");
        }
        boolean eof = false;
        for (Map.Entry<String, List<String>> entry : variableMap.entrySet()) {
            String var = entry.getKey();
            List<String> values = entry.getValue();
            StringBuilder sb = new StringBuilder();
            sb.append(var);
            if (values.size() > 1) {
                sb.append(" (");
                for (int i = 0; i < values.size(); ++i) {
                    if (i > 0) {
                        sb.append("|");
                    }
                    sb.append(values.get(i));
                }
                sb.append(")");
            }
            if (!values.isEmpty()) {
                sb.append(" [" + values.get(0) + "]");
            }
            String prompt = sb.append(": ").toString();
            String value = multilineInput.containsKey(var) ? this.consoleIO.readMultiLineInput(prompt) : this.consoleIO.readln(prompt);
            boolean bl = eof = value == null;
            if (eof) break;
            if ((value = value.trim()).length() == 0) {
                value = null;
            }
            valueMap.put(var, value);
        }
        return eof;
    }

    private InputStream createTemplateStream(String templateName, String templateFileName, File templatesDir, File templateFile) throws FileNotFoundException {
        InputStream templateStream = null;
        if (templateFile.exists()) {
            if (templateFile.canRead()) {
                templateStream = new FileInputStream(templateFile);
            } else {
                this.writeError("Not allowed to read template file: " + templateFile);
            }
        } else {
            templateStream = RepositoryConfig.class.getResourceAsStream(templateFileName);
            if (templateStream == null) {
                this.writeError("No template called " + templateName + " found in " + templatesDir);
            }
        }
        return templateStream;
    }
}

