/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.VariableScopeChange;
import org.eclipse.rdf4j.query.algebra.helpers.QueryModelTreePrinter;

public abstract class AbstractQueryModelNode
implements QueryModelNode,
VariableScopeChange {
    private static final double CARDINALITY_NOT_SET = Double.MIN_VALUE;
    private static final long serialVersionUID = 3006199552086476178L;
    @JsonIgnore
    private QueryModelNode parent;
    private boolean isVariableScopeChange;
    private double resultSizeEstimate = -1.0;
    private long resultSizeActual = -1L;
    private double costEstimate = -1.0;
    private long totalTimeNanosActual = -1L;
    private double cardinality = Double.MIN_VALUE;

    @Override
    public QueryModelNode getParentNode() {
        return this.parent;
    }

    @Override
    public void setParentNode(QueryModelNode parent) {
        this.parent = parent;
    }

    @Override
    public boolean isVariableScopeChange() {
        return this.isVariableScopeChange;
    }

    @Override
    public void setVariableScopeChange(boolean isVariableScopeChange) {
        this.isVariableScopeChange = isVariableScopeChange;
    }

    @Override
    public void replaceWith(QueryModelNode replacement) {
        if (this.parent == null) {
            throw new IllegalStateException("Node has no parent");
        }
        this.parent.replaceChildNode(this, replacement);
    }

    @Override
    public String getSignature() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String toString() {
        QueryModelTreePrinter treePrinter = new QueryModelTreePrinter();
        this.visit(treePrinter);
        return treePrinter.getTreeString();
    }

    @Override
    public AbstractQueryModelNode clone() {
        try {
            AbstractQueryModelNode clone = (AbstractQueryModelNode)super.clone();
            clone.setVariableScopeChange(this.isVariableScopeChange());
            clone.cardinality = Double.MIN_VALUE;
            clone.parent = null;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Query model nodes are required to be cloneable", e);
        }
    }

    protected <T extends QueryModelNode> boolean replaceNodeInList(List<T> list, QueryModelNode current, QueryModelNode replacement) {
        ListIterator<T> iter = list.listIterator();
        while (iter.hasNext()) {
            if (iter.next() != current) continue;
            iter.set(replacement);
            replacement.setParentNode(this);
            return true;
        }
        return false;
    }

    protected boolean nullEquals(Object o1, Object o2) {
        return Objects.equals(o1, o2);
    }

    @Override
    public double getResultSizeEstimate() {
        return this.resultSizeEstimate;
    }

    @Override
    public void setResultSizeEstimate(double resultSizeEstimate) {
        this.resultSizeEstimate = resultSizeEstimate;
    }

    @Override
    public long getResultSizeActual() {
        return this.resultSizeActual;
    }

    @Override
    public void setResultSizeActual(long resultSizeActual) {
        this.resultSizeActual = resultSizeActual;
    }

    @Override
    public double getCostEstimate() {
        return this.costEstimate;
    }

    @Override
    public void setCostEstimate(double costEstimate) {
        this.costEstimate = costEstimate;
    }

    @Override
    public long getTotalTimeNanosActual() {
        return this.totalTimeNanosActual;
    }

    @Override
    public void setTotalTimeNanosActual(long totalTimeNanosActual) {
        this.totalTimeNanosActual = totalTimeNanosActual;
    }

    static String toHumanReadbleNumber(double number) {
        Object humanReadbleString = number == Double.POSITIVE_INFINITY ? "\u221e" : (number > 1000000.0 ? (double)Math.round(number / 100000.0) / 10.0 + "M" : (number > 1000.0 ? (double)Math.round(number / 100.0) / 10.0 + "K" : (number >= 0.0 ? "" + Math.round(number) : "UNKNOWN")));
        return humanReadbleString;
    }

    @Experimental
    public double getCardinality() {
        assert (this.cardinality != Double.MIN_VALUE);
        return this.cardinality;
    }

    @Experimental
    public void setCardinality(double cardinality) {
        this.cardinality = cardinality;
    }

    @Experimental
    public void resetCardinality() {
        this.cardinality = Double.MIN_VALUE;
    }

    @Experimental
    public boolean isCardinalitySet() {
        return this.shouldCacheCardinality() && this.cardinality != Double.MIN_VALUE;
    }

    @Experimental
    protected boolean shouldCacheCardinality() {
        return false;
    }
}

