/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iteration;

import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;

public abstract class FilterIteration<E>
implements CloseableIteration<E> {
    private final CloseableIteration<? extends E> wrappedIter;
    private E nextElement;
    private boolean closed = false;

    protected FilterIteration(CloseableIteration<? extends E> iter) {
        assert (iter != null);
        this.wrappedIter = iter;
    }

    @Override
    public boolean hasNext() {
        boolean result;
        if (this.isClosed()) {
            return false;
        }
        this.findNextElement();
        boolean bl = result = this.nextElement != null;
        if (!result) {
            this.close();
        }
        return result;
    }

    @Override
    public E next() {
        if (this.isClosed()) {
            throw new NoSuchElementException("The iteration has been closed.");
        }
        this.findNextElement();
        E result = this.nextElement;
        if (result != null) {
            this.nextElement = null;
            return result;
        }
        this.close();
        throw new NoSuchElementException("The iteration has been closed.");
    }

    private void findNextElement() {
        if (this.nextElement != null) {
            return;
        }
        try {
            if (!this.isClosed()) {
                if (Thread.currentThread().isInterrupted()) {
                    this.close();
                    return;
                }
                boolean result = this.wrappedIter.hasNext();
                if (!result) {
                    this.close();
                    return;
                }
            }
            while (this.nextElement == null && this.wrappedIter.hasNext()) {
                Object result;
                if (Thread.currentThread().isInterrupted()) {
                    this.close();
                    return;
                }
                try {
                    result = this.wrappedIter.next();
                }
                catch (NoSuchElementException e) {
                    this.close();
                    throw e;
                }
                Object candidate = result;
                if (!this.accept(candidate)) continue;
                this.nextElement = candidate;
            }
        }
        finally {
            if (this.isClosed()) {
                this.nextElement = null;
            }
        }
    }

    protected abstract boolean accept(E var1);

    @Override
    public void remove() {
        if (this.isClosed()) {
            throw new IllegalStateException("The iteration has been closed.");
        }
        if (Thread.currentThread().isInterrupted()) {
            this.close();
            throw new IllegalStateException("The iteration has been interrupted.");
        }
        try {
            this.wrappedIter.remove();
        }
        catch (IllegalStateException e) {
            this.close();
            throw e;
        }
    }

    private boolean isClosed() {
        return this.closed;
    }

    protected abstract void handleClose();

    @Override
    public final void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                this.wrappedIter.close();
            }
            finally {
                this.handleClose();
            }
        }
    }
}

