/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.vocabulary;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.vocabulary.Vocabularies;

public class XSD {
    public static final String NAMESPACE = "http://www.w3.org/2001/XMLSchema#";
    public static final String PREFIX = "xsd";
    public static final Namespace NS = Vocabularies.createNamespace("xsd", "http://www.w3.org/2001/XMLSchema#");
    public static final IRI DURATION = CoreDatatype.XSD.DURATION.getIri();
    public static final IRI DATETIME = CoreDatatype.XSD.DATETIME.getIri();
    public static final IRI DATETIMESTAMP = CoreDatatype.XSD.DATETIMESTAMP.getIri();
    public static final IRI DAYTIMEDURATION = CoreDatatype.XSD.DAYTIMEDURATION.getIri();
    public static final IRI TIME = CoreDatatype.XSD.TIME.getIri();
    public static final IRI DATE = CoreDatatype.XSD.DATE.getIri();
    public static final IRI GYEARMONTH = CoreDatatype.XSD.GYEARMONTH.getIri();
    public static final IRI GYEAR = CoreDatatype.XSD.GYEAR.getIri();
    public static final IRI GMONTHDAY = CoreDatatype.XSD.GMONTHDAY.getIri();
    public static final IRI GDAY = CoreDatatype.XSD.GDAY.getIri();
    public static final IRI GMONTH = CoreDatatype.XSD.GMONTH.getIri();
    public static final IRI STRING = CoreDatatype.XSD.STRING.getIri();
    public static final IRI BOOLEAN = CoreDatatype.XSD.BOOLEAN.getIri();
    public static final IRI BASE64BINARY = CoreDatatype.XSD.BASE64BINARY.getIri();
    public static final IRI HEXBINARY = CoreDatatype.XSD.HEXBINARY.getIri();
    public static final IRI FLOAT = CoreDatatype.XSD.FLOAT.getIri();
    public static final IRI DECIMAL = CoreDatatype.XSD.DECIMAL.getIri();
    public static final IRI DOUBLE = CoreDatatype.XSD.DOUBLE.getIri();
    public static final IRI ANYURI = CoreDatatype.XSD.ANYURI.getIri();
    public static final IRI QNAME = CoreDatatype.XSD.QNAME.getIri();
    public static final IRI NOTATION = CoreDatatype.XSD.NOTATION.getIri();
    public static final IRI NORMALIZEDSTRING = CoreDatatype.XSD.NORMALIZEDSTRING.getIri();
    public static final IRI TOKEN = CoreDatatype.XSD.TOKEN.getIri();
    public static final IRI LANGUAGE = CoreDatatype.XSD.LANGUAGE.getIri();
    public static final IRI NMTOKEN = CoreDatatype.XSD.NMTOKEN.getIri();
    public static final IRI NMTOKENS = CoreDatatype.XSD.NMTOKENS.getIri();
    public static final IRI NAME = CoreDatatype.XSD.NAME.getIri();
    public static final IRI NCNAME = CoreDatatype.XSD.NCNAME.getIri();
    public static final IRI ID = CoreDatatype.XSD.ID.getIri();
    public static final IRI IDREF = CoreDatatype.XSD.IDREF.getIri();
    public static final IRI IDREFS = CoreDatatype.XSD.IDREFS.getIri();
    public static final IRI ENTITY = CoreDatatype.XSD.ENTITY.getIri();
    public static final IRI ENTITIES = CoreDatatype.XSD.ENTITIES.getIri();
    public static final IRI INTEGER = CoreDatatype.XSD.INTEGER.getIri();
    public static final IRI LONG = CoreDatatype.XSD.LONG.getIri();
    public static final IRI INT = CoreDatatype.XSD.INT.getIri();
    public static final IRI SHORT = CoreDatatype.XSD.SHORT.getIri();
    public static final IRI BYTE = CoreDatatype.XSD.BYTE.getIri();
    public static final IRI NON_POSITIVE_INTEGER = CoreDatatype.XSD.NON_POSITIVE_INTEGER.getIri();
    public static final IRI NEGATIVE_INTEGER = CoreDatatype.XSD.NEGATIVE_INTEGER.getIri();
    public static final IRI NON_NEGATIVE_INTEGER = CoreDatatype.XSD.NON_NEGATIVE_INTEGER.getIri();
    public static final IRI POSITIVE_INTEGER = CoreDatatype.XSD.POSITIVE_INTEGER.getIri();
    public static final IRI UNSIGNED_LONG = CoreDatatype.XSD.UNSIGNED_LONG.getIri();
    public static final IRI UNSIGNED_INT = CoreDatatype.XSD.UNSIGNED_INT.getIri();
    public static final IRI UNSIGNED_SHORT = CoreDatatype.XSD.UNSIGNED_SHORT.getIri();
    public static final IRI UNSIGNED_BYTE = CoreDatatype.XSD.UNSIGNED_BYTE.getIri();
    public static final IRI YEARMONTHDURATION = CoreDatatype.XSD.YEARMONTHDURATION.getIri();

    private static IRI create(String localName) {
        return Vocabularies.createIRI(NAMESPACE, localName);
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public static enum Datatype {
        DURATION(CoreDatatype.XSD.DURATION.getIri(), true, true, false, false, false, false, false),
        DATETIME(CoreDatatype.XSD.DATETIME.getIri(), true, false, false, false, false, false, true),
        DATETIMESTAMP(CoreDatatype.XSD.DATETIMESTAMP.getIri(), false, false, false, true, false, false, true),
        DAYTIMEDURATION(CoreDatatype.XSD.DAYTIMEDURATION.getIri(), false, true, false, true, false, false, false),
        TIME(CoreDatatype.XSD.TIME.getIri(), true, false, false, false, false, false, true),
        DATE(CoreDatatype.XSD.DATE.getIri(), true, false, false, false, false, false, true),
        GYEARMONTH(CoreDatatype.XSD.GYEARMONTH.getIri(), true, false, false, false, false, false, true),
        GYEAR(CoreDatatype.XSD.GYEAR.getIri(), true, false, false, false, false, false, true),
        GMONTHDAY(CoreDatatype.XSD.GMONTHDAY.getIri(), true, false, false, false, false, false, true),
        GDAY(CoreDatatype.XSD.GDAY.getIri(), true, false, false, false, false, false, true),
        GMONTH(CoreDatatype.XSD.GMONTH.getIri(), true, false, false, false, false, false, true),
        STRING(CoreDatatype.XSD.STRING.getIri(), true, false, false, false, false, false, false),
        BOOLEAN(CoreDatatype.XSD.BOOLEAN.getIri(), true, false, false, false, false, false, false),
        BASE64BINARY(CoreDatatype.XSD.BASE64BINARY.getIri(), true, false, false, false, false, false, false),
        HEXBINARY(CoreDatatype.XSD.HEXBINARY.getIri(), true, false, false, false, false, false, false),
        FLOAT(CoreDatatype.XSD.FLOAT.getIri(), true, false, false, false, false, true, false),
        DECIMAL(CoreDatatype.XSD.DECIMAL.getIri(), true, false, false, false, true, false, false),
        DOUBLE(CoreDatatype.XSD.DOUBLE.getIri(), true, false, false, false, false, true, false),
        ANYURI(CoreDatatype.XSD.ANYURI.getIri(), true, false, false, false, false, false, false),
        QNAME(CoreDatatype.XSD.QNAME.getIri(), true, false, false, false, false, false, false),
        NOTATION(CoreDatatype.XSD.NOTATION.getIri(), true, false, false, false, false, false, false),
        NORMALIZEDSTRING(CoreDatatype.XSD.NORMALIZEDSTRING.getIri(), false, false, false, true, false, false, false),
        TOKEN(CoreDatatype.XSD.TOKEN.getIri(), false, false, false, true, false, false, false),
        LANGUAGE(CoreDatatype.XSD.LANGUAGE.getIri(), false, false, false, true, false, false, false),
        NMTOKEN(CoreDatatype.XSD.NMTOKEN.getIri(), false, false, false, true, false, false, false),
        NMTOKENS(CoreDatatype.XSD.NMTOKENS.getIri(), false, false, false, true, false, false, false),
        NAME(CoreDatatype.XSD.NAME.getIri(), false, false, false, true, false, false, false),
        NCNAME(CoreDatatype.XSD.NCNAME.getIri(), false, false, false, true, false, false, false),
        ID(CoreDatatype.XSD.ID.getIri(), false, false, false, true, false, false, false),
        IDREF(CoreDatatype.XSD.IDREF.getIri(), false, false, false, true, false, false, false),
        IDREFS(CoreDatatype.XSD.IDREFS.getIri(), false, false, false, true, false, false, false),
        ENTITY(CoreDatatype.XSD.ENTITY.getIri(), false, false, false, true, false, false, false),
        ENTITIES(CoreDatatype.XSD.ENTITIES.getIri(), false, false, false, true, false, false, false),
        INTEGER(CoreDatatype.XSD.INTEGER.getIri(), false, false, true, true, true, false, false),
        LONG(CoreDatatype.XSD.LONG.getIri(), false, false, true, true, true, false, false),
        INT(CoreDatatype.XSD.INT.getIri(), false, false, true, true, true, false, false),
        SHORT(CoreDatatype.XSD.SHORT.getIri(), false, false, true, true, true, false, false),
        BYTE(CoreDatatype.XSD.BYTE.getIri(), false, false, true, true, true, false, false),
        NON_POSITIVE_INTEGER(CoreDatatype.XSD.NON_POSITIVE_INTEGER.getIri(), false, false, true, true, true, false, false),
        NEGATIVE_INTEGER(CoreDatatype.XSD.NEGATIVE_INTEGER.getIri(), false, false, true, true, true, false, false),
        NON_NEGATIVE_INTEGER(CoreDatatype.XSD.NON_NEGATIVE_INTEGER.getIri(), false, false, true, true, true, false, false),
        POSITIVE_INTEGER(CoreDatatype.XSD.POSITIVE_INTEGER.getIri(), false, false, true, true, true, false, false),
        UNSIGNED_LONG(CoreDatatype.XSD.UNSIGNED_LONG.getIri(), false, false, true, true, true, false, false),
        UNSIGNED_INT(CoreDatatype.XSD.UNSIGNED_INT.getIri(), false, false, true, true, true, false, false),
        UNSIGNED_SHORT(CoreDatatype.XSD.UNSIGNED_SHORT.getIri(), false, false, true, true, true, false, false),
        UNSIGNED_BYTE(CoreDatatype.XSD.UNSIGNED_BYTE.getIri(), false, false, true, true, true, false, false),
        YEARMONTHDURATION(CoreDatatype.XSD.YEARMONTHDURATION.getIri(), false, true, false, true, false, false, false);

        private final IRI iri;
        private final boolean primitive;
        private final boolean duration;
        private final boolean integer;
        private final boolean derived;
        private final boolean decimal;
        private final boolean floatingPoint;
        private final boolean calendar;
        private final CoreDatatype.XSD coreDatatype;
        private static final Map<IRI, Optional<Datatype>> reverseLookup;
        private static final Map<CoreDatatype.XSD, Optional<Datatype>> reverseLookupXSDDatatype;

        private Datatype(IRI iri, boolean primitive, boolean duration, boolean integer, boolean derived, boolean decimal, boolean floatingPoint, boolean calendar) {
            this.iri = iri;
            this.primitive = primitive;
            this.duration = duration;
            this.integer = integer;
            this.derived = derived;
            this.decimal = decimal;
            this.floatingPoint = floatingPoint;
            this.calendar = calendar;
            this.coreDatatype = (CoreDatatype.XSD)CoreDatatype.from((IRI)iri).asXSDDatatype().orElseThrow();
        }

        public boolean isPrimitiveDatatype() {
            return this.primitive;
        }

        public boolean isDerivedDatatype() {
            return this.derived;
        }

        public boolean isBuiltInDatatype() {
            return this.isPrimitiveDatatype() || this.isDerivedDatatype();
        }

        public boolean isNumericDatatype() {
            return this.isDecimalDatatype() || this.isFloatingPointDatatype();
        }

        public boolean isDecimalDatatype() {
            return this.decimal;
        }

        public boolean isIntegerDatatype() {
            return this.integer;
        }

        public boolean isFloatingPointDatatype() {
            return this.floatingPoint;
        }

        public boolean isCalendarDatatype() {
            return this.calendar;
        }

        public boolean isDurationDatatype() {
            return this.duration;
        }

        public boolean isOrderedDatatype() {
            return this.isNumericDatatype() || this.isCalendarDatatype();
        }

        public IRI getIri() {
            return this.iri;
        }

        public CoreDatatype getCoreDatatype() {
            return this.coreDatatype;
        }

        public static Optional<Datatype> from(IRI datatype) {
            return reverseLookup.getOrDefault(datatype, Optional.empty());
        }

        public static Optional<Datatype> from(CoreDatatype.XSD datatype) {
            if (datatype == null) {
                return Optional.empty();
            }
            return reverseLookupXSDDatatype.getOrDefault(datatype, Optional.empty());
        }

        static {
            reverseLookup = new HashMap<IRI, Optional<Datatype>>();
            reverseLookupXSDDatatype = new EnumMap<CoreDatatype.XSD, Optional<Datatype>>(CoreDatatype.XSD.class);
            for (Datatype value : Datatype.values()) {
                reverseLookup.put(value.iri, Optional.of(value));
                reverseLookupXSDDatatype.put(value.coreDatatype, Optional.of(value));
            }
        }
    }
}

