/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.collection.factory.api.BindingSetEntry;
import org.eclipse.rdf4j.collection.factory.api.BindingSetKey;
import org.eclipse.rdf4j.collection.factory.api.CollectionFactory;
import org.eclipse.rdf4j.collection.factory.impl.DefaultCollectionFactory;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteratorIteration;
import org.eclipse.rdf4j.common.transaction.QueryEvaluationMode;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MutableBindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.AggregateFunctionCall;
import org.eclipse.rdf4j.query.algebra.AggregateOperator;
import org.eclipse.rdf4j.query.algebra.Avg;
import org.eclipse.rdf4j.query.algebra.Count;
import org.eclipse.rdf4j.query.algebra.Group;
import org.eclipse.rdf4j.query.algebra.GroupConcat;
import org.eclipse.rdf4j.query.algebra.GroupElem;
import org.eclipse.rdf4j.query.algebra.MathExpr;
import org.eclipse.rdf4j.query.algebra.Max;
import org.eclipse.rdf4j.query.algebra.Min;
import org.eclipse.rdf4j.query.algebra.Sample;
import org.eclipse.rdf4j.query.algebra.Sum;
import org.eclipse.rdf4j.query.algebra.UnaryValueOperator;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryValueEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;
import org.eclipse.rdf4j.query.algebra.evaluation.util.MathUtil;
import org.eclipse.rdf4j.query.algebra.evaluation.util.ValueComparator;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.eclipse.rdf4j.query.parser.sparql.aggregate.AggregateCollector;
import org.eclipse.rdf4j.query.parser.sparql.aggregate.AggregateFunction;
import org.eclipse.rdf4j.query.parser.sparql.aggregate.AggregateFunctionFactory;
import org.eclipse.rdf4j.query.parser.sparql.aggregate.CustomAggregateFunctionRegistry;

public class GroupIterator
extends CloseableIteratorIteration<BindingSet> {
    private final EvaluationStrategy strategy;
    private final BindingSet parentBindings;
    private final Group group;
    private final QueryEvaluationContext context;
    private final QueryEvaluationStep arguments;
    private final ValueFactory vf;
    private final CollectionFactory cf;
    private static final Predicate<BindingSet> ALWAYS_TRUE_BINDING_SET = t -> true;
    private static final Predicate<Value> ALWAYS_TRUE_VALUE = t -> true;
    private static final Supplier<Predicate<Value>> ALWAYS_TRUE_VALUE_SUPPLIER = () -> ALWAYS_TRUE_VALUE;

    public GroupIterator(EvaluationStrategy strategy, Group group, BindingSet parentBindings, QueryEvaluationContext context) throws QueryEvaluationException {
        this(strategy, group, parentBindings, 0L, context);
    }

    @Deprecated
    public GroupIterator(EvaluationStrategy strategy, Group group, BindingSet parentBindings, long iterationCacheSyncThreshold, QueryEvaluationContext context) throws QueryEvaluationException {
        this(strategy, group, parentBindings, iterationCacheSyncThreshold, context, (ValueFactory)SimpleValueFactory.getInstance(), (CollectionFactory)new DefaultCollectionFactory());
    }

    public GroupIterator(EvaluationStrategy strategy, Group group, BindingSet parentBindings, long iterationCacheSyncThreshold, QueryEvaluationContext context, ValueFactory vf, CollectionFactory cf) throws QueryEvaluationException {
        this.strategy = strategy;
        this.group = group;
        this.parentBindings = parentBindings;
        this.context = context;
        this.vf = vf;
        this.cf = cf;
        this.arguments = strategy.precompile(group.getArg(), context);
    }

    public void handleClose() throws QueryEvaluationException {
        try {
            this.cf.close();
        }
        finally {
            super.handleClose();
        }
    }

    public boolean hasNext() throws QueryEvaluationException {
        if (!super.hasIterator()) {
            super.setIterator(this.createIterator());
        }
        return super.hasNext();
    }

    public BindingSet next() throws QueryEvaluationException {
        if (!super.hasIterator()) {
            super.setIterator(this.createIterator());
        }
        return (BindingSet)super.next();
    }

    private Iterator<BindingSet> createIterator() throws QueryEvaluationException {
        List<AggregatePredicateCollectorSupplier<?, ?>> aggregates = this.makeAggregates();
        Supplier<MutableBindingSet> makeNewBindingSet = this.parentBindings.isEmpty() ? this.context::createBindingSet : () -> this.context.createBindingSet(this.parentBindings);
        ArrayList<Function<BindingSet, Value>> getValues = new ArrayList<Function<BindingSet, Value>>();
        ArrayList<BiConsumer<Value, MutableBindingSet>> setBindings = new ArrayList<BiConsumer<Value, MutableBindingSet>>();
        for (String name : this.group.getGroupBindingNames()) {
            Function<BindingSet, Value> getValue = this.context.getValue(name);
            BiConsumer<Value, MutableBindingSet> setBinding = this.context.setBinding(name);
            if (getValue == null) continue;
            getValues.add(getValue);
            setBindings.add(setBinding);
        }
        BiConsumer<Entry, MutableBindingSet> bindSolution = this.makeBindSolution(aggregates);
        Collection<Entry> entries = this.buildEntries(aggregates);
        Set bindingSets = this.cf.createSetOfBindingSets(this.context::createBindingSet, this.context::hasBinding, this.context::getValue, this.context::setBinding);
        BiConsumer<BindingSet, MutableBindingSet> setValues = this.makeSetValues(getValues, setBindings);
        for (Entry entry : entries) {
            MutableBindingSet sol = makeNewBindingSet.get();
            BindingSet prototype = entry.getPrototype();
            if (prototype != null) {
                setValues.accept(prototype, sol);
            }
            bindSolution.accept(entry, sol);
            bindingSets.add(sol);
        }
        return bindingSets.iterator();
    }

    private BiConsumer<BindingSet, MutableBindingSet> makeSetValues(List<Function<BindingSet, Value>> getValues, List<BiConsumer<Value, MutableBindingSet>> setBindings) {
        if (getValues.isEmpty()) {
            return (prototype, solution) -> {};
        }
        BiConsumer<BindingSet, MutableBindingSet> consumeAValue = this.makeSetAValue(getValues, setBindings, 0);
        for (int i = 1; i < getValues.size(); ++i) {
            consumeAValue = consumeAValue.andThen(this.makeSetAValue(getValues, setBindings, i));
        }
        return consumeAValue;
    }

    private BiConsumer<BindingSet, MutableBindingSet> makeSetAValue(List<Function<BindingSet, Value>> getValues, List<BiConsumer<Value, MutableBindingSet>> setBindings, int i) {
        Function<BindingSet, Value> getBinding = getValues.get(i);
        BiConsumer<Value, MutableBindingSet> setBinding = setBindings.get(i);
        BiConsumer<BindingSet, MutableBindingSet> nextConsumeAValue = (prototype, solution) -> {
            Value value = (Value)getBinding.apply((BindingSet)prototype);
            if (value != null) {
                setBinding.accept(value, (MutableBindingSet)solution);
            }
        };
        return nextConsumeAValue;
    }

    private BiConsumer<Entry, MutableBindingSet> makeBindSolution(List<AggregatePredicateCollectorSupplier<?, ?>> aggregates) {
        BiConsumer<Entry, MutableBindingSet> bindSolution = null;
        for (int i = 0; i < aggregates.size(); ++i) {
            AggregatePredicateCollectorSupplier<?, ?> a = aggregates.get(i);
            BiConsumer<Value, MutableBindingSet> setBinding = this.context.setBinding(a.name);
            int j = i;
            BiConsumer<Entry, MutableBindingSet> biConsumer = (e, bs) -> {
                try {
                    Value value = e.collectors.get(j).getFinalValue();
                    if (value != null) {
                        setBinding.accept(value, (MutableBindingSet)bs);
                    }
                }
                catch (ValueExprEvaluationException valueExprEvaluationException) {
                    // empty catch block
                }
            };
            bindSolution = bindSolution == null ? biConsumer : bindSolution.andThen(biConsumer);
        }
        if (bindSolution == null) {
            return (e, bs) -> {};
        }
        return bindSolution;
    }

    private List<AggregatePredicateCollectorSupplier<?, ?>> makeAggregates() {
        ArrayList aggregates = new ArrayList(this.group.getGroupBindingNames().size());
        for (GroupElem ge : this.group.getGroupElements()) {
            AggregatePredicateCollectorSupplier<?, ?> create = this.create(ge, this.vf);
            if (create == null) continue;
            aggregates.add(create);
        }
        return aggregates;
    }

    private Collection<Entry> buildEntries(List<AggregatePredicateCollectorSupplier<?, ?>> aggregates) throws QueryEvaluationException {
        try (CloseableIteration<BindingSet> iter = this.arguments.evaluate(this.parentBindings);){
            List getValues = this.group.getGroupBindingNames().stream().map(n -> this.context.getValue((String)n)).collect(Collectors.toList());
            if (!iter.hasNext()) {
                List<Entry> list = this.emptySolutionSpecialCase(aggregates);
                return list;
            }
            Map entries = this.cf.createGroupByMap();
            ToIntFunction hashMaker = this.cf.hashOfBindingSetFuntion(getValues);
            while (iter.hasNext()) {
                BindingSet sol = (BindingSet)iter.next();
                BindingSetKey key = this.cf.createBindingSetKey(sol, getValues, hashMaker);
                Entry entry = (Entry)entries.get(key);
                if (entry == null) {
                    List<AggregateCollector> collectors = this.makeCollectors(aggregates);
                    ArrayList predicates = new ArrayList(aggregates.size());
                    for (AggregatePredicateCollectorSupplier<?, ?> a : aggregates) {
                        predicates.add(a.makePotentialDistinctTest.get());
                    }
                    entry = new Entry(sol, collectors, predicates);
                    entries.put(key, entry);
                }
                entry.addSolution(sol, aggregates);
            }
            Collection<Entry> collection = entries.values();
            return collection;
        }
    }

    private List<Entry> emptySolutionSpecialCase(List<AggregatePredicateCollectorSupplier<?, ?>> aggregates) {
        if (this.group.getGroupBindingNames().isEmpty()) {
            if (this.group.getGroupElements().isEmpty()) {
                Entry entry = new Entry(null, null, null);
                return List.of(entry);
            }
            List<AggregateCollector> collectors = this.makeCollectors(aggregates);
            ArrayList predicates = new ArrayList(aggregates.size());
            for (int i = 0; i < aggregates.size(); ++i) {
                predicates.add(ALWAYS_TRUE_BINDING_SET);
            }
            Entry entry = new Entry(null, collectors, predicates);
            entry.addSolution(EmptyBindingSet.getInstance(), aggregates);
            return List.of(entry);
        }
        return Collections.emptyList();
    }

    private List<AggregateCollector> makeCollectors(List<AggregatePredicateCollectorSupplier<?, ?>> aggregates) {
        ArrayList<AggregateCollector> collectors = new ArrayList<AggregateCollector>(aggregates.size());
        for (AggregatePredicateCollectorSupplier<?, ?> a : aggregates) {
            collectors.add((AggregateCollector)a.makeAggregateCollector.get());
        }
        return collectors;
    }

    private AggregatePredicateCollectorSupplier<?, ?> create(GroupElem ge, ValueFactory vf) throws QueryEvaluationException {
        AggregateOperator operator = ge.getOperator();
        if (operator instanceof Count) {
            if (((Count)operator).getArg() == null) {
                WildCardCountAggregate wildCardCountAggregate = new WildCardCountAggregate();
                Supplier potentialDistinctTest = operator.isDistinct() ? () -> new DistinctBindingSets() : () -> ALWAYS_TRUE_BINDING_SET;
                return new AggregatePredicateCollectorSupplier<CountCollector, BindingSet>(wildCardCountAggregate, potentialDistinctTest, () -> new CountCollector(vf), ge.getName());
            }
            QueryStepEvaluator f = new QueryStepEvaluator(this.strategy.precompile(((Count)operator).getArg(), this.context));
            CountAggregate agg = new CountAggregate(f);
            Supplier predicate = operator.isDistinct() ? () -> new DistinctValues() : ALWAYS_TRUE_VALUE_SUPPLIER;
            return new AggregatePredicateCollectorSupplier<CountCollector, Value>(agg, predicate, () -> new CountCollector(vf), ge.getName());
        }
        if (operator instanceof Min) {
            MinAggregate agg = new MinAggregate(this.precompileArg(operator), this.shouldValueComparisonBeStrict());
            Supplier predicate = operator.isDistinct() ? () -> new DistinctValues() : ALWAYS_TRUE_VALUE_SUPPLIER;
            return new AggregatePredicateCollectorSupplier<ValueCollector, Value>(agg, predicate, () -> new ValueCollector(), ge.getName());
        }
        if (operator instanceof Max) {
            MaxAggregate agg = new MaxAggregate(this.precompileArg(operator), this.shouldValueComparisonBeStrict());
            Supplier predicate = operator.isDistinct() ? () -> new DistinctValues() : ALWAYS_TRUE_VALUE_SUPPLIER;
            return new AggregatePredicateCollectorSupplier<ValueCollector, Value>(agg, predicate, () -> new ValueCollector(), ge.getName());
        }
        if (operator instanceof Sum) {
            SumAggregate agg = new SumAggregate(this.precompileArg(operator));
            Supplier predicate = operator.isDistinct() ? () -> new DistinctValues() : ALWAYS_TRUE_VALUE_SUPPLIER;
            return new AggregatePredicateCollectorSupplier<IntegerCollector, Value>(agg, predicate, () -> new IntegerCollector(vf), ge.getName());
        }
        if (operator instanceof Avg) {
            AvgAggregate agg = new AvgAggregate(this.precompileArg(operator));
            Supplier predicate = operator.isDistinct() ? () -> new DistinctValues() : ALWAYS_TRUE_VALUE_SUPPLIER;
            return new AggregatePredicateCollectorSupplier<AvgCollector, Value>(agg, predicate, () -> new AvgCollector(vf), ge.getName());
        }
        if (operator instanceof Sample) {
            SampleAggregate agg = new SampleAggregate(this.precompileArg(operator));
            Supplier predicate = operator.isDistinct() ? () -> new DistinctValues() : ALWAYS_TRUE_VALUE_SUPPLIER;
            return new AggregatePredicateCollectorSupplier<SampleCollector, Value>(agg, predicate, () -> new SampleCollector(), ge.getName());
        }
        if (operator instanceof GroupConcat) {
            ConcatAggregate agg;
            ValueExpr separatorExpr = ((GroupConcat)operator).getSeparator();
            if (separatorExpr != null) {
                Value separatorValue = this.strategy.evaluate(separatorExpr, this.parentBindings);
                agg = new ConcatAggregate(this.precompileArg(operator), separatorValue.stringValue());
            } else {
                agg = new ConcatAggregate(this.precompileArg(operator));
            }
            Supplier predicate = operator.isDistinct() ? () -> new DistinctValues() : ALWAYS_TRUE_VALUE_SUPPLIER;
            return new AggregatePredicateCollectorSupplier<StringBuilderCollector, Value>(agg, predicate, () -> new StringBuilderCollector(vf), ge.getName());
        }
        if (operator instanceof AggregateFunctionCall) {
            AggregateFunctionCall aggOperator = (AggregateFunctionCall)operator;
            Supplier predicate = operator.isDistinct() ? () -> new DistinctValues() : ALWAYS_TRUE_VALUE_SUPPLIER;
            Optional factory = CustomAggregateFunctionRegistry.getInstance().get((Object)aggOperator.getIRI());
            AggregateFunction function = ((AggregateFunctionFactory)factory.orElseThrow(() -> new QueryEvaluationException("Unknown aggregate function '" + aggOperator.getIRI() + "'"))).buildFunction((Function)new QueryStepEvaluator(this.strategy.precompile(aggOperator.getArg(), this.context)));
            return new AggregatePredicateCollectorSupplier(function, predicate, () -> ((AggregateFunctionFactory)factory.get()).getCollector(), ge.getName());
        }
        return null;
    }

    private QueryStepEvaluator precompileArg(AggregateOperator operator) {
        return new QueryStepEvaluator(this.strategy.precompile(((UnaryValueOperator)operator).getArg(), this.context));
    }

    private boolean shouldValueComparisonBeStrict() {
        return this.strategy.getQueryEvaluationMode() == QueryEvaluationMode.STRICT;
    }

    private static class QueryStepEvaluator
    implements Function<BindingSet, Value> {
        private final QueryValueEvaluationStep evaluationStep;

        public QueryStepEvaluator(QueryValueEvaluationStep evaluationStep) {
            this.evaluationStep = evaluationStep;
        }

        @Override
        public Value apply(BindingSet bindings) {
            try {
                return this.evaluationStep.evaluate(bindings);
            }
            catch (ValueExprEvaluationException e) {
                return null;
            }
        }
    }

    private static class ConcatAggregate
    extends AggregateFunction<StringBuilderCollector, Value> {
        private static final String DEFAULT_SEPERATOR = " ";
        private final String separator;

        public ConcatAggregate(Function<BindingSet, Value> f, String seperator) throws QueryEvaluationException {
            super(f);
            this.separator = seperator;
        }

        public ConcatAggregate(Function<BindingSet, Value> f) throws QueryEvaluationException {
            super(f);
            this.separator = DEFAULT_SEPERATOR;
        }

        public void processAggregate(BindingSet s, Predicate<Value> distinctValue, StringBuilderCollector collector) throws QueryEvaluationException {
            Value v = this.evaluate(s);
            if (v != null && distinctValue.test(v)) {
                if (collector.concatenated == null) {
                    collector.concatenated = new StringBuilder();
                } else {
                    collector.concatenated.append(this.separator);
                }
                collector.concatenated.append(v.stringValue());
            }
        }
    }

    private static class StringBuilderCollector
    implements AggregateCollector {
        private StringBuilder concatenated;
        private final ValueFactory vf;

        public StringBuilderCollector(ValueFactory vf) {
            this.vf = vf;
        }

        public Value getFinalValue() throws ValueExprEvaluationException {
            if (this.concatenated == null || this.concatenated.length() == 0) {
                return SimpleValueFactory.getInstance().createLiteral("");
            }
            return SimpleValueFactory.getInstance().createLiteral(this.concatenated.toString());
        }
    }

    private static class SampleAggregate
    extends AggregateFunction<SampleCollector, Value> {
        private final Random random = new Random(System.currentTimeMillis());

        public SampleAggregate(Function<BindingSet, Value> f) {
            super(f);
        }

        public void processAggregate(BindingSet s, Predicate<Value> distinct, SampleCollector sample) throws QueryEvaluationException {
            Value newValue;
            if ((sample.sample == null || this.random.nextFloat() < 0.5f) && (newValue = this.evaluate(s)) != null) {
                sample.sample = newValue;
            }
        }
    }

    private static class SampleCollector
    implements AggregateCollector {
        private Value sample;

        private SampleCollector() {
        }

        public Value getFinalValue() throws ValueExprEvaluationException {
            if (this.sample == null) {
                throw new ValueExprEvaluationException("SAMPLE undefined");
            }
            return this.sample;
        }
    }

    private static class AvgAggregate
    extends AggregateFunction<AvgCollector, Value> {
        public AvgAggregate(Function<BindingSet, Value> operator) {
            super(operator);
        }

        public void processAggregate(BindingSet s, Predicate<Value> distinctValue, AvgCollector avg) throws QueryEvaluationException {
            if (avg.hasError()) {
                return;
            }
            Value v = this.evaluate(s);
            if (distinctValue.test(v)) {
                if (v instanceof Literal) {
                    Literal nextLiteral = (Literal)v;
                    CoreDatatype.XSD datatype = nextLiteral.getCoreDatatype().asXSDDatatypeOrNull();
                    if (datatype != null && datatype.isNumericDatatype()) {
                        avg.sum = MathUtil.compute(avg.sum, nextLiteral, MathExpr.MathOp.PLUS);
                    } else {
                        avg.setTypeError(new ValueExprEvaluationException("not a number: " + v));
                    }
                    ++avg.count;
                } else if (v != null) {
                    avg.setTypeError(new ValueExprEvaluationException("not a number: " + v));
                }
            }
        }
    }

    private static class SumAggregate
    extends AggregateFunction<IntegerCollector, Value> {
        public SumAggregate(Function<BindingSet, Value> f) {
            super(f);
        }

        public void processAggregate(BindingSet s, Predicate<Value> distinctValue, IntegerCollector sum) throws QueryEvaluationException {
            if (sum.hasError()) {
                return;
            }
            Value v = this.evaluate(s);
            if (v != null) {
                if (v.isLiteral()) {
                    if (distinctValue.test(v)) {
                        Literal literal = (Literal)v;
                        CoreDatatype.XSD coreDatatype = literal.getCoreDatatype().asXSDDatatypeOrNull();
                        if (coreDatatype != null && coreDatatype.isNumericDatatype()) {
                            sum.value = MathUtil.compute(sum.value, literal, MathExpr.MathOp.PLUS);
                        } else {
                            sum.setTypeError(new ValueExprEvaluationException("not a number: " + v));
                        }
                    }
                } else {
                    sum.setTypeError(new ValueExprEvaluationException("not a number: " + v));
                }
            }
        }
    }

    private static class MaxAggregate
    extends AggregateFunction<ValueCollector, Value> {
        private final ValueComparator comparator = new ValueComparator();

        public MaxAggregate(Function<BindingSet, Value> f, boolean strict) {
            super(f);
            this.comparator.setStrict(strict);
        }

        public void processAggregate(BindingSet s, Predicate<Value> distinctValue, ValueCollector max) throws QueryEvaluationException {
            Value v = this.evaluate(s);
            if (v != null && distinctValue.test(v)) {
                if (max.value == null) {
                    max.value = v;
                } else if (this.comparator.compare(v, max.value) > 0) {
                    max.value = v;
                }
            }
        }
    }

    private class MinAggregate
    extends AggregateFunction<ValueCollector, Value> {
        private final ValueComparator comparator;

        public MinAggregate(Function<BindingSet, Value> f, boolean strict) {
            super(f);
            this.comparator = new ValueComparator();
            this.comparator.setStrict(strict);
        }

        public void processAggregate(BindingSet s, Predicate<Value> distinctValue, ValueCollector min) throws QueryEvaluationException {
            Value v = this.evaluate(s);
            if (v != null && distinctValue.test(v)) {
                if (min.value == null) {
                    min.value = v;
                } else if (this.comparator.compare(v, min.value) < 0) {
                    min.value = v;
                }
            }
        }
    }

    private static class WildCardCountAggregate
    extends AggregateFunction<CountCollector, BindingSet> {
        public WildCardCountAggregate() {
            super(null);
        }

        public void processAggregate(BindingSet s, Predicate<BindingSet> distinctValue, CountCollector agv) throws QueryEvaluationException {
            if (!s.isEmpty() && distinctValue.test(s)) {
                ++agv.value;
            }
        }
    }

    private static class CountAggregate
    extends AggregateFunction<CountCollector, Value> {
        public CountAggregate(Function<BindingSet, Value> f) {
            super(f);
        }

        public void processAggregate(BindingSet s, Predicate<Value> distinctValue, CountCollector agv) throws QueryEvaluationException {
            Value value = this.evaluate(s);
            if (value != null && distinctValue.test(value)) {
                ++agv.value;
            }
        }
    }

    private class DistinctBindingSets
    implements Predicate<BindingSet> {
        private final Set<BindingSet> distinctValues;

        public DistinctBindingSets() {
            this.distinctValues = GroupIterator.this.cf.createSet();
        }

        @Override
        public boolean test(BindingSet value) {
            return this.distinctValues.add(value);
        }
    }

    private class DistinctValues
    implements Predicate<Value> {
        private final Set<Value> distinctValues;

        public DistinctValues() {
            this.distinctValues = GroupIterator.this.cf.createValueSet();
        }

        @Override
        public boolean test(Value value) {
            return this.distinctValues.add(value);
        }
    }

    private class AvgCollector
    implements AggregateCollector {
        private final ValueFactory vf;
        private Literal sum;
        private long count;
        private ValueExprEvaluationException typeError;

        public AvgCollector(ValueFactory vf) {
            this.vf = vf;
            this.sum = vf.createLiteral("0", (CoreDatatype)CoreDatatype.XSD.INTEGER);
        }

        public void setTypeError(ValueExprEvaluationException typeError) {
            this.typeError = typeError;
        }

        public boolean hasError() {
            return this.typeError != null;
        }

        public Value getFinalValue() throws ValueExprEvaluationException {
            if (this.typeError != null) {
                throw this.typeError;
            }
            if (this.count == 0L) {
                return SimpleValueFactory.getInstance().createLiteral("0", (CoreDatatype)CoreDatatype.XSD.INTEGER);
            }
            Literal sizeLit = SimpleValueFactory.getInstance().createLiteral(this.count);
            return MathUtil.compute(this.sum, sizeLit, MathExpr.MathOp.DIVIDE);
        }
    }

    private static class IntegerCollector
    implements AggregateCollector {
        private ValueExprEvaluationException typeError;
        private Literal value;

        public IntegerCollector(ValueFactory vf) {
            this.value = vf.createLiteral("0", (CoreDatatype)CoreDatatype.XSD.INTEGER);
        }

        public void setTypeError(ValueExprEvaluationException typeError) {
            this.typeError = typeError;
        }

        public boolean hasError() {
            return this.typeError != null;
        }

        public Value getFinalValue() {
            if (this.typeError != null) {
                throw this.typeError;
            }
            return this.value;
        }
    }

    private static class ValueCollector
    implements AggregateCollector {
        private Value value;

        private ValueCollector() {
        }

        public Value getFinalValue() {
            return this.value;
        }
    }

    private static class CountCollector
    implements AggregateCollector {
        private long value;
        private final ValueFactory vf;

        public CountCollector(ValueFactory vf) {
            this.vf = vf;
        }

        public Value getFinalValue() {
            return SimpleValueFactory.getInstance().createLiteral(Long.toString(this.value), (CoreDatatype)CoreDatatype.XSD.INTEGER);
        }
    }

    private static class AggregatePredicateCollectorSupplier<T extends AggregateCollector, D> {
        public final String name;
        private final AggregateFunction<T, D> agg;
        private final Supplier<Predicate<D>> makePotentialDistinctTest;
        private final Supplier<T> makeAggregateCollector;

        public AggregatePredicateCollectorSupplier(AggregateFunction<T, D> agg, Supplier<Predicate<D>> makePotentialDistinctTest, Supplier<T> makeAggregateCollector, String name) {
            this.agg = agg;
            this.makePotentialDistinctTest = makePotentialDistinctTest;
            this.makeAggregateCollector = makeAggregateCollector;
            this.name = name;
        }

        private void operate(BindingSet bs, Predicate<?> predicate, Object t) {
            this.agg.processAggregate(bs, predicate, (AggregateCollector)t);
        }
    }

    private static class Entry
    implements BindingSetEntry {
        private static final long serialVersionUID = 1L;
        private final BindingSet prototype;
        private final List<AggregateCollector> collectors;
        private final List<Predicate<?>> predicates;

        public Entry(BindingSet prototype, List<AggregateCollector> collectors, List<Predicate<?>> predicates) throws QueryEvaluationException {
            this.prototype = prototype;
            this.collectors = collectors;
            this.predicates = predicates;
        }

        public void addSolution(BindingSet bs, List<AggregatePredicateCollectorSupplier<?, ?>> operators) {
            for (int i = 0; i < operators.size(); ++i) {
                AggregatePredicateCollectorSupplier<?, ?> aggregatePredicateCollectorSupplier = operators.get(i);
                aggregatePredicateCollectorSupplier.operate(bs, this.predicates.get(i), this.collectors.get(i));
            }
        }

        public BindingSet getPrototype() {
            return this.prototype;
        }
    }
}

