/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryValueEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.BadlyDesignedLeftJoinIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.HashJoinIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.LeftJoinIterator;
import org.eclipse.rdf4j.query.algebra.helpers.TupleExprs;
import org.eclipse.rdf4j.query.algebra.helpers.collectors.VarNameCollector;

public final class LeftJoinQueryEvaluationStep
implements QueryEvaluationStep {
    private final QueryEvaluationStep right;
    private final QueryValueEvaluationStep condition;
    private final QueryEvaluationStep left;
    private final LeftJoin leftJoin;
    private final Set<String> optionalVars;

    public static QueryEvaluationStep supply(EvaluationStrategy strategy, LeftJoin leftJoin, QueryEvaluationContext context) {
        QueryValueEvaluationStep condition;
        QueryEvaluationStep left = strategy.precompile(leftJoin.getLeftArg(), context);
        QueryEvaluationStep right = strategy.precompile(leftJoin.getRightArg(), context);
        if (TupleExprs.containsSubquery((TupleExpr)leftJoin.getRightArg())) {
            Set leftBindingNames = leftJoin.getLeftArg().getBindingNames();
            Set rightBindingNames = leftJoin.getRightArg().getBindingNames();
            String[] joinAttributes = (String[])leftBindingNames.stream().filter(rightBindingNames::contains).toArray(String[]::new);
            return bs -> new HashJoinIteration(left, right, bs, true, joinAttributes, context);
        }
        VarNameCollector optionalVarCollector = new VarNameCollector();
        leftJoin.getRightArg().visit((QueryModelVisitor)optionalVarCollector);
        if (leftJoin.hasCondition()) {
            leftJoin.getCondition().visit((QueryModelVisitor)optionalVarCollector);
            condition = strategy.precompile(leftJoin.getCondition(), context);
        } else {
            condition = null;
        }
        return new LeftJoinQueryEvaluationStep(right, condition, left, leftJoin, optionalVarCollector.getVarNames());
    }

    public LeftJoinQueryEvaluationStep(QueryEvaluationStep right, QueryValueEvaluationStep condition, QueryEvaluationStep left, LeftJoin leftJoin, Set<String> optionalVars) {
        this.right = right;
        this.condition = condition;
        this.left = left;
        this.leftJoin = leftJoin;
        Set leftBindingNames = leftJoin.getLeftArg().getBindingNames();
        if (!leftBindingNames.isEmpty()) {
            if (leftBindingNames.containsAll(optionalVars)) {
                optionalVars = Set.of();
            } else {
                for (String leftBindingName : leftBindingNames) {
                    if (!optionalVars.contains(leftBindingName)) continue;
                    optionalVars = new HashSet<String>(optionalVars);
                    optionalVars.removeAll(leftBindingNames);
                    break;
                }
            }
        }
        this.optionalVars = optionalVars;
    }

    @Override
    public CloseableIteration<BindingSet> evaluate(BindingSet bindings) {
        boolean containsNone = true;
        Set bindingNames = bindings.getBindingNames();
        for (String optionalVar : this.optionalVars) {
            if (!bindingNames.contains(optionalVar)) continue;
            containsNone = false;
            break;
        }
        if (containsNone) {
            this.leftJoin.setAlgorithm(LeftJoinIterator.class.getSimpleName());
            return new LeftJoinIterator(this.left, this.right, this.condition, bindings, this.leftJoin.getBindingNames());
        }
        HashSet<String> problemVars = new HashSet<String>(this.optionalVars);
        problemVars.retainAll(bindings.getBindingNames());
        this.leftJoin.setAlgorithm(BadlyDesignedLeftJoinIterator.class.getSimpleName());
        return new BadlyDesignedLeftJoinIterator(this.left, this.right, this.condition, bindings, problemVars);
    }
}

