/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Objects;
import java.util.function.Function;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlQueryParserCache;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.SingletonBindingSet;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalFilterByQuery
extends FilterPlanNode {
    private static final Logger logger = LoggerFactory.getLogger(ExternalFilterByQuery.class);
    private final SailConnection connection;
    private final TupleExpr query;
    private final Dataset dataset;
    private final StatementMatcher.Variable queryVariable;
    private final Function<ValidationTuple, Value> filterOn;
    private final String queryString;

    public ExternalFilterByQuery(SailConnection connection, Resource[] dataGraph, PlanNode parent, SparqlFragment queryFragment, StatementMatcher.Variable queryVariable, Function<ValidationTuple, Value> filterOn) {
        super(parent);
        this.connection = connection;
        assert (this.connection != null);
        this.queryVariable = queryVariable;
        this.filterOn = filterOn;
        this.queryString = queryFragment.getNamespacesForSparql() + StatementMatcher.StableRandomVariableProvider.normalize("SELECT " + queryVariable.asSparqlVariable() + " WHERE {\n" + queryFragment.getFragment() + "\n}");
        try {
            this.query = SparqlQueryParserCache.get(this.queryString);
        }
        catch (MalformedQueryException e) {
            logger.error("Malformed query:\n{}", (Object)this.queryString);
            throw e;
        }
        this.dataset = PlanNodeHelper.asDefaultGraphDataset(dataGraph);
    }

    @Override
    boolean checkTuple(ValidationTuple t) {
        Value value = this.filterOn.apply(t);
        SingletonBindingSet bindings = new SingletonBindingSet(this.queryVariable.getName(), value);
        try (CloseableIteration<? extends BindingSet> bindingSet = this.connection.evaluate(this.query, this.dataset, bindings, false);){
            boolean bl = bindingSet.hasNext();
            return bl;
        }
    }

    @Override
    public String toString() {
        return "ExternalFilterByQuery{, queryString=" + this.queryString.replace("\n", "\t") + ", queryVariable='" + this.queryVariable.toString().replace("\n", "  ") + "'}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExternalFilterByQuery that = (ExternalFilterByQuery)o;
        if (this.connection instanceof MemoryStoreConnection && that.connection instanceof MemoryStoreConnection) {
            return ((MemoryStoreConnection)this.connection).getSail().equals(((MemoryStoreConnection)that.connection).getSail()) && Objects.equals(this.dataset, that.dataset) && this.queryVariable.equals(that.queryVariable) && this.filterOn.equals(that.filterOn) && this.queryString.equals(that.queryString);
        }
        return Objects.equals(this.connection, that.connection) && this.queryVariable.equals(that.queryVariable) && Objects.equals(this.dataset, that.dataset) && this.filterOn.equals(that.filterOn) && this.queryString.equals(that.queryString);
    }

    @Override
    public int hashCode() {
        if (this.connection instanceof MemoryStoreConnection) {
            return Objects.hash(super.hashCode(), ((MemoryStoreConnection)this.connection).getSail(), this.queryVariable, this.filterOn, this.dataset, this.queryString);
        }
        return Objects.hash(super.hashCode(), this.connection, this.queryVariable, this.filterOn, this.dataset, this.queryString);
    }
}

