/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ValidationSettings;
import org.eclipse.rdf4j.sail.shacl.ast.Cache;
import org.eclipse.rdf4j.sail.shacl.ast.NodeShape;
import org.eclipse.rdf4j.sail.shacl.ast.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclProperties;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclUnsupportedException;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationQuery;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.AbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.NotValuesIn;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ShiftToPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.targets.EffectiveTarget;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetChain;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;

public class NotConstraintComponent
extends AbstractConstraintComponent {
    Shape not;

    public NotConstraintComponent(Resource id, ShapeSource shapeSource, Shape.ParseSettings parseSettings, Cache cache) {
        super(id);
        ShaclProperties p = new ShaclProperties(id, shapeSource);
        if (p.getType() == SHACL.NODE_SHAPE) {
            this.not = NodeShape.getInstance(p, shapeSource, parseSettings, cache);
        } else if (p.getType() == SHACL.PROPERTY_SHAPE) {
            this.not = PropertyShape.getInstance(p, shapeSource, parseSettings, cache);
        } else {
            throw new IllegalStateException("Unknown shape type for " + p.getId());
        }
    }

    public NotConstraintComponent(NotConstraintComponent notConstraintComponent) {
        super(notConstraintComponent.getId());
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.NOT, this.getId(), new Resource[0]);
        this.not.toModel(null, null, model, cycleDetection);
    }

    @Override
    public void setTargetChain(TargetChain targetChain) {
        super.setTargetChain(targetChain);
        this.not.setTargetChain(targetChain.setOptimizable(false));
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.NotConstraintComponent;
    }

    @Override
    public ValidationQuery generateSparqlValidationQuery(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, boolean negatePlan, boolean negateChildren, ConstraintComponent.Scope scope) {
        throw new ShaclUnsupportedException();
    }

    @Override
    public PlanNode generateTransactionalValidationPlan(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope) {
        PlanNode allTargetsPlan;
        StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider = new StatementMatcher.StableRandomVariableProvider();
        PlanNodeProvider planNodeProvider = overrideTargetNode != null ? overrideTargetNode : () -> this.getAllTargetsPlan(connectionsGroup, validationSettings.getDataGraph(), scope, stableRandomVariableProvider);
        PlanNode planNode = this.not.generateTransactionalValidationPlan(connectionsGroup, validationSettings, planNodeProvider, scope);
        PlanNode invalid = Unique.getInstance(planNode, false);
        if (overrideTargetNode != null) {
            if (scope == ConstraintComponent.Scope.propertyShape) {
                allTargetsPlan = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).extend(planNodeProvider.getPlanNode(), connectionsGroup, validationSettings.getDataGraph(), ConstraintComponent.Scope.nodeShape, EffectiveTarget.Extend.right, false, null);
                allTargetsPlan = Unique.getInstance(new ShiftToPropertyShape(allTargetsPlan), true);
            } else {
                allTargetsPlan = this.getTargetChain().getEffectiveTarget(scope, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).extend(planNodeProvider.getPlanNode(), connectionsGroup, validationSettings.getDataGraph(), scope, EffectiveTarget.Extend.right, false, null);
            }
        } else {
            allTargetsPlan = planNodeProvider.getPlanNode();
        }
        invalid = new NotValuesIn(allTargetsPlan, invalid);
        return invalid;
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, Resource[] dataGraph, ConstraintComponent.Scope scope, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        PlanNode allTargets;
        if (scope == ConstraintComponent.Scope.propertyShape) {
            PlanNode allTargetsPlan = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).getPlanNode(connectionsGroup, dataGraph, ConstraintComponent.Scope.nodeShape, true, null);
            allTargets = Unique.getInstance(new ShiftToPropertyShape(allTargetsPlan), true);
        } else {
            allTargets = this.getTargetChain().getEffectiveTarget(scope, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).getPlanNode(connectionsGroup, dataGraph, scope, true, null);
        }
        PlanNode notTargets = this.not.getAllTargetsPlan(connectionsGroup, dataGraph, scope, new StatementMatcher.StableRandomVariableProvider());
        return Unique.getInstance(UnionNode.getInstanceDedupe(allTargets, notTargets), false);
    }

    @Override
    public ConstraintComponent deepClone() {
        NotConstraintComponent notConstraintComponent = new NotConstraintComponent(this);
        notConstraintComponent.not = (Shape)this.not.deepClone();
        return notConstraintComponent;
    }

    @Override
    public boolean requiresEvaluation(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope, Resource[] dataGraph, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        return this.not.requiresEvaluation(connectionsGroup, scope, dataGraph, stableRandomVariableProvider);
    }

    @Override
    public List<Literal> getDefaultMessage() {
        return List.of();
    }
}

