/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.algebra.OrderElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElemList;
import org.eclipse.rdf4j.query.algebra.QueryRoot;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.parser.ParsedBooleanQuery;
import org.eclipse.rdf4j.query.parser.ParsedGraphQuery;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.queryrender.QueryRenderer;
import org.eclipse.rdf4j.queryrender.sparql.SparqlTupleExprRenderer;

public class SPARQLQueryRenderer
implements QueryRenderer {
    private final SparqlTupleExprRenderer mRenderer = new SparqlTupleExprRenderer();

    @Override
    public QueryLanguage getLanguage() {
        return QueryLanguage.SPARQL;
    }

    @Override
    public String render(ParsedQuery theQuery) throws Exception {
        boolean aFirst;
        this.mRenderer.reset();
        TupleExpr tupleExpr = theQuery.getTupleExpr();
        if (tupleExpr instanceof QueryRoot) {
            tupleExpr = ((QueryRoot)tupleExpr).getArg();
        }
        StringBuffer aBody = new StringBuffer(this.mRenderer.render(tupleExpr));
        StringBuilder aQuery = new StringBuilder();
        if (theQuery instanceof ParsedTupleQuery) {
            aQuery.append("select ");
        } else if (theQuery instanceof ParsedBooleanQuery) {
            aQuery.append("ask").append(System.lineSeparator());
        } else {
            aQuery.append("construct ");
        }
        if (this.mRenderer.isDistinct()) {
            aQuery.append("distinct ");
        }
        if (this.mRenderer.isReduced() && theQuery instanceof ParsedTupleQuery) {
            aQuery.append("reduced ");
        }
        if (!this.mRenderer.getProjection().isEmpty() && !(theQuery instanceof ParsedBooleanQuery)) {
            aFirst = true;
            if (!(theQuery instanceof ParsedTupleQuery)) {
                aQuery.append(" {").append(System.lineSeparator());
            }
            for (ProjectionElemList aList : this.mRenderer.getProjection()) {
                if (SparqlTupleExprRenderer.isSPOElemList(aList)) {
                    if (!aFirst) {
                        aQuery.append(System.lineSeparator());
                    } else {
                        aFirst = false;
                    }
                    aQuery.append("  ").append(this.mRenderer.renderPattern(this.mRenderer.toStatementPattern(aList)));
                    continue;
                }
                for (ProjectionElem aElem : aList.getElements()) {
                    if (!aFirst) {
                        aQuery.append(" ");
                    } else {
                        aFirst = false;
                    }
                    aQuery.append("?" + aElem.getName());
                }
            }
            if (!(theQuery instanceof ParsedTupleQuery)) {
                aQuery.append("}");
            }
            aQuery.append(System.lineSeparator());
        } else if (this.mRenderer.getProjection().isEmpty()) {
            if (theQuery instanceof ParsedGraphQuery) {
                aQuery.append("{ }").append(System.lineSeparator());
            } else if (theQuery instanceof ParsedTupleQuery) {
                aQuery.append("*").append(System.lineSeparator());
            }
        }
        if (theQuery.getDataset() != null) {
            for (IRI aURI : theQuery.getDataset().getDefaultGraphs()) {
                aQuery.append("from <").append(aURI).append(">").append(System.lineSeparator());
            }
            for (IRI aURI : theQuery.getDataset().getNamedGraphs()) {
                aQuery.append("from named <").append(aURI).append(">").append(System.lineSeparator());
            }
        }
        if (aBody.length() > 0) {
            if (aBody.toString().trim().lastIndexOf(44) == aBody.length() - 1) {
                aBody.setCharAt(aBody.lastIndexOf(","), ' ');
            }
            if (!(theQuery instanceof ParsedBooleanQuery)) {
                aQuery.append("where ");
            }
            aQuery.append("{").append(System.lineSeparator());
            aQuery.append(aBody);
            aQuery.append("}");
        }
        if (!this.mRenderer.getOrdering().isEmpty()) {
            aQuery.append(System.lineSeparator()).append("order by ");
            aFirst = true;
            for (OrderElem aOrder : this.mRenderer.getOrdering()) {
                if (!aFirst) {
                    aQuery.append(" ");
                } else {
                    aFirst = false;
                }
                if (aOrder.isAscending()) {
                    aQuery.append(this.mRenderer.renderValueExpr(aOrder.getExpr()));
                    continue;
                }
                aQuery.append("desc(");
                aQuery.append(this.mRenderer.renderValueExpr(aOrder.getExpr()));
                aQuery.append(")");
            }
        }
        if (this.mRenderer.getLimit() != -1L && !(theQuery instanceof ParsedBooleanQuery)) {
            aQuery.append(System.lineSeparator()).append("limit ").append(this.mRenderer.getLimit());
        }
        if (this.mRenderer.getOffset() != -1L) {
            aQuery.append(System.lineSeparator()).append("offset ").append(this.mRenderer.getOffset());
        }
        return aQuery.toString();
    }
}

