/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;

public class StatementPattern
extends AbstractQueryModelNode
implements TupleExpr {
    private Scope scope;
    private Var subjectVar;
    private Var predicateVar;
    private Var objectVar;
    private Var contextVar;
    private Set<String> assuredBindingNames;
    private List<Var> varList;

    public StatementPattern(Var subject, Var predicate, Var object) {
        this(Scope.DEFAULT_CONTEXTS, subject, predicate, object);
    }

    public StatementPattern(Scope scope, Var subject, Var predicate, Var object) {
        this(scope, subject, predicate, object, null);
    }

    public StatementPattern(Var subject, Var predicate, Var object, Var context) {
        this(Scope.DEFAULT_CONTEXTS, subject, predicate, object, context);
    }

    public StatementPattern(Scope scope, Var subjVar, Var predVar, Var objVar, Var conVar) {
        Objects.requireNonNull(subjVar).setParentNode(this);
        Objects.requireNonNull(predVar).setParentNode(this);
        Objects.requireNonNull(objVar).setParentNode(this);
        this.scope = Objects.requireNonNull(scope);
        this.subjectVar = subjVar;
        this.predicateVar = predVar;
        this.objectVar = objVar;
        if (conVar != null) {
            conVar.setParentNode(this);
        }
        this.contextVar = conVar;
    }

    public Scope getScope() {
        return this.scope;
    }

    public Var getSubjectVar() {
        return this.subjectVar;
    }

    public Var getPredicateVar() {
        return this.predicateVar;
    }

    public Var getObjectVar() {
        return this.objectVar;
    }

    public Var getContextVar() {
        return this.contextVar;
    }

    @Override
    public Set<String> getBindingNames() {
        return this.getAssuredBindingNames();
    }

    @Override
    public Set<String> getAssuredBindingNames() {
        Set<String> assuredBindingNames = this.assuredBindingNames;
        if (assuredBindingNames == null) {
            this.assuredBindingNames = assuredBindingNames = this.getBindingsInternal();
        }
        return assuredBindingNames;
    }

    private Set<String> getBindingsInternal() {
        return new SmallStringSet(this.subjectVar, this.predicateVar, this.objectVar, this.contextVar);
    }

    public List<Var> getVarList() {
        List<Var> varList = this.varList;
        if (varList == null) {
            this.varList = varList = this.getVarListInternal();
        }
        return varList;
    }

    private List<Var> getVarListInternal() {
        Var[] vars = new Var[this.getSize()];
        int i = 0;
        if (this.subjectVar != null) {
            vars[i++] = this.subjectVar;
        }
        if (this.predicateVar != null) {
            vars[i++] = this.predicateVar;
        }
        if (this.objectVar != null) {
            vars[i++] = this.objectVar;
        }
        if (this.contextVar != null) {
            vars[i++] = this.contextVar;
        }
        return Arrays.asList(vars);
    }

    private int getSize() {
        int size = 0;
        if (this.subjectVar != null) {
            ++size;
        }
        if (this.predicateVar != null) {
            ++size;
        }
        if (this.objectVar != null) {
            ++size;
        }
        if (this.contextVar != null) {
            ++size;
        }
        return size;
    }

    public <L extends Collection<Var>> L getVars(L varCollection) {
        if (this.subjectVar != null) {
            varCollection.add((Var)this.subjectVar);
        }
        if (this.predicateVar != null) {
            varCollection.add((Var)this.predicateVar);
        }
        if (this.objectVar != null) {
            varCollection.add((Var)this.objectVar);
        }
        if (this.contextVar != null) {
            varCollection.add((Var)this.contextVar);
        }
        return varCollection;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        if (this.subjectVar != null) {
            this.subjectVar.visit(visitor);
        }
        if (this.predicateVar != null) {
            this.predicateVar.visit(visitor);
        }
        if (this.objectVar != null) {
            this.objectVar.visit(visitor);
        }
        if (this.contextVar != null) {
            this.contextVar.visit(visitor);
        }
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        if (this.subjectVar == current) {
            Objects.requireNonNull((Var)replacement).setParentNode(this);
            this.subjectVar = (Var)replacement;
        } else if (this.predicateVar == current) {
            Objects.requireNonNull((Var)replacement).setParentNode(this);
            this.predicateVar = (Var)replacement;
        } else if (this.objectVar == current) {
            Objects.requireNonNull((Var)replacement).setParentNode(this);
            this.objectVar = (Var)replacement;
        } else if (this.contextVar == current) {
            if (replacement != null) {
                replacement.setParentNode(this);
            }
            this.contextVar = (Var)replacement;
        } else {
            throw new IllegalArgumentException("Not a child " + current);
        }
        this.assuredBindingNames = null;
        this.varList = null;
        this.resetCardinality();
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(super.getSignature());
        if (this.scope == Scope.NAMED_CONTEXTS) {
            sb.append(" FROM NAMED CONTEXT");
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof StatementPattern) {
            StatementPattern o = (StatementPattern)other;
            return this.subjectVar.equals(o.getSubjectVar()) && this.predicateVar.equals(o.getPredicateVar()) && this.objectVar.equals(o.getObjectVar()) && Objects.equals(this.contextVar, o.getContextVar()) && this.scope.equals((Object)o.getScope());
        }
        return false;
    }

    public int hashCode() {
        int result = this.subjectVar.hashCode();
        result ^= this.predicateVar.hashCode();
        result ^= this.objectVar.hashCode();
        if (this.contextVar != null) {
            result ^= this.contextVar.hashCode();
        }
        if (this.scope == Scope.NAMED_CONTEXTS) {
            result ^= 0xFFFFFFFF;
        }
        return result;
    }

    @Override
    public StatementPattern clone() {
        StatementPattern clone = (StatementPattern)super.clone();
        Var subjectClone = this.getSubjectVar().clone();
        subjectClone.setParentNode(clone);
        clone.subjectVar = subjectClone;
        Var predicateClone = this.getPredicateVar().clone();
        predicateClone.setParentNode(clone);
        clone.predicateVar = predicateClone;
        Var objectClone = this.getObjectVar().clone();
        objectClone.setParentNode(clone);
        clone.objectVar = objectClone;
        if (this.getContextVar() != null) {
            Var contextClone = this.getContextVar().clone();
            if (contextClone != null) {
                contextClone.setParentNode(clone);
            }
            clone.contextVar = contextClone;
        }
        clone.setResultSizeEstimate(this.getResultSizeEstimate());
        clone.assuredBindingNames = this.assuredBindingNames;
        clone.varList = null;
        return clone;
    }

    @Override
    protected boolean shouldCacheCardinality() {
        return true;
    }

    private static class SmallStringSet
    extends AbstractSet<String>
    implements Serializable {
        private static final long serialVersionUID = 8771966058555603264L;
        private final String[] values;

        public SmallStringSet(Var var1, Var var2, Var var3, Var var4) {
            String[] values = new String[(var1 != null ? 1 : 0) + (var2 != null ? 1 : 0) + (var3 != null ? 1 : 0) + (var4 != null ? 1 : 0)];
            int i = 0;
            if (var1 != null) {
                values[i++] = var1.getName();
            }
            i = this.add(var2, values, i);
            i = this.add(var3, values, i);
            this.values = (i = this.add(var4, values, i)) == values.length ? values : Arrays.copyOfRange(values, 0, i);
        }

        private int add(Var var, String[] names, int i) {
            if (var == null) {
                return i;
            }
            String name = var.getName();
            boolean unique = true;
            for (int j = 0; j < i; ++j) {
                if (!names[j].equals(name)) continue;
                unique = false;
                break;
            }
            if (unique) {
                names[i++] = name;
            }
            return i;
        }

        @Override
        public Iterator<String> iterator() {
            return Arrays.asList(this.values).iterator();
        }

        @Override
        public int size() {
            return this.values.length;
        }
    }

    public static enum Scope {
        DEFAULT_CONTEXTS,
        NAMED_CONTEXTS;

    }
}

