/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.shacl.ast.Targetable;

public class StatementMatcher {
    private final Variable<? extends Resource> subject;
    private final Variable<IRI> predicate;
    private final Variable<? extends Value> object;
    private final Targetable origin;
    private Set<String> inheritedVarNames;
    private List<StatementMatcher> subset = List.of();
    private static final Variable<Resource> NULL_SUBJECT = new Variable();
    private static final Variable<IRI> NULL_PREDICATE = new Variable();
    private static final Variable<Value> NULL_OBJECT = new Variable();

    public StatementMatcher(Variable<? extends Resource> subject, Variable<IRI> predicate, Variable<? extends Value> object, Targetable origin, Set<String> inheritedVarNames) {
        this.subject = Objects.requireNonNullElse(subject, NULL_SUBJECT);
        this.predicate = Objects.requireNonNullElse(predicate, NULL_PREDICATE);
        this.object = Objects.requireNonNullElse(object, NULL_OBJECT);
        this.origin = origin;
        this.inheritedVarNames = inheritedVarNames;
        assert (this.subject.name == null || this.subject.value == null);
        assert (this.predicate.name == null || this.predicate.value == null);
        assert (this.object.name == null || this.object.value == null);
    }

    private static Set<String> calculateVarNames(Variable<?> subject, Variable<?> predicate, Variable<?> object) {
        if (subject.baseName == null && predicate.baseName == null && object.baseName == null) {
            if (subject.name != null) {
                if (predicate.name != null) {
                    if (object.name != null) {
                        return Set.of(subject.name, predicate.name, object.name);
                    }
                    return Set.of(subject.name, predicate.name);
                }
                if (object.name != null) {
                    return Set.of(subject.name, object.name);
                }
                return Set.of(subject.name);
            }
            if (predicate.name != null) {
                if (object.name != null) {
                    return Set.of(predicate.name, object.name);
                }
                return Set.of(predicate.name);
            }
            if (object.name != null) {
                return Set.of(object.name);
            }
            return Set.of();
        }
        HashSet<String> varNames = new HashSet<String>();
        if (subject.name != null) {
            varNames.add(subject.name);
        }
        if (subject.baseName != null) {
            varNames.add(subject.baseName);
        }
        if (predicate.name != null) {
            varNames.add(predicate.name);
        }
        if (predicate.baseName != null) {
            varNames.add(predicate.baseName);
        }
        if (object.name != null) {
            varNames.add(object.name);
        }
        if (object.baseName != null) {
            varNames.add(object.baseName);
        }
        return varNames;
    }

    public static List<StatementMatcher> reduce(List<StatementMatcher> statementMatchers) {
        if (statementMatchers.size() == 1) {
            return statementMatchers;
        }
        List wildcardMatchers = statementMatchers.stream().filter(s -> s.subjectIsWildcard() || s.predicateIsWildcard() || s.objectIsWildcard()).collect(Collectors.toList());
        if (wildcardMatchers.isEmpty()) {
            return statementMatchers;
        }
        return statementMatchers.stream().filter(s -> {
            for (StatementMatcher statementMatcher : wildcardMatchers) {
                if (statementMatcher == s || !statementMatcher.covers((StatementMatcher)s) || s.hasSubset(statementMatcher)) continue;
                statementMatcher.addSubset((StatementMatcher)s);
                for (StatementMatcher matcher : s.subset) {
                    statementMatcher.addSubset(matcher);
                }
                s.subset = List.of();
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    private void addSubset(StatementMatcher s) {
        if (this.subset.isEmpty()) {
            this.subset = List.of(s);
        } else if (this.subset.size() == 1) {
            this.subset = List.of(this.subset.get(0), s);
        } else if (this.subset.size() == 2) {
            this.subset = List.of(this.subset.get(0), this.subset.get(1), s);
        } else {
            if (this.subset.size() == 3) {
                this.subset = new ArrayList<StatementMatcher>(this.subset);
            }
            this.subset.add(s);
        }
    }

    public static List<StatementMatcher> swap(List<StatementMatcher> statementMatchers, Variable<?> existingVariable, Variable<?> newVariable) {
        if (statementMatchers.isEmpty()) {
            return List.of();
        }
        if (statementMatchers.size() == 1) {
            StatementMatcher statementMatcher2 = statementMatchers.get(0);
            return List.of(statementMatcher2.swap(existingVariable, newVariable));
        }
        return statementMatchers.stream().map(statementMatcher -> statementMatcher.swap(existingVariable, newVariable)).collect(Collectors.toList());
    }

    private static String formatForToString(String field, String name, Value value) {
        if (value == null && name == null) {
            return field + "[*]";
        }
        StringBuilder ret = new StringBuilder(field).append("[");
        if (name != null) {
            ret.append("\"").append(name).append("\"").append("=");
        }
        if (value == null) {
            ret.append("*");
        } else if (value.isIRI()) {
            IRI iri = (IRI)value;
            if (iri.getNamespace().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
                ret.append("rdf:").append(iri.getLocalName());
            } else if (iri.getNamespace().equals("http://www.w3.org/ns/shacl#")) {
                ret.append("sh:").append(iri.getLocalName());
            } else if (iri.getNamespace().equals("http://www.w3.org/2000/01/rdf-schema#")) {
                ret.append("rdfs:").append(iri.getLocalName());
            } else {
                ret.append("<").append(iri).append(">");
            }
        } else {
            ret.append(value);
        }
        return ret.append("]").toString();
    }

    private StatementMatcher swap(Variable<?> existingVariable, Variable<?> newVariable) {
        String subjectName = this.getSubjectName();
        String subjectBasename = this.getSubjectBasename();
        Resource subjectValue = this.getSubjectValue();
        String predicateName = this.getPredicateName();
        String predicateBasename = this.getPredicateBasename();
        IRI predicateValue = this.getPredicateValue();
        String objectName = this.getObjectName();
        String objectBasename = this.getObjectBasename();
        Value objectValue = this.getObjectValue();
        boolean changed = false;
        if (Objects.equals(existingVariable.name, subjectName) && Objects.equals(existingVariable.value, subjectValue)) {
            changed = true;
            subjectName = newVariable.name;
            subjectValue = (Resource)newVariable.value;
            subjectBasename = newVariable.baseName;
        }
        if (Objects.equals(existingVariable.name, predicateName) && Objects.equals(existingVariable.value, predicateValue)) {
            changed = true;
            predicateName = newVariable.name;
            predicateValue = (IRI)newVariable.value;
            predicateBasename = newVariable.baseName;
        }
        if (Objects.equals(existingVariable.name, objectName) && Objects.equals(existingVariable.value, objectValue)) {
            changed = true;
            objectName = newVariable.name;
            objectValue = newVariable.value;
            objectBasename = newVariable.baseName;
        }
        if (changed) {
            assert (this.subset.isEmpty());
            return new StatementMatcher(new Variable<Resource>(subjectName, subjectValue, subjectBasename), new Variable<IRI>(predicateName, predicateValue, predicateBasename), new Variable<Value>(objectName, objectValue, objectBasename), this.origin, this.inheritedVarNames);
        }
        return this;
    }

    public boolean covers(StatementMatcher s) {
        return StatementMatcher.covers(this.subject, s.subject) && StatementMatcher.covers(this.predicate, s.predicate) && StatementMatcher.covers(this.object, s.object);
    }

    private static boolean covers(Variable<?> bigger, Variable<?> smaller) {
        return Objects.equals(bigger.name, smaller.name) && (bigger.isWildcard() || Objects.equals(bigger.value, smaller.value));
    }

    public String getSubjectName() {
        return this.subject.name;
    }

    public String getSubjectBasename() {
        return this.subject.baseName;
    }

    public Resource getSubjectValue() {
        return (Resource)this.subject.value;
    }

    public boolean subjectIsWildcard() {
        return this.subject.isWildcard();
    }

    public String getPredicateName() {
        return this.predicate.name;
    }

    public String getPredicateBasename() {
        return this.predicate.baseName;
    }

    public IRI getPredicateValue() {
        return (IRI)this.predicate.value;
    }

    public boolean predicateIsWildcard() {
        return this.predicate.isWildcard();
    }

    public String getObjectName() {
        return this.object.name;
    }

    public String getObjectBasename() {
        return this.object.baseName;
    }

    public Value getObjectValue() {
        return this.object.value;
    }

    public boolean objectIsWildcard() {
        return this.object.isWildcard();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatementMatcher that = (StatementMatcher)o;
        return Objects.equals(this.subject.name, that.subject.name) && Objects.equals(this.subject.value, that.subject.value) && Objects.equals(this.predicate.name, that.predicate.name) && Objects.equals(this.predicate.value, that.predicate.value) && Objects.equals(this.object.name, that.object.name) && Objects.equals(this.object.value, that.object.value);
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.predicate, this.object);
    }

    public String getSparqlValuesDecl(Set<String> varNamesRestriction, boolean addInheritedVarNames, Set<String> varNamesInQueryFragment) {
        StringBuilder sb = new StringBuilder("VALUES ( ");
        if ((this.subject.name != null && varNamesRestriction.contains(this.subject.name) || this.subject.baseName != null && varNamesRestriction.contains(this.subject.baseName)) && varNamesInQueryFragment.contains(this.subject.name)) {
            sb.append("?").append(this.subject.name).append(" ");
        }
        if ((this.predicate.name != null && varNamesRestriction.contains(this.predicate.name) || this.predicate.baseName != null && varNamesRestriction.contains(this.predicate.baseName)) && varNamesInQueryFragment.contains(this.predicate.name)) {
            sb.append("?").append(this.predicate.name).append(" ");
        }
        if ((this.object.name != null && varNamesRestriction.contains(this.object.name) || this.object.baseName != null && varNamesRestriction.contains(this.object.baseName)) && varNamesInQueryFragment.contains(this.object.name)) {
            sb.append("?").append(this.object.name).append(" ");
        }
        if (addInheritedVarNames) {
            for (String inheritedVarName : this.inheritedVarNames) {
                if (inheritedVarName.equals(this.subject.name) || inheritedVarName.equals(this.predicate.name) || inheritedVarName.equals(this.object.name) || !varNamesRestriction.contains(inheritedVarName) || !varNamesInQueryFragment.contains(inheritedVarName)) continue;
                sb.append("?").append(inheritedVarName).append(" ");
            }
        }
        sb.append("){}\n");
        return sb.toString();
    }

    public LinkedHashSet<String> getVarNames(Set<String> varNamesRestriction, boolean addInheritedVarNames, Set<String> varNamesInQueryFragment) {
        if (varNamesRestriction.isEmpty()) {
            return new LinkedHashSet<String>();
        }
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        if (this.subject.name != null && varNamesRestriction.contains(this.subject.name) && varNamesInQueryFragment.contains(this.subject.name)) {
            ret.add(this.subject.name);
        } else if (this.subject.baseName != null && varNamesRestriction.contains(this.subject.baseName) && varNamesInQueryFragment.contains(this.subject.name)) {
            ret.add(this.subject.name);
        }
        if (this.predicate.name != null && varNamesRestriction.contains(this.predicate.name) && varNamesInQueryFragment.contains(this.predicate.name)) {
            ret.add(this.predicate.name);
        } else if (this.predicate.baseName != null && varNamesRestriction.contains(this.predicate.baseName) && varNamesInQueryFragment.contains(this.predicate.name)) {
            ret.add(this.predicate.name);
        }
        if (this.object.name != null && varNamesRestriction.contains(this.object.name) && varNamesInQueryFragment.contains(this.object.name)) {
            ret.add(this.object.name);
        } else if (this.object.baseName != null && varNamesRestriction.contains(this.object.baseName) && varNamesInQueryFragment.contains(this.object.name)) {
            ret.add(this.object.name);
        }
        if (addInheritedVarNames) {
            for (String inheritedVarName : this.inheritedVarNames) {
                if (!varNamesRestriction.contains(inheritedVarName) || !varNamesInQueryFragment.contains(inheritedVarName)) continue;
                ret.add(inheritedVarName);
            }
        }
        return ret;
    }

    public String toString() {
        return "StatementMatcher{ " + StatementMatcher.formatForToString("s", this.subject.name, this.subject.value) + ", " + StatementMatcher.formatForToString("p", this.predicate.name, this.predicate.value) + ", " + StatementMatcher.formatForToString("o", this.object.name, this.object.value) + " }";
    }

    public boolean hasSubset(StatementMatcher currentStatementMatcher) {
        for (StatementMatcher statementMatcher : this.subset) {
            if (currentStatementMatcher != statementMatcher) continue;
            return true;
        }
        return false;
    }

    public Targetable getOrigin() {
        return this.origin;
    }

    public boolean hasSubject(Variable<Resource> variable) {
        if (this.subject.name == null) {
            return false;
        }
        if (variable.name == this.subject.name) {
            return true;
        }
        return variable.name.equals(this.subject.name);
    }

    public boolean hasObject(Variable<Value> variable) {
        if (this.object.name == null) {
            return false;
        }
        if (variable.name == this.object.name) {
            return true;
        }
        return variable.name.equals(this.object.name);
    }

    public Set<String> getInheritedVarNames() {
        return Set.copyOf(this.inheritedVarNames);
    }

    public Set<String> getVarNames() {
        HashSet<String> varNames = new HashSet<String>();
        if (this.subject.name != null) {
            varNames.add(this.subject.name);
        }
        if (this.predicate.name != null) {
            varNames.add(this.predicate.name);
        }
        if (this.object.name != null) {
            varNames.add(this.object.name);
        }
        return Collections.unmodifiableSet(varNames);
    }

    private void replaceVariableName(String original, String replacement) {
        if (this.subject.name != null && this.subject.name.contains(original)) {
            this.subject.name = this.subject.name.replace(original, replacement);
        }
        if (this.subject.baseName != null && this.subject.baseName.contains(original)) {
            this.subject.baseName = this.subject.baseName.replace(original, replacement);
        }
        if (this.predicate.name != null && this.predicate.name.contains(original)) {
            this.predicate.name = this.predicate.name.replace(original, replacement);
        }
        if (this.predicate.baseName != null && this.predicate.baseName.contains(original)) {
            this.predicate.baseName = this.predicate.baseName.replace(original, replacement);
        }
        if (this.object.name != null && this.object.name.contains(original)) {
            this.object.name = this.object.name.replace(original, replacement);
        }
        if (this.object.baseName != null && this.object.baseName.contains(original)) {
            this.object.baseName = this.object.baseName.replace(original, replacement);
        }
        boolean contains = false;
        for (String inheritedVarName : this.inheritedVarNames) {
            if (!inheritedVarName.contains(original)) continue;
            contains = true;
            break;
        }
        if (contains) {
            HashSet<String> newInheritedVarNames = new HashSet<String>();
            for (String inheritedVarName : this.inheritedVarNames) {
                newInheritedVarNames.add(inheritedVarName.replace(original, replacement));
            }
            this.inheritedVarNames = newInheritedVarNames;
        }
    }

    public static class Variable<T extends Value> {
        public static final Variable<Value> VALUE = new Variable("value");
        public static final Variable<Value> THIS = new Variable("this");
        String name;
        T value;
        String baseName;

        public Variable(String name, T value) {
            this.name = name;
            this.value = value;
        }

        public Variable(String name) {
            this.name = name;
        }

        public Variable(Variable<?> baseVariable, String name) {
            this.name = name;
            this.baseName = baseVariable.name;
        }

        public Variable(String name, T value, String baseName) {
            this.name = name;
            this.value = value;
            this.baseName = baseName;
        }

        public Variable(T value) {
            this.value = value;
        }

        public Variable() {
        }

        public String getName() {
            return this.name;
        }

        public T getValue() {
            return this.value;
        }

        public boolean isWildcard() {
            return this.value == null;
        }

        public String asSparqlVariable() {
            if (this.value != null) {
                throw new IllegalStateException("Can not produce SPARQL variable for variables that have fixed values!");
            }
            return "?" + this.name.replace("-", "__");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Variable variable = (Variable)o;
            return Objects.equals(this.name, variable.name) && Objects.equals(this.value, variable.value);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.value);
        }

        public String toString() {
            return "Variable{name='" + this.name + "', value=" + this.value + "}";
        }
    }

    public static class StableRandomVariableProvider {
        private static final String BASE = UUID.randomUUID().toString().replace("-", "") + "_";
        private static volatile int max = 0;
        private final String prefix;
        private int counter = -1;

        public StableRandomVariableProvider() {
            this.prefix = "";
        }

        public StableRandomVariableProvider(String prefix) {
            this.prefix = prefix;
        }

        public static String normalize(String inputQuery, List<? extends Variable> protectedVars, List<StatementMatcher> union) {
            int max;
            if (!inputQuery.contains(BASE)) {
                return inputQuery;
            }
            int lowest = max = Math.min(100, StableRandomVariableProvider.max);
            int highest = 0;
            boolean incrementsOfOne = true;
            int prev = -1;
            for (int i = 0; i <= max; ++i) {
                if (!inputQuery.contains(BASE + i + "_")) continue;
                lowest = Math.min(lowest, i);
                highest = Math.max(highest, i);
                if (prev >= 0 && prev + 1 != i) {
                    incrementsOfOne = false;
                }
                prev = i;
            }
            if (lowest == 0 && incrementsOfOne) {
                return inputQuery;
            }
            String joinedProtectedVars = protectedVars.stream().map(Variable::getName).filter(Objects::nonNull).filter(s -> s.contains(BASE)).collect(Collectors.joining());
            return StableRandomVariableProvider.normalizeRange(inputQuery, lowest, highest, joinedProtectedVars, union);
        }

        private static String normalizeRange(String inputQuery, int lowest, int highest, String joinedProtectedVars, List<StatementMatcher> union) {
            String normalizedQuery = inputQuery;
            block0: for (int i = 0; i <= highest; ++i) {
                String replacement = BASE + i + "_";
                if (normalizedQuery.contains(replacement)) continue;
                for (int j = Math.max(i + 1, lowest); j <= highest; ++j) {
                    String original = BASE + j + "_";
                    if (!normalizedQuery.contains(original) || joinedProtectedVars.contains(original)) continue;
                    normalizedQuery = normalizedQuery.replace(original, replacement);
                    StableRandomVariableProvider.replaceInStatementMatcher(union, original, replacement);
                    continue block0;
                }
            }
            return normalizedQuery;
        }

        private static void replaceInStatementMatcher(List<StatementMatcher> statementMatchers, String original, String replacement) {
            for (StatementMatcher statementMatcher : statementMatchers) {
                statementMatcher.replaceVariableName(original, replacement);
            }
        }

        public Variable<Value> next() {
            ++this.counter;
            if (this.counter > max) {
                max = this.counter;
            }
            return this.current();
        }

        public Variable<Value> current() {
            if (this.counter < 0) {
                throw new IllegalStateException("next() has not been called");
            }
            return new Variable<CallSite>((CallSite)((Object)(this.prefix + BASE + this.counter + "_")));
        }
    }
}

