/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.endpoint;

import java.io.File;
import java.io.FileReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.endpoint.EndpointType;
import org.eclipse.rdf4j.federated.endpoint.provider.NativeRepositoryInformation;
import org.eclipse.rdf4j.federated.endpoint.provider.NativeStoreProvider;
import org.eclipse.rdf4j.federated.endpoint.provider.RemoteRepositoryProvider;
import org.eclipse.rdf4j.federated.endpoint.provider.RemoteRepositoryRepositoryInformation;
import org.eclipse.rdf4j.federated.endpoint.provider.RepositoryEndpointProvider;
import org.eclipse.rdf4j.federated.endpoint.provider.RepositoryInformation;
import org.eclipse.rdf4j.federated.endpoint.provider.ResolvableRepositoryInformation;
import org.eclipse.rdf4j.federated.endpoint.provider.ResolvableRepositoryProvider;
import org.eclipse.rdf4j.federated.endpoint.provider.SPARQLProvider;
import org.eclipse.rdf4j.federated.endpoint.provider.SPARQLRepositoryInformation;
import org.eclipse.rdf4j.federated.exception.FedXException;
import org.eclipse.rdf4j.federated.exception.FedXRuntimeException;
import org.eclipse.rdf4j.federated.util.FedXUtil;
import org.eclipse.rdf4j.federated.util.Vocabulary;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.TreeModel;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointFactory {
    private static final Logger logger = LoggerFactory.getLogger(EndpointFactory.class);

    public static Endpoint loadSPARQLEndpoint(String name, String endpoint) throws FedXException {
        SPARQLProvider repProvider = new SPARQLProvider();
        return repProvider.loadEndpoint(new SPARQLRepositoryInformation(name, endpoint));
    }

    public static Endpoint loadSPARQLEndpoint(String endpoint) throws FedXException {
        try {
            Object id = new URL(endpoint).getHost();
            if (((String)id).equals("localhost")) {
                id = (String)id + "_" + new URL(endpoint).getPort();
            }
            return EndpointFactory.loadSPARQLEndpoint("http://" + (String)id, endpoint);
        }
        catch (MalformedURLException e) {
            throw new FedXException("Malformed URL: " + endpoint);
        }
    }

    public static Endpoint loadRemoteRepository(String repositoryServer, String repositoryName) throws FedXException {
        return EndpointFactory.loadRemoteRepository(repositoryServer, repositoryName, false);
    }

    public static Endpoint loadRemoteRepository(String repositoryServer, String repositoryName, boolean writable) throws FedXException {
        RemoteRepositoryProvider repProvider = new RemoteRepositoryProvider();
        RemoteRepositoryRepositoryInformation info = new RemoteRepositoryRepositoryInformation(repositoryServer, repositoryName);
        info.setWritable(writable);
        return repProvider.loadEndpoint(info);
    }

    public static Endpoint loadResolvableRepository(String repositoryId) {
        return EndpointFactory.loadResolvableRepository(repositoryId, false);
    }

    public static Endpoint loadResolvableRepository(String repositoryId, boolean writable) {
        ResolvableRepositoryProvider repProvider = new ResolvableRepositoryProvider();
        ResolvableRepositoryInformation info = new ResolvableRepositoryInformation(repositoryId);
        info.setWritable(writable);
        return repProvider.loadEndpoint(info);
    }

    public static Endpoint loadEndpoint(String id, Repository repository) throws FedXException {
        RepositoryEndpointProvider repProvider = new RepositoryEndpointProvider(repository);
        String name = "http://" + id;
        String location = "http://unknown";
        try {
            location = repository.getDataDir().getAbsolutePath();
        }
        catch (Exception e) {
            logger.debug("Failed to use data dir as location, using unknown instead: " + e.getMessage());
            logger.trace("Details:", (Throwable)e);
        }
        return repProvider.loadEndpoint(new RepositoryInformation(id, name, location, EndpointType.Other));
    }

    public static Endpoint loadNativeEndpoint(String name, File location) throws FedXException {
        File baseDir = null;
        NativeStoreProvider repProvider = new NativeStoreProvider(baseDir);
        return repProvider.loadEndpoint(new NativeRepositoryInformation(name, location.getAbsolutePath()));
    }

    public static Endpoint loadNativeEndpoint(File location) throws FedXException {
        return EndpointFactory.loadNativeEndpoint("http://" + location.getName(), location);
    }

    public static List<Endpoint> loadFederationMembers(File dataConfig, File fedXBaseDir) throws FedXException {
        if (!dataConfig.exists()) {
            throw new FedXRuntimeException("File does not exist: " + dataConfig.getAbsolutePath());
        }
        TreeModel graph = new TreeModel();
        RDFParser parser = Rio.createParser(RDFFormat.TURTLE);
        DefaultRDFHandler handler = new DefaultRDFHandler(graph);
        parser.setRDFHandler(handler);
        try (FileReader fr = new FileReader(dataConfig);){
            parser.parse(fr, "http://rdf4j.org/config/federation#");
        }
        catch (Exception e) {
            throw new FedXException("Unable to parse dataconfig " + dataConfig + ":" + e.getMessage());
        }
        return EndpointFactory.loadFederationMembers(graph, fedXBaseDir);
    }

    public static List<Endpoint> loadFederationMembers(Model members, File baseDir) throws FedXException {
        ArrayList<Endpoint> res = new ArrayList<Endpoint>();
        for (Statement st : members.getStatements(null, Vocabulary.FEDX.STORE, null, new Resource[0])) {
            Endpoint e = EndpointFactory.loadEndpoint(members, st.getSubject(), st.getObject(), baseDir);
            res.add(e);
        }
        return res;
    }

    private static Endpoint loadEndpoint(Model graph, Resource repNode, Value repType, File baseDir) throws FedXException {
        if (repType.equals(FedXUtil.literal("NativeStore"))) {
            NativeStoreProvider repProvider = new NativeStoreProvider(baseDir);
            return repProvider.loadEndpoint(new NativeRepositoryInformation(graph, repNode));
        }
        if (repType.equals(FedXUtil.literal("SPARQLEndpoint"))) {
            SPARQLProvider repProvider = new SPARQLProvider();
            return repProvider.loadEndpoint(new SPARQLRepositoryInformation(graph, repNode));
        }
        if (repType.equals(FedXUtil.literal("RemoteRepository"))) {
            RemoteRepositoryProvider repProvider = new RemoteRepositoryProvider();
            return repProvider.loadEndpoint(new RemoteRepositoryRepositoryInformation(graph, repNode));
        }
        if (repType.equals(FedXUtil.literal("ResolvableRepository"))) {
            ResolvableRepositoryProvider repProvider = new ResolvableRepositoryProvider();
            return repProvider.loadEndpoint(new ResolvableRepositoryInformation(graph, repNode));
        }
        if (repType.equals(FedXUtil.literal("Other"))) {
            throw new UnsupportedOperationException("Operation not yet supported for generic type.");
        }
        throw new FedXRuntimeException("Repository type not supported: " + repType.stringValue());
    }

    public static String getId(String endpointID, String type) {
        String id = endpointID.replace("http://", "");
        id = id.replace("/", "_");
        return type + "_" + id;
    }

    protected static class DefaultRDFHandler
    implements RDFHandler {
        protected final Model graph;

        public DefaultRDFHandler(Model graph) {
            this.graph = graph;
        }

        @Override
        public void endRDF() throws RDFHandlerException {
        }

        @Override
        public void handleComment(String comment) throws RDFHandlerException {
        }

        @Override
        public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        }

        @Override
        public void handleStatement(Statement st) throws RDFHandlerException {
            this.graph.add(st);
        }

        @Override
        public void startRDF() throws RDFHandlerException {
        }
    }
}

