/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.ref.Cleaner;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.time.StopWatch;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.ConcurrentCleaner;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteratorIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;
import org.eclipse.rdf4j.sail.SailConflictException;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.BackingSailSource;
import org.eclipse.rdf4j.sail.base.SailDataset;
import org.eclipse.rdf4j.sail.base.SailSink;
import org.eclipse.rdf4j.sail.base.SailSource;
import org.eclipse.rdf4j.sail.base.SailStore;
import org.eclipse.rdf4j.sail.memory.MemEvaluationStatistics;
import org.eclipse.rdf4j.sail.memory.MemNamespaceStore;
import org.eclipse.rdf4j.sail.memory.model.MemBNode;
import org.eclipse.rdf4j.sail.memory.model.MemIRI;
import org.eclipse.rdf4j.sail.memory.model.MemResource;
import org.eclipse.rdf4j.sail.memory.model.MemStatement;
import org.eclipse.rdf4j.sail.memory.model.MemStatementIterator;
import org.eclipse.rdf4j.sail.memory.model.MemStatementIteratorCache;
import org.eclipse.rdf4j.sail.memory.model.MemStatementList;
import org.eclipse.rdf4j.sail.memory.model.MemTriple;
import org.eclipse.rdf4j.sail.memory.model.MemTripleIterator;
import org.eclipse.rdf4j.sail.memory.model.MemValue;
import org.eclipse.rdf4j.sail.memory.model.MemValueFactory;
import org.eclipse.rdf4j.sail.memory.model.WeakObjectRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MemorySailStore
implements SailStore {
    private static final Logger logger = LoggerFactory.getLogger(MemorySailStore.class);
    private static final Runtime RUNTIME = Runtime.getRuntime();
    private static final long MAX_MEMORY = RUNTIME.maxMemory();
    private static final int CLEANUP_MAX_MEMORY_THRESHOLD = 0x10000000;
    private static final int CLEANUP_MINIMUM_FREE_MEMORY = 0x4000000;
    private static final double CLEANUP_MINIMUM_FREE_MEMORY_RATIO = 0.125;
    public static final EmptyIteration<MemStatement, SailException> EMPTY_ITERATION = new EmptyIteration();
    public static final EmptyIteration<MemTriple, SailException> EMPTY_TRIPLE_ITERATION = new EmptyIteration();
    public static final MemResource[] EMPTY_CONTEXT = new MemResource[0];
    public static final MemResource[] NULL_CONTEXT = new MemResource[]{null};
    private final MemStatementIteratorCache iteratorCache = new MemStatementIteratorCache(10);
    private final MemValueFactory valueFactory = new MemValueFactory();
    private final MemStatementList statements = new MemStatementList(256);
    private volatile boolean mayHaveInferred = false;
    private volatile int currentSnapshot;
    final SnapshotMonitor snapshotMonitor;
    private final MemNamespaceStore namespaceStore = new MemNamespaceStore();
    private final ReentrantLock txnLockManager = new ReentrantLock();
    private volatile Thread snapshotCleanupThread;
    private final Object snapshotCleanupThreadLockObject = new Object();

    public MemorySailStore(boolean debug) {
        this.snapshotMonitor = new SnapshotMonitor(debug);
    }

    @Override
    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.snapshotCleanupThreadLockObject;
        synchronized (object) {
            if (this.snapshotCleanupThread != null) {
                this.snapshotCleanupThread.interrupt();
                this.snapshotCleanupThread = null;
            }
        }
        this.valueFactory.clear();
        this.statements.clear();
        this.namespaceStore.clear();
        this.invalidateCache();
    }

    private void invalidateCache() {
        this.iteratorCache.invalidateCache();
    }

    @Override
    public EvaluationStatistics getEvaluationStatistics() {
        return new MemEvaluationStatistics(this.valueFactory, this.statements);
    }

    @Override
    public SailSource getExplicitSailSource() {
        return new MemorySailSource(true);
    }

    @Override
    public SailSource getInferredSailSource() {
        return new MemorySailSource(false);
    }

    private CloseableIteration<MemStatement, SailException> createStatementIterator(Resource subj, IRI pred, Value obj, Boolean explicit, int snapshot, Resource ... contexts) throws InterruptedException {
        MemStatementList smallestList;
        MemResource[] memContexts;
        if (explicit != null && !explicit.booleanValue() && !this.mayHaveInferred && snapshot >= 0) {
            return EMPTY_ITERATION;
        }
        if (this.statements.isEmpty()) {
            return EMPTY_ITERATION;
        }
        MemResource memSubj = this.valueFactory.getMemResource(subj);
        if (subj != null && memSubj == null) {
            return EMPTY_ITERATION;
        }
        MemIRI memPred = this.valueFactory.getMemURI(pred);
        if (pred != null && memPred == null) {
            return EMPTY_ITERATION;
        }
        MemValue memObj = this.valueFactory.getMemValue(obj);
        if (obj != null && memObj == null) {
            return EMPTY_ITERATION;
        }
        if (contexts.length == 0) {
            memContexts = EMPTY_CONTEXT;
            smallestList = this.statements;
        } else if (contexts.length == 1 && contexts[0] == null) {
            memContexts = NULL_CONTEXT;
            smallestList = this.statements;
        } else if (contexts.length == 1) {
            MemResource memContext = this.valueFactory.getMemResource(contexts[0]);
            if (memContext == null) {
                return EMPTY_ITERATION;
            }
            memContexts = new MemResource[]{memContext};
            smallestList = memContext.getContextStatementList();
            if (smallestList.isEmpty()) {
                return EMPTY_ITERATION;
            }
        } else {
            LinkedHashSet<MemResource> contextSet = new LinkedHashSet<MemResource>(2 * contexts.length);
            for (Resource context : contexts) {
                MemResource memContext = this.valueFactory.getMemResource(context);
                if (context != null && memContext == null) continue;
                contextSet.add(memContext);
            }
            if (contextSet.isEmpty()) {
                return EMPTY_ITERATION;
            }
            memContexts = contextSet.toArray(new MemResource[contextSet.size()]);
            smallestList = this.statements;
        }
        return this.getMemStatementIterator(memSubj, memPred, memObj, explicit, snapshot, memContexts, smallestList);
    }

    private CloseableIteration<MemStatement, SailException> getMemStatementIterator(MemResource subj, MemIRI pred, MemValue obj, Boolean explicit, int snapshot, MemResource[] memContexts, MemStatementList statementList) throws InterruptedException {
        if (explicit != null && !explicit.booleanValue() && !this.mayHaveInferred && snapshot >= 0) {
            return EMPTY_ITERATION;
        }
        MemStatementList smallestList = this.getSmallestStatementList(subj, pred, obj);
        if (smallestList == null) {
            smallestList = statementList;
        } else {
            if (smallestList.isEmpty()) {
                return EMPTY_ITERATION;
            }
            if (smallestList.size() > statementList.size()) {
                smallestList = statementList;
            }
        }
        return MemStatementIterator.cacheAwareInstance(smallestList, subj, pred, obj, explicit, snapshot, memContexts, this.iteratorCache);
    }

    private MemStatementList getSmallestStatementList(MemResource subj, MemIRI pred, MemValue obj) {
        MemStatementList l;
        MemStatementList smallestList = null;
        if (subj != null && (smallestList = subj.getSubjectStatementList()).isEmpty()) {
            return smallestList;
        }
        if (pred != null) {
            l = pred.getPredicateStatementList();
            if (smallestList == null ? (smallestList = l).isEmpty() : l.size() < smallestList.size() && (smallestList = l).isEmpty()) {
                return smallestList;
            }
        }
        if (obj != null) {
            l = obj.getObjectStatementList();
            if (smallestList == null) {
                smallestList = l;
            } else if (l.size() < smallestList.size()) {
                smallestList = l;
            }
        }
        return smallestList;
    }

    private CloseableIteration<MemTriple, SailException> createTripleIterator(Resource subj, IRI pred, Value obj, int snapshot) throws InterruptedException {
        MemResource memSubj = this.valueFactory.getMemResource(subj);
        if (subj != null && memSubj == null) {
            return EMPTY_TRIPLE_ITERATION;
        }
        MemIRI memPred = this.valueFactory.getMemURI(pred);
        if (pred != null && memPred == null) {
            return EMPTY_TRIPLE_ITERATION;
        }
        MemValue memObj = this.valueFactory.getMemValue(obj);
        if (obj != null && memObj == null) {
            return EMPTY_TRIPLE_ITERATION;
        }
        return new MemTripleIterator<SailException>(this.statements, memSubj, memPred, memObj, snapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanSnapshots() throws InterruptedException {
        int currentSnapshot = this.currentSnapshot;
        int highestUnusedTillSnapshot = this.snapshotMonitor.getFirstUnusedOrElse(currentSnapshot - 1);
        if (highestUnusedTillSnapshot >= currentSnapshot) {
            logger.debug("No old snapshot versions are currently unused, {} >= {} (currentSnapshot).", (Object)highestUnusedTillSnapshot, (Object)currentSnapshot);
        }
        try {
            boolean prioritiseCleaning = false;
            StopWatch stopWatch = null;
            if (logger.isDebugEnabled()) {
                stopWatch = StopWatch.createStarted();
                logger.debug("Started cleaning snapshots.");
            }
            prioritiseCleaning = this.prioritiseSnapshotCleaningIfLowOnMemory(prioritiseCleaning);
            HashSet<MemResource> processedSubjects = new HashSet<MemResource>();
            HashSet<MemIRI> processedPredicates = new HashSet<MemIRI>();
            HashSet<MemValue> processedObjects = new HashSet<MemValue>();
            HashSet<MemResource> processedContexts = new HashSet<MemResource>();
            MemStatement[] statements = this.statements.getStatements();
            for (int i = statements.length - 1; i >= 0 && !Thread.currentThread().isInterrupted(); --i) {
                MemStatement st = statements[i];
                if (st == null) continue;
                if (st.getTillSnapshot() <= highestUnusedTillSnapshot) {
                    MemResource context;
                    MemValue obj;
                    MemIRI pred;
                    MemResource subj = (MemResource)st.getSubject();
                    if (processedSubjects.add(subj)) {
                        subj.cleanSnapshotsFromSubjectStatements(highestUnusedTillSnapshot);
                    }
                    if (processedPredicates.add(pred = (MemIRI)st.getPredicate())) {
                        pred.cleanSnapshotsFromPredicateStatements(highestUnusedTillSnapshot);
                    }
                    if (processedObjects.add(obj = (MemValue)st.getObject())) {
                        obj.cleanSnapshotsFromObjectStatements(highestUnusedTillSnapshot);
                    }
                    if ((context = (MemResource)st.getContext()) != null && processedContexts.add(context)) {
                        context.cleanSnapshotsFromContextStatements(highestUnusedTillSnapshot);
                    }
                    this.statements.remove(st, i);
                    prioritiseCleaning = this.prioritiseSnapshotCleaningIfLowOnMemory(prioritiseCleaning);
                }
                if (i % 100000 != 0 || this.getFreeToAllocateMemory() >= 0x2000000L) continue;
                prioritiseCleaning = this.prioritiseSnapshotCleaningIfLowOnMemory(prioritiseCleaning);
                processedSubjects = new HashSet();
                processedPredicates = new HashSet();
                processedObjects = new HashSet();
                processedContexts = new HashSet();
                System.gc();
            }
            processedSubjects.clear();
            processedPredicates.clear();
            processedObjects.clear();
            processedContexts.clear();
            if (logger.isDebugEnabled() && stopWatch != null) {
                stopWatch.stop();
                logger.debug("Cleaning snapshots took {} seconds.", (Object)stopWatch.getTime(TimeUnit.SECONDS));
            }
        }
        finally {
            this.statements.setPrioritiseCleanup(false);
        }
    }

    private boolean prioritiseSnapshotCleaningIfLowOnMemory(boolean prioritiseCleaning) {
        long freeToAllocateMemory;
        if (!prioritiseCleaning && MAX_MEMORY >= 0x10000000L && MemorySailStore.memoryIsLow(freeToAllocateMemory = this.getFreeToAllocateMemory())) {
            logger.debug("Low free memory ({} MB)! Prioritising cleaning of removed statements from the MemoryStore.", (Object)(freeToAllocateMemory / 1024L / 1024L));
            prioritiseCleaning = true;
            this.statements.setPrioritiseCleanup(true);
        }
        return prioritiseCleaning;
    }

    private static boolean memoryIsLow(long freeToAllocateMemory) {
        return freeToAllocateMemory < 0x4000000L || ((double)freeToAllocateMemory + 0.0) / (double)MAX_MEMORY < 0.125;
    }

    private long getFreeToAllocateMemory() {
        long totalMemory = RUNTIME.totalMemory();
        long freeMemory = RUNTIME.freeMemory();
        long used = totalMemory - freeMemory;
        return MAX_MEMORY - used;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleSnapshotCleanup() {
        if (this.statements.size() < 1000) {
            return;
        }
        Thread toCheckSnapshotCleanupThread = this.snapshotCleanupThread;
        if (toCheckSnapshotCleanupThread == null || !toCheckSnapshotCleanupThread.isAlive()) {
            Object object = this.snapshotCleanupThreadLockObject;
            synchronized (object) {
                toCheckSnapshotCleanupThread = this.snapshotCleanupThread;
                if (toCheckSnapshotCleanupThread == null || !toCheckSnapshotCleanupThread.isAlive()) {
                    Runnable runnable = () -> {
                        try {
                            for (int i = 0; i < 500 && !MemorySailStore.memoryIsLow(this.getFreeToAllocateMemory() * 2L); ++i) {
                                Thread.sleep(10L);
                            }
                            this.cleanSnapshots();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            logger.info("snapshot cleanup interrupted");
                        }
                    };
                    toCheckSnapshotCleanupThread = this.snapshotCleanupThread = new Thread(runnable, "MemoryStore snapshot cleanup");
                    toCheckSnapshotCleanupThread.setDaemon(true);
                    toCheckSnapshotCleanupThread.start();
                    Thread.yield();
                }
            }
        }
    }

    private SailException convertToSailException(InterruptedException e) {
        Thread.currentThread().interrupt();
        return new SailException(e);
    }

    static class SnapshotMonitor {
        private static final ConcurrentCleaner cleaner = new ConcurrentCleaner();
        private final ConcurrentHashMap<Integer, LongAdder> activeSnapshots = new ConcurrentHashMap();
        private final boolean debug;
        private final AtomicInteger highestEverReservedSnapshot = new AtomicInteger(-1);

        public SnapshotMonitor(boolean debug) {
            this.debug = debug;
        }

        public int getFirstUnusedOrElse(int currentSnapshot) {
            int maximum = this.highestEverReservedSnapshot.getAcquire();
            int min = Integer.MAX_VALUE;
            for (Map.Entry<Integer, LongAdder> entry : this.activeSnapshots.entrySet()) {
                if (entry.getKey() > min) continue;
                if (entry.getKey() < maximum && entry.getValue().sum() == 0L) {
                    this.activeSnapshots.computeIfPresent(entry.getKey(), (k, v) -> {
                        if (v.sum() == 0L) {
                            return null;
                        }
                        return v;
                    });
                    continue;
                }
                min = entry.getKey() - 1;
            }
            if (min == Integer.MAX_VALUE) {
                return currentSnapshot - 1;
            }
            return min;
        }

        public ReservedSnapshot reserve(int snapshot, Object reservedBy) {
            int highestEverReservedSnapshot = this.highestEverReservedSnapshot.getAcquire();
            while (snapshot > highestEverReservedSnapshot) {
                if (this.highestEverReservedSnapshot.compareAndSet(highestEverReservedSnapshot, snapshot)) {
                    highestEverReservedSnapshot = snapshot;
                    continue;
                }
                highestEverReservedSnapshot = this.highestEverReservedSnapshot.getAcquire();
            }
            LongAdder longAdder = this.activeSnapshots.computeIfAbsent(snapshot, k -> new LongAdder());
            longAdder.increment();
            return new ReservedSnapshot(snapshot, reservedBy, this.debug, longAdder, this.activeSnapshots, this.highestEverReservedSnapshot);
        }

        static class ReservedSnapshot {
            private static final int SNAPSHOT_RELEASED = -1;
            private final ConcurrentHashMap<Integer, LongAdder> activeSnapshots;
            private final LongAdder frequency;
            private final AtomicInteger highestEverReservedSnapshot;
            private Cleaner.Cleanable cleanable;
            private final Throwable stackTraceForDebugging;
            private volatile int snapshot;
            private static final VarHandle SNAPSHOT;

            public ReservedSnapshot(int snapshot, Object reservedBy, boolean debug, LongAdder frequency, ConcurrentHashMap<Integer, LongAdder> activeSnapshots, AtomicInteger highestEverReservedSnapshot) {
                this.snapshot = snapshot;
                this.stackTraceForDebugging = debug ? new Throwable("Unreleased snapshot version") : null;
                this.activeSnapshots = activeSnapshots;
                this.frequency = frequency;
                this.highestEverReservedSnapshot = highestEverReservedSnapshot;
                this.cleanable = cleaner.register(reservedBy, () -> {
                    int tempSnapshot = SNAPSHOT.getVolatile(this);
                    if (tempSnapshot != -1) {
                        String message = "Releasing MemorySailStore snapshot {} which was reserved and never released (possibly unclosed MemorySailDataset or MemorySailSink).";
                        if (this.stackTraceForDebugging != null) {
                            logger.warn(message, (Object)tempSnapshot, (Object)this.stackTraceForDebugging);
                        } else {
                            logger.warn(message, (Object)tempSnapshot);
                        }
                        this.release();
                    }
                });
            }

            public void release() {
                Cleaner.Cleanable cleanable;
                int snapshot = SNAPSHOT.getAcquire(this);
                if (snapshot != -1 && SNAPSHOT.compareAndSet(this, snapshot, -1)) {
                    this.frequency.decrement();
                    assert (this.frequency.sum() >= 0L);
                    if (snapshot < this.highestEverReservedSnapshot.getAcquire() && this.frequency.sum() == 0L) {
                        this.activeSnapshots.computeIfPresent(snapshot, (k, v) -> {
                            if (v.sum() == 0L) {
                                return null;
                            }
                            return v;
                        });
                    }
                }
                if ((cleanable = this.cleanable) != null) {
                    this.cleanable = null;
                    cleanable.clean();
                }
            }

            static {
                try {
                    SNAPSHOT = MethodHandles.lookup().in(ReservedSnapshot.class).findVarHandle(ReservedSnapshot.class, "snapshot", Integer.TYPE);
                }
                catch (ReflectiveOperationException e) {
                    throw new Error(e);
                }
            }
        }
    }

    private final class MemorySailDataset
    implements SailDataset {
        private final boolean explicit;
        private final int snapshot;
        private final SnapshotMonitor.ReservedSnapshot reservedSnapshot;
        private volatile boolean closed;

        public MemorySailDataset(boolean explicit) throws SailException {
            this.explicit = explicit;
            this.snapshot = -1;
            this.reservedSnapshot = null;
        }

        public MemorySailDataset(boolean explicit, int snapshot) throws SailException {
            this.explicit = explicit;
            this.snapshot = snapshot;
            this.reservedSnapshot = MemorySailStore.this.snapshotMonitor.reserve(snapshot, this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.explicit) {
                sb.append("explicit ");
            } else {
                sb.append("inferred ");
            }
            if (this.snapshot >= 0) {
                sb.append("snapshot ").append(this.snapshot);
            } else {
                sb.append(super.toString());
            }
            return sb.toString();
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.reservedSnapshot != null) {
                this.reservedSnapshot.release();
            }
        }

        @Override
        public String getNamespace(String prefix) throws SailException {
            return MemorySailStore.this.namespaceStore.getNamespace(prefix);
        }

        @Override
        public CloseableIteration<? extends Namespace, SailException> getNamespaces() {
            return new CloseableIteratorIteration<SimpleNamespace, SailException>(MemorySailStore.this.namespaceStore.iterator());
        }

        @Override
        public CloseableIteration<? extends Resource, SailException> getContextIDs() throws SailException {
            MemResource memResource;
            ArrayList<MemResource> contextIDs = new ArrayList<MemResource>(32);
            int snapshot = this.getCurrentSnapshot();
            try (WeakObjectRegistry.AutoCloseableIterator<MemIRI> memIRIsIterator = MemorySailStore.this.valueFactory.getMemIRIsIterator();){
                while (memIRIsIterator.hasNext()) {
                    memResource = memIRIsIterator.next();
                    if (!this.isContextResource(memResource, snapshot)) continue;
                    contextIDs.add(memResource);
                }
            }
            catch (InterruptedException e) {
                throw MemorySailStore.this.convertToSailException(e);
            }
            try (WeakObjectRegistry.AutoCloseableIterator<MemBNode> memBNodesIterator = MemorySailStore.this.valueFactory.getMemBNodesIterator();){
                while (memBNodesIterator.hasNext()) {
                    memResource = memBNodesIterator.next();
                    if (!this.isContextResource(memResource, snapshot)) continue;
                    contextIDs.add(memResource);
                }
            }
            catch (InterruptedException e) {
                throw MemorySailStore.this.convertToSailException(e);
            }
            return new CloseableIteratorIteration(contextIDs.iterator());
        }

        public CloseableIteration<MemStatement, SailException> getStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
            try {
                return MemorySailStore.this.createStatementIterator(subj, pred, obj, this.explicit, this.getCurrentSnapshot(), contexts);
            }
            catch (InterruptedException e) {
                throw MemorySailStore.this.convertToSailException(e);
            }
        }

        public CloseableIteration<MemTriple, SailException> getTriples(Resource subj, IRI pred, Value obj) throws SailException {
            try {
                return MemorySailStore.this.createTripleIterator(subj, pred, obj, this.getCurrentSnapshot());
            }
            catch (InterruptedException e) {
                throw MemorySailStore.this.convertToSailException(e);
            }
        }

        private int getCurrentSnapshot() {
            if (this.snapshot >= 0) {
                return this.snapshot;
            }
            return MemorySailStore.this.currentSnapshot;
        }

        private boolean isContextResource(MemResource memResource, int snapshot) throws SailException, InterruptedException {
            MemStatementList contextStatements = memResource.getContextStatementList();
            if (contextStatements.size() == 0) {
                return false;
            }
            try (MemStatementIterator iter = new MemStatementIterator(contextStatements, null, null, null, null, snapshot, null, new MemResource[0]);){
                boolean bl = iter.hasNext();
                return bl;
            }
        }
    }

    private final class MemorySailSink
    implements SailSink {
        private volatile boolean closed = false;
        private final boolean explicit;
        private final int serializable;
        private final SnapshotMonitor.ReservedSnapshot reservedSnapshot;
        private int nextSnapshot;
        private Set<StatementPattern> observations;
        private volatile boolean txnLock;
        private boolean requireCleanup;

        public MemorySailSink(boolean explicit, boolean serializable) throws SailException {
            this.explicit = explicit;
            if (serializable) {
                this.serializable = MemorySailStore.this.currentSnapshot;
                this.reservedSnapshot = MemorySailStore.this.snapshotMonitor.reserve(this.serializable, this);
            } else {
                this.serializable = Integer.MAX_VALUE;
                this.reservedSnapshot = null;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.explicit) {
                sb.append("explicit ");
            } else {
                sb.append("inferred ");
            }
            if (this.txnLock) {
                sb.append("snapshot ").append(this.nextSnapshot);
            } else {
                sb.append(super.toString());
            }
            return sb.toString();
        }

        @Override
        public synchronized void prepare() throws SailException {
            this.acquireExclusiveTransactionLock();
            if (this.observations != null) {
                for (StatementPattern p : this.observations) {
                    Resource subj = (Resource)p.getSubjectVar().getValue();
                    IRI pred = (IRI)p.getPredicateVar().getValue();
                    Value obj = p.getObjectVar().getValue();
                    Var ctxVar = p.getContextVar();
                    Resource[] contexts = ctxVar == null ? new Resource[]{} : new Resource[]{(Resource)ctxVar.getValue()};
                    try {
                        CloseableIteration<MemStatement, SailException> iter = MemorySailStore.this.createStatementIterator(subj, pred, obj, null, -1, contexts);
                        try {
                            while (iter.hasNext()) {
                                MemStatement st = (MemStatement)iter.next();
                                int since = st.getSinceSnapshot();
                                int till = st.getTillSnapshot();
                                if ((this.serializable >= since || since >= this.nextSnapshot) && (this.serializable >= till || till >= this.nextSnapshot)) continue;
                                throw new SailConflictException("Observed State has Changed");
                            }
                        }
                        finally {
                            if (iter == null) continue;
                            iter.close();
                        }
                    }
                    catch (InterruptedException e) {
                        throw MemorySailStore.this.convertToSailException(e);
                    }
                }
            }
        }

        @Override
        public synchronized void flush() throws SailException {
            if (this.txnLock) {
                MemorySailStore.this.invalidateCache();
                MemorySailStore.this.currentSnapshot = Math.max(MemorySailStore.this.currentSnapshot, this.nextSnapshot);
                if (this.requireCleanup) {
                    MemorySailStore.this.scheduleSnapshotCleanup();
                }
            }
        }

        @Override
        public void close() {
            if (!this.closed) {
                this.closed = true;
                try {
                    if (this.reservedSnapshot != null) {
                        this.reservedSnapshot.release();
                    }
                }
                finally {
                    boolean toCloseTxnLock = this.txnLock;
                    this.txnLock = false;
                    if (toCloseTxnLock) {
                        MemorySailStore.this.txnLockManager.unlock();
                    }
                    this.observations = null;
                }
            }
        }

        @Override
        public synchronized void setNamespace(String prefix, String name) {
            this.acquireExclusiveTransactionLock();
            MemorySailStore.this.namespaceStore.setNamespace(prefix, name);
        }

        @Override
        public synchronized void removeNamespace(String prefix) {
            this.acquireExclusiveTransactionLock();
            MemorySailStore.this.namespaceStore.removeNamespace(prefix);
        }

        @Override
        public synchronized void clearNamespaces() {
            this.acquireExclusiveTransactionLock();
            MemorySailStore.this.namespaceStore.clear();
        }

        @Override
        public synchronized void observe(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
            if (this.observations == null) {
                this.observations = new HashSet<StatementPattern>();
            }
            if (contexts == null) {
                this.observations.add(new StatementPattern(new Var("s", subj), new Var("p", pred), new Var("o", obj), new Var("g", null)));
            } else if (contexts.length == 0) {
                this.observations.add(new StatementPattern(new Var("s", subj), new Var("p", pred), new Var("o", obj)));
            } else {
                for (Resource ctx : contexts) {
                    this.observations.add(new StatementPattern(new Var("s", subj), new Var("p", pred), new Var("o", obj), new Var("g", ctx)));
                }
            }
        }

        @Override
        public synchronized void clear(Resource ... contexts) {
            this.acquireExclusiveTransactionLock();
            MemorySailStore.this.invalidateCache();
            this.requireCleanup = true;
            try (CloseableIteration<MemStatement, SailException> iter = MemorySailStore.this.createStatementIterator(null, null, null, this.explicit, this.nextSnapshot, contexts);){
                while (iter.hasNext()) {
                    MemStatement st = (MemStatement)iter.next();
                    st.setTillSnapshot(this.nextSnapshot);
                }
            }
            catch (InterruptedException e) {
                throw MemorySailStore.this.convertToSailException(e);
            }
        }

        @Override
        public synchronized void approve(Resource subj, IRI pred, Value obj, Resource ctx) {
            this.acquireExclusiveTransactionLock();
            MemorySailStore.this.invalidateCache();
            try {
                this.addStatement(subj, pred, obj, ctx, this.explicit);
            }
            catch (InterruptedException e) {
                throw MemorySailStore.this.convertToSailException(e);
            }
        }

        @Override
        public synchronized void approveAll(Set<Statement> approved, Set<Resource> approvedContexts) {
            this.acquireExclusiveTransactionLock();
            MemorySailStore.this.invalidateCache();
            try {
                for (Statement statement : approved) {
                    this.addStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), statement.getContext(), this.explicit);
                }
            }
            catch (InterruptedException e) {
                throw MemorySailStore.this.convertToSailException(e);
            }
        }

        @Override
        public synchronized void deprecateAll(Set<Statement> deprecated) {
            this.acquireExclusiveTransactionLock();
            MemorySailStore.this.invalidateCache();
            this.requireCleanup = true;
            int nextSnapshot = this.nextSnapshot;
            for (Statement statement : deprecated) {
                this.innerDeprecate(statement, nextSnapshot);
            }
        }

        @Override
        public synchronized void deprecate(Statement statement) throws SailException {
            this.acquireExclusiveTransactionLock();
            MemorySailStore.this.invalidateCache();
            this.requireCleanup = true;
            this.innerDeprecate(statement, this.nextSnapshot);
        }

        private void innerDeprecate(Statement statement, int nextSnapshot) {
            if (statement instanceof MemStatement) {
                MemStatement toDeprecate = (MemStatement)statement;
                if ((nextSnapshot < 0 || toDeprecate.isInSnapshot(nextSnapshot)) && toDeprecate.isExplicit() == this.explicit) {
                    toDeprecate.setTillSnapshot(nextSnapshot);
                }
            } else if (statement instanceof LinkedHashModel.ModelStatement && ((LinkedHashModel.ModelStatement)statement).getStatement() instanceof MemStatement) {
                MemStatement toDeprecate = (MemStatement)((LinkedHashModel.ModelStatement)statement).getStatement();
                if ((nextSnapshot < 0 || toDeprecate.isInSnapshot(nextSnapshot)) && toDeprecate.isExplicit() == this.explicit) {
                    toDeprecate.setTillSnapshot(nextSnapshot);
                }
            } else {
                try (CloseableIteration<MemStatement, SailException> iter = MemorySailStore.this.createStatementIterator(statement.getSubject(), statement.getPredicate(), statement.getObject(), this.explicit, nextSnapshot, statement.getContext());){
                    while (iter.hasNext()) {
                        MemStatement st = (MemStatement)iter.next();
                        st.setTillSnapshot(nextSnapshot);
                    }
                }
                catch (InterruptedException e) {
                    throw MemorySailStore.this.convertToSailException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void acquireExclusiveTransactionLock() throws SailException {
            if (!this.txnLock) {
                MemorySailSink memorySailSink = this;
                synchronized (memorySailSink) {
                    if (!this.txnLock) {
                        MemorySailStore.this.txnLockManager.lock();
                        this.nextSnapshot = MemorySailStore.this.currentSnapshot + 1;
                        this.txnLock = true;
                    }
                }
            }
        }

        private MemStatement addStatement(Resource subj, IRI pred, Value obj, Resource context, boolean explicit) throws SailException, InterruptedException {
            MemResource memContext;
            if (!explicit) {
                MemorySailStore.this.mayHaveInferred = true;
            }
            MemResource memSubj = MemorySailStore.this.valueFactory.getOrCreateMemResource(subj);
            MemIRI memPred = MemorySailStore.this.valueFactory.getOrCreateMemURI(pred);
            MemValue memObj = MemorySailStore.this.valueFactory.getOrCreateMemValue(obj);
            MemResource memResource = memContext = context == null ? null : MemorySailStore.this.valueFactory.getOrCreateMemResource(context);
            if (memSubj.hasSubjectStatements() && memPred.hasPredicateStatements() && memObj.hasObjectStatements() && (memContext == null || memContext.hasContextStatements()) && this.statementAlreadyExists(explicit, memSubj, memPred, memObj, memContext, this.nextSnapshot)) {
                return null;
            }
            MemStatement st = new MemStatement(memSubj, memPred, memObj, memContext, explicit, this.nextSnapshot);
            MemorySailStore.this.statements.add(st);
            st.addToComponentLists();
            MemorySailStore.this.invalidateCache();
            return st;
        }

        private boolean statementAlreadyExists(boolean explicit, MemResource memSubj, MemIRI memPred, MemValue memObj, MemResource memContext, int nextSnapshot) throws InterruptedException {
            MemStatementList statementList = this.getSmallestMemStatementList(memSubj, memPred, memObj, memContext);
            MemStatement memStatement = statementList.getExact(memSubj, memPred, memObj, memContext, nextSnapshot);
            if (memStatement != null) {
                if (!memStatement.isExplicit() && explicit) {
                    memStatement.setTillSnapshot(this.nextSnapshot);
                } else {
                    return true;
                }
            }
            return false;
        }

        private MemStatementList getSmallestMemStatementList(MemResource memSubj, MemIRI memPred, MemValue memObj, MemResource memContext) {
            MemStatementList statementList = memSubj.getSubjectStatementList();
            if (statementList.size() <= 1) {
                return statementList;
            }
            if (memPred.getPredicateStatementCount() < statementList.size() && (statementList = memPred.getPredicateStatementList()).size() <= 1) {
                return statementList;
            }
            if (memObj.getObjectStatementCount() < statementList.size() && (statementList = memObj.getObjectStatementList()).size() <= 1) {
                return statementList;
            }
            if (memContext != null && memContext.getContextStatementCount() < statementList.size()) {
                statementList = memContext.getContextStatementList();
            }
            return statementList;
        }

        @Override
        public boolean deprecateByQuery(Resource subj, IRI pred, Value obj, Resource[] contexts) {
            this.acquireExclusiveTransactionLock();
            boolean deprecated = false;
            this.requireCleanup = true;
            MemorySailStore.this.invalidateCache();
            try (CloseableIteration<MemStatement, SailException> iter = MemorySailStore.this.createStatementIterator(subj, pred, obj, this.explicit, this.nextSnapshot, contexts);){
                while (iter.hasNext()) {
                    deprecated = true;
                    MemStatement st = (MemStatement)iter.next();
                    st.setTillSnapshot(this.nextSnapshot);
                }
            }
            catch (InterruptedException e) {
                throw MemorySailStore.this.convertToSailException(e);
            }
            MemorySailStore.this.invalidateCache();
            return deprecated;
        }
    }

    private final class MemorySailSource
    extends BackingSailSource {
        private final boolean explicit;

        public MemorySailSource(boolean explicit) {
            this.explicit = explicit;
        }

        @Override
        public SailSink sink(IsolationLevel level) throws SailException {
            return new MemorySailSink(this.explicit, level.isCompatibleWith(IsolationLevels.SERIALIZABLE));
        }

        @Override
        public MemorySailDataset dataset(IsolationLevel level) throws SailException {
            if (level.isCompatibleWith(IsolationLevels.SNAPSHOT_READ)) {
                return new MemorySailDataset(this.explicit, MemorySailStore.this.currentSnapshot);
            }
            return new MemorySailDataset(this.explicit);
        }
    }
}

