/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.optimizer;

import java.util.ArrayDeque;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InternalUseOnly
public class ParentReferenceChecker
implements QueryOptimizer {
    private static final Logger logger = LoggerFactory.getLogger(ParentReferenceChecker.class);
    private final QueryOptimizer previousOptimizerInPipeline;

    public ParentReferenceChecker(QueryOptimizer previousOptimizerInPipeline) {
        this.previousOptimizerInPipeline = previousOptimizerInPipeline;
    }

    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit((QueryModelVisitor)new ParentCheckingVisitor());
    }

    private class ParentCheckingVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        private final ArrayDeque<QueryModelNode> ancestors = new ArrayDeque();

        private ParentCheckingVisitor() {
        }

        protected void meetNode(QueryModelNode node) throws RuntimeException {
            QueryModelNode expectedParent = this.ancestors.peekLast();
            if (node.getParentNode() != expectedParent) {
                String previousOptimizer = ParentReferenceChecker.this.previousOptimizerInPipeline != null ? ParentReferenceChecker.this.previousOptimizerInPipeline.getClass().getSimpleName() : "query parsing";
                String message = "After " + previousOptimizer + " there was an unexpected parent for node " + node + ": " + node.getParentNode() + " (expected " + expectedParent + ")";
                assert (node.getParentNode() == expectedParent) : message;
            }
            this.ancestors.addLast(node);
            super.meetNode(node);
            this.ancestors.pollLast();
        }
    }
}

