/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql;

import java.io.IOException;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.GEO;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql.FunctionArguments;
import org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql.SpatialSupport;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Shape;

abstract class GeometricUnaryFunction
implements Function {
    GeometricUnaryFunction() {
    }

    public Value evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        String wkt;
        if (args.length != 1) {
            throw new ValueExprEvaluationException(this.getURI() + " requires exactly 1 argument, got " + args.length);
        }
        SpatialContext geoContext = SpatialSupport.getSpatialContext();
        Shape geom = FunctionArguments.getShape(this, args[0], geoContext);
        try {
            wkt = SpatialSupport.getWktWriter().toWkt(this.operation(geom));
        }
        catch (IOException | RuntimeException e) {
            throw new ValueExprEvaluationException((Throwable)e);
        }
        return valueFactory.createLiteral(wkt, GEO.WKT_LITERAL);
    }

    protected abstract Shape operation(Shape var1);
}

