/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query;

import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.common.exception.RDF4JException;
import org.eclipse.rdf4j.common.iteration.AbstractCloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.DistinctIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.common.iteration.LimitIteration;
import org.eclipse.rdf4j.common.iteration.OffsetIteration;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.ModelFactory;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.impl.DynamicModelFactory;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryResult;
import org.eclipse.rdf4j.query.QueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.impl.BackgroundGraphResult;
import org.eclipse.rdf4j.query.impl.IteratingGraphQueryResult;
import org.eclipse.rdf4j.query.impl.IteratingTupleQueryResult;
import org.eclipse.rdf4j.query.impl.QueueCursor;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;

public class QueryResults
extends Iterations {
    public static Model asModel(CloseableIteration<? extends Statement, ? extends RDF4JException> iteration) throws QueryEvaluationException {
        return QueryResults.asModel(iteration, (ModelFactory)new DynamicModelFactory());
    }

    public static Model asModel(CloseableIteration<? extends Statement, ? extends RDF4JException> iteration, ModelFactory modelFactory) throws QueryEvaluationException {
        Model model = modelFactory.createEmptyModel();
        QueryResults.addAll(iteration, (Collection)model);
        return model;
    }

    public static <T> List<T> asList(QueryResult<T> queryResult) throws QueryEvaluationException {
        ArrayList list = new ArrayList();
        return (List)QueryResults.addAll(queryResult, list);
    }

    public static <T> Set<T> asSet(QueryResult<T> queryResult) throws QueryEvaluationException {
        try (Stream stream = queryResult.stream();){
            Set set = stream.collect(Collectors.toSet());
            return set;
        }
    }

    public static List<Value> getAllValues(TupleQueryResult result, String var) throws QueryEvaluationException {
        try (Stream<BindingSet> stream = result.stream();){
            List<Value> list = result.getBindingNames().contains(var) ? stream.map(bs -> bs.getValue(var)).collect(Collectors.toList()) : Collections.emptyList();
            return list;
        }
    }

    public static Statement singleResult(GraphQueryResult result) throws QueryEvaluationException {
        try (Stream stream = result.stream();){
            Statement statement = stream.findFirst().orElse(null);
            return statement;
        }
    }

    public static BindingSet singleResult(TupleQueryResult result) throws QueryEvaluationException {
        try (Stream stream = result.stream();){
            BindingSet bindingSet = stream.findFirst().orElse(null);
            return bindingSet;
        }
    }

    public static GraphQueryResult distinctResults(GraphQueryResult queryResult) {
        return new GraphQueryResultFilter(queryResult);
    }

    public static TupleQueryResult distinctResults(TupleQueryResult queryResult) {
        return new TupleQueryResultFilter(queryResult);
    }

    public static TupleQueryResult limitResults(TupleQueryResult queryResult, long limit, long offset) {
        TupleQueryResult iter = queryResult;
        if (offset > 0L) {
            iter = new OffsetIteration((Iteration)iter, offset);
        }
        if (limit > 0L) {
            iter = new LimitIteration((Iteration)iter, limit);
        }
        if (!(iter instanceof TupleQueryResult)) {
            return new IteratingTupleQueryResult(queryResult.getBindingNames(), iter);
        }
        return iter;
    }

    public static GraphQueryResult limitResults(GraphQueryResult queryResult, long limit, long offset) {
        GraphQueryResult iter = queryResult;
        if (offset > 0L) {
            iter = new OffsetIteration((Iteration)iter, offset);
        }
        if (limit > 0L) {
            iter = new LimitIteration((Iteration)iter, limit);
        }
        if (!(iter instanceof GraphQueryResult)) {
            return new IteratingGraphQueryResult(queryResult.getNamespaces(), iter);
        }
        return iter;
    }

    public static GraphQueryResult parseGraphBackground(InputStream in, String baseURI, RDFFormat format, WeakReference<?> callerReference) throws UnsupportedRDFormatException {
        return QueryResults.parseGraphBackground(in, baseURI, Rio.createParser((RDFFormat)format), callerReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GraphQueryResult parseGraphBackground(InputStream in, String baseURI, RDFParser parser, WeakReference<?> callerReference) {
        RDFFormat format = parser.getRDFFormat();
        BackgroundGraphResult result = new BackgroundGraphResult(new QueueCursor<Statement>(new LinkedBlockingQueue(1), callerReference), parser, in, format.getCharset(), baseURI);
        boolean allGood = false;
        try {
            ForkJoinPool.commonPool().submit(result);
            allGood = true;
        }
        finally {
            if (!allGood) {
                result.close();
            }
        }
        return result;
    }

    public static void report(TupleQueryResult tqr, QueryResultHandler handler) throws TupleQueryResultHandlerException, QueryEvaluationException {
        try (TupleQueryResult tupleQueryResult = tqr;){
            handler.startQueryResult(tqr.getBindingNames());
            while (tqr.hasNext()) {
                BindingSet bindingSet = (BindingSet)tqr.next();
                handler.handleSolution(bindingSet);
            }
        }
        handler.endQueryResult();
    }

    public static void report(GraphQueryResult graphQueryResult, RDFHandler rdfHandler) throws RDFHandlerException, QueryEvaluationException {
        try (GraphQueryResult graphQueryResult2 = graphQueryResult;){
            rdfHandler.startRDF();
            for (Map.Entry<String, String> entry : graphQueryResult.getNamespaces().entrySet()) {
                String prefix = entry.getKey();
                String namespace = entry.getValue();
                rdfHandler.handleNamespace(prefix, namespace);
            }
            while (graphQueryResult.hasNext()) {
                Statement st = (Statement)graphQueryResult.next();
                rdfHandler.handleStatement(st);
            }
        }
        rdfHandler.endRDF();
    }

    public static boolean equals(TupleQueryResult tqr1, TupleQueryResult tqr2) throws QueryEvaluationException {
        List list1 = Iterations.asList((CloseableIteration)tqr1);
        List list2 = Iterations.asList((CloseableIteration)tqr2);
        if (list1.size() != list2.size()) {
            return false;
        }
        return QueryResults.matchBindingSets(list1, list2);
    }

    public static boolean isSubset(TupleQueryResult tqr1, TupleQueryResult tqr2) throws QueryEvaluationException {
        List list1 = Iterations.asList((CloseableIteration)tqr1);
        List list2 = Iterations.asList((CloseableIteration)tqr2);
        if (list1.size() > list2.size()) {
            return false;
        }
        return QueryResults.matchBindingSets(list1, list2);
    }

    public static boolean equals(GraphQueryResult result1, GraphQueryResult result2) throws QueryEvaluationException {
        Set graph1 = Iterations.asSet((CloseableIteration)result1);
        Set graph2 = Iterations.asSet((CloseableIteration)result2);
        return Models.isomorphic((Iterable)graph1, (Iterable)graph2);
    }

    private static boolean matchBindingSets(List<? extends BindingSet> queryResult1, Iterable<? extends BindingSet> queryResult2) {
        return QueryResults.matchBindingSets(queryResult1, queryResult2, new HashMap<BNode, BNode>(), 0);
    }

    private static boolean matchBindingSets(List<? extends BindingSet> queryResult1, Iterable<? extends BindingSet> queryResult2, Map<BNode, BNode> bNodeMapping, int idx) {
        if (idx < queryResult1.size()) {
            BindingSet bs1 = queryResult1.get(idx);
            List<BindingSet> matchingBindingSets = QueryResults.findMatchingBindingSets(bs1, queryResult2, bNodeMapping);
            for (BindingSet bs2 : matchingBindingSets) {
                HashMap<BNode, BNode> newBNodeMapping = new HashMap<BNode, BNode>(bNodeMapping);
                for (Binding binding : bs1) {
                    if (!(binding.getValue() instanceof BNode)) continue;
                    newBNodeMapping.put((BNode)binding.getValue(), (BNode)bs2.getValue(binding.getName()));
                }
                if (!QueryResults.matchBindingSets(queryResult1, queryResult2, newBNodeMapping, idx + 1)) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    private static List<BindingSet> findMatchingBindingSets(BindingSet st, Iterable<? extends BindingSet> model, Map<BNode, BNode> bNodeMapping) {
        ArrayList<BindingSet> result = new ArrayList<BindingSet>();
        for (BindingSet bindingSet : model) {
            if (!QueryResults.bindingSetsMatch(st, bindingSet, bNodeMapping)) continue;
            result.add(bindingSet);
        }
        return result;
    }

    private static boolean bindingSetsMatch(BindingSet bs1, BindingSet bs2, Map<BNode, BNode> bNodeMapping) {
        if (bs1.size() != bs2.size()) {
            return false;
        }
        for (Binding binding1 : bs1) {
            Value value1 = binding1.getValue();
            Value value2 = bs2.getValue(binding1.getName());
            if (value1 instanceof BNode && value2 instanceof BNode) {
                BNode mappedBNode = bNodeMapping.get(value1);
                if (!(mappedBNode != null ? !value2.equals(mappedBNode) : bNodeMapping.containsValue(value2))) continue;
                return false;
            }
            if (value1 instanceof Literal && value2 instanceof Literal) {
                Literal leftLit = (Literal)value1;
                Literal rightLit = (Literal)value2;
                IRI dt1 = leftLit.getDatatype();
                IRI dt2 = rightLit.getDatatype();
                if (dt1 != null && dt1.equals((Object)dt2) && XMLDatatypeUtil.isValidValue((String)leftLit.getLabel(), (IRI)dt1) && XMLDatatypeUtil.isValidValue((String)rightLit.getLabel(), (IRI)dt2)) {
                    Integer compareResult = null;
                    if (dt1.equals((Object)XSD.DOUBLE)) {
                        compareResult = Double.compare(leftLit.doubleValue(), rightLit.doubleValue());
                    } else if (dt1.equals((Object)XSD.FLOAT)) {
                        compareResult = Float.compare(leftLit.floatValue(), rightLit.floatValue());
                    } else if (dt1.equals((Object)XSD.DECIMAL)) {
                        compareResult = leftLit.decimalValue().compareTo(rightLit.decimalValue());
                    } else if (XMLDatatypeUtil.isIntegerDatatype((IRI)dt1)) {
                        compareResult = leftLit.integerValue().compareTo(rightLit.integerValue());
                    } else if (dt1.equals((Object)XSD.BOOLEAN)) {
                        Boolean leftBool = leftLit.booleanValue();
                        Boolean rightBool = rightLit.booleanValue();
                        compareResult = leftBool.compareTo(rightBool);
                    } else if (XMLDatatypeUtil.isCalendarDatatype((IRI)dt1)) {
                        XMLGregorianCalendar left = leftLit.calendarValue();
                        XMLGregorianCalendar right = rightLit.calendarValue();
                        compareResult = left.compare(right);
                    }
                    if (!(compareResult != null ? compareResult != 0 : !value1.equals(value2))) continue;
                    return false;
                }
                if (value1.equals(value2)) continue;
                return false;
            }
            if (value1.equals(value2)) continue;
            return false;
        }
        return true;
    }

    public static boolean bindingSetsCompatible(BindingSet bs1, BindingSet bs2) {
        Set<String> bs1BindingNames = bs1.getBindingNames();
        if (bs1BindingNames.isEmpty()) {
            return true;
        }
        Set<String> bs2BindingNames = bs2.getBindingNames();
        for (String bindingName : bs1BindingNames) {
            Value value2;
            Value value1;
            if (!bs2BindingNames.contains(bindingName) || (value1 = bs1.getValue(bindingName)) == null || (value2 = bs2.getValue(bindingName)) == null || value1.equals(value2)) continue;
            return false;
        }
        return true;
    }

    private static class TupleQueryResultFilter
    extends AbstractCloseableIteration<BindingSet, QueryEvaluationException>
    implements TupleQueryResult {
        private final DistinctIteration<BindingSet, QueryEvaluationException> filter;
        private final TupleQueryResult unfiltered;

        public TupleQueryResultFilter(TupleQueryResult wrappedResult) {
            this.filter = new DistinctIteration((Iteration)wrappedResult);
            this.unfiltered = wrappedResult;
        }

        @Override
        public boolean hasNext() throws QueryEvaluationException {
            if (this.isClosed()) {
                return false;
            }
            boolean result = this.filter.hasNext();
            if (!result) {
                this.close();
            }
            return result;
        }

        @Override
        public BindingSet next() throws QueryEvaluationException {
            if (this.isClosed()) {
                throw new NoSuchElementException("The iteration has been closed.");
            }
            try {
                return (BindingSet)this.filter.next();
            }
            catch (NoSuchElementException e) {
                this.close();
                throw e;
            }
        }

        public void remove() throws QueryEvaluationException {
            if (this.isClosed()) {
                throw new IllegalStateException("The iteration has been closed.");
            }
            try {
                this.filter.remove();
            }
            catch (IllegalStateException e) {
                this.close();
                throw e;
            }
        }

        public void handleClose() throws QueryEvaluationException {
            try {
                super.handleClose();
            }
            finally {
                this.filter.close();
            }
        }

        @Override
        public List<String> getBindingNames() throws QueryEvaluationException {
            return this.unfiltered.getBindingNames();
        }
    }

    private static class GraphQueryResultFilter
    extends AbstractCloseableIteration<Statement, QueryEvaluationException>
    implements GraphQueryResult {
        private final DistinctIteration<Statement, QueryEvaluationException> filter;
        private final GraphQueryResult unfiltered;

        public GraphQueryResultFilter(GraphQueryResult wrappedResult) {
            this.filter = new DistinctIteration((Iteration)wrappedResult);
            this.unfiltered = wrappedResult;
        }

        @Override
        public boolean hasNext() throws QueryEvaluationException {
            if (this.isClosed()) {
                return false;
            }
            boolean result = this.filter.hasNext();
            if (!result) {
                this.close();
            }
            return result;
        }

        @Override
        public Statement next() throws QueryEvaluationException {
            if (this.isClosed()) {
                throw new NoSuchElementException("The iteration has been closed.");
            }
            try {
                return (Statement)this.filter.next();
            }
            catch (NoSuchElementException e) {
                this.close();
                throw e;
            }
        }

        public void remove() throws QueryEvaluationException {
            if (this.isClosed()) {
                throw new IllegalStateException("The iteration has been closed.");
            }
            try {
                this.filter.remove();
            }
            catch (IllegalStateException e) {
                this.close();
                throw e;
            }
        }

        public void handleClose() throws QueryEvaluationException {
            try {
                super.handleClose();
            }
            finally {
                this.filter.close();
            }
        }

        @Override
        public Map<String, String> getNamespaces() throws QueryEvaluationException {
            return this.unfiltered.getNamespaces();
        }
    }
}

