/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql;

import java.io.IOException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.GEO;
import org.eclipse.rdf4j.model.vocabulary.GEOF;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql.FunctionArguments;
import org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql.SpatialSupport;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Shape;

public class Buffer
implements Function {
    public String getURI() {
        return GEOF.BUFFER.stringValue();
    }

    public Value evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        String wkt;
        if (args.length != 3) {
            throw new ValueExprEvaluationException(this.getURI() + " requires exactly 3 arguments, got " + args.length);
        }
        SpatialContext geoContext = SpatialSupport.getSpatialContext();
        Shape geom = FunctionArguments.getShape(this, args[0], geoContext);
        double radiusUom = FunctionArguments.getDouble(this, args[1]);
        IRI units = FunctionArguments.getUnits(this, args[2]);
        double radiusDegs = FunctionArguments.convertToDegrees(radiusUom, units);
        Shape buffered = SpatialSupport.getSpatialAlgebra().buffer(geom, radiusDegs);
        try {
            wkt = SpatialSupport.getWktWriter().toWkt(buffered);
        }
        catch (IOException ioe) {
            throw new ValueExprEvaluationException((Throwable)ioe);
        }
        return valueFactory.createLiteral(wkt, GEO.WKT_LITERAL);
    }
}

