/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.webapp.system.proxy;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.common.app.net.ProxySettings;
import org.eclipse.rdf4j.common.webapp.util.HttpServerUtil;

public class ProxySettingsController {
    private ProxySettings PROXY_SETTINGS = null;

    private void setProxies(Map<String, Object> params, HttpServletResponse response) throws IOException {
        boolean useProxies = HttpServerUtil.isTrue(HttpServerUtil.getPostDataParameter(params, "connection"));
        if (!useProxies) {
            this.PROXY_SETTINGS.setProxiesEnabled(false);
        } else {
            String proxyExceptions;
            String httpProxyHost = HttpServerUtil.getPostDataParameter(params, "httpProxyHost");
            String httpProxyPort = HttpServerUtil.getPostDataParameter(params, "httpProxyPort");
            if (!HttpServerUtil.isEmpty(httpProxyHost)) {
                this.PROXY_SETTINGS.setHttpProxyHost(httpProxyHost);
                if (this.checkPort(httpProxyPort)) {
                    this.PROXY_SETTINGS.setHttpProxyPort(httpProxyPort);
                }
            }
            String httpsProxyHost = HttpServerUtil.getPostDataParameter(params, "httpsProxyHost");
            String httpsProxyPort = HttpServerUtil.getPostDataParameter(params, "httpsProxyPort");
            if (!HttpServerUtil.isEmpty(httpsProxyHost)) {
                this.PROXY_SETTINGS.setHttpsProxyHost(httpsProxyHost);
                if (this.checkPort(httpsProxyPort)) {
                    this.PROXY_SETTINGS.setHttpsProxyPort(httpsProxyPort);
                }
            }
            String ftpProxyHost = HttpServerUtil.getPostDataParameter(params, "ftpProxyHost");
            String ftpProxyPort = HttpServerUtil.getPostDataParameter(params, "ftpProxyPort");
            if (!HttpServerUtil.isEmpty(ftpProxyHost)) {
                this.PROXY_SETTINGS.setFtpProxyHost(ftpProxyHost);
                if (this.checkPort(ftpProxyPort)) {
                    this.PROXY_SETTINGS.setFtpProxyPort(ftpProxyPort);
                }
            }
            String socksProxyHost = HttpServerUtil.getPostDataParameter(params, "socksProxyHost");
            String socksProxyPort = HttpServerUtil.getPostDataParameter(params, "socksProxyPort");
            if (!HttpServerUtil.isEmpty(socksProxyHost)) {
                this.PROXY_SETTINGS.setSocksProxyHost(socksProxyHost);
                if (this.checkPort(socksProxyPort)) {
                    this.PROXY_SETTINGS.setHttpProxyPort(socksProxyPort);
                }
            }
            if (!HttpServerUtil.isEmpty(proxyExceptions = HttpServerUtil.getPostDataParameter(params, "proxyExceptions"))) {
                this.PROXY_SETTINGS.setNonProxyHostsStarting(proxyExceptions);
            }
            this.PROXY_SETTINGS.setProxiesEnabled(true);
        }
        this.PROXY_SETTINGS.save();
    }

    private boolean checkPort(String proxyPort) throws IOException {
        boolean result = false;
        int port = -1;
        if (!HttpServerUtil.isEmpty(proxyPort)) {
            try {
                port = Integer.parseInt(proxyPort);
                if (port > 0 || port < 65536) {
                    result = true;
                }
            }
            catch (NumberFormatException nfe) {
                result = false;
            }
        }
        return result;
    }
}

