/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Objects;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.NodeKindConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public class NodeKindFilter
extends FilterPlanNode {
    private final NodeKindConstraintComponent.NodeKind nodeKind;

    public NodeKindFilter(PlanNode parent, NodeKindConstraintComponent.NodeKind nodeKind) {
        super(parent);
        this.nodeKind = nodeKind;
    }

    @Override
    boolean checkTuple(ValidationTuple t) {
        Value value = t.getValue();
        switch (this.nodeKind) {
            case IRI: {
                return value.isIRI();
            }
            case Literal: {
                return value.isLiteral();
            }
            case BlankNode: {
                return value.isBNode();
            }
            case IRIOrLiteral: {
                return value.isIRI() || value.isLiteral();
            }
            case BlankNodeOrIRI: {
                return value.isBNode() || value.isIRI();
            }
            case BlankNodeOrLiteral: {
                return value.isBNode() || value.isLiteral();
            }
        }
        throw new IllegalStateException("Unknown nodeKind");
    }

    @Override
    public String toString() {
        return "NodeKindFilter{nodeKind=" + this.nodeKind + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeKindFilter that = (NodeKindFilter)o;
        return this.nodeKind == that.nodeKind;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.nodeKind});
    }
}

