/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;

public class JoinIterator
extends LookAheadIteration<BindingSet, QueryEvaluationException> {
    private final CloseableIteration<BindingSet, QueryEvaluationException> leftIter;
    private CloseableIteration<BindingSet, QueryEvaluationException> rightIter;
    private final QueryEvaluationStep preparedRight;

    public JoinIterator(EvaluationStrategy strategy, QueryEvaluationStep leftPrepared, QueryEvaluationStep rightPrepared, Join join, BindingSet bindings) throws QueryEvaluationException {
        this.leftIter = leftPrepared.evaluate(bindings);
        this.rightIter = new EmptyIteration();
        this.preparedRight = rightPrepared;
    }

    public JoinIterator(EvaluationStrategy strategy, Join join, BindingSet bindings, QueryEvaluationContext context) throws QueryEvaluationException {
        this.leftIter = strategy.evaluate(join.getLeftArg(), bindings);
        this.rightIter = new EmptyIteration();
        this.preparedRight = strategy.precompile(join.getRightArg(), context);
        join.setAlgorithm((Iteration)this);
    }

    protected BindingSet getNextElement() throws QueryEvaluationException {
        try {
            while (this.rightIter.hasNext() || this.leftIter.hasNext()) {
                if (this.rightIter.hasNext()) {
                    return (BindingSet)this.rightIter.next();
                }
                this.rightIter.close();
                if (!this.leftIter.hasNext()) continue;
                this.rightIter = this.preparedRight.evaluate((BindingSet)this.leftIter.next());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return null;
    }

    protected void handleClose() throws QueryEvaluationException {
        try {
            super.handleClose();
        }
        finally {
            try {
                this.leftIter.close();
            }
            finally {
                this.rightIter.close();
            }
        }
    }
}

