/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.xsd;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtility;

public abstract class CastFunction
implements Function {
    @Override
    public final String getURI() {
        return this.getXsdDatatype().toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException(this.getXsdName() + " cast requires exactly 1 argument, got " + args.length);
        }
        if (args[0] instanceof Literal) {
            Literal literal = (Literal)args[0];
            IRI datatype = literal.getDatatype();
            if (QueryEvaluationUtility.isStringLiteral(literal)) {
                String lexicalValue = XMLDatatypeUtil.collapseWhiteSpace((String)literal.getLabel());
                if (this.isValidForDatatype(lexicalValue)) {
                    return valueFactory.createLiteral(lexicalValue, this.getXsdDatatype());
                }
            } else if (datatype != null && datatype.equals((Object)this.getXsdDatatype())) {
                return literal;
            }
            return this.convert(valueFactory, (Value)literal);
        }
        return this.convert(valueFactory, args[0]);
    }

    protected abstract Literal convert(ValueFactory var1, Value var2) throws ValueExprEvaluationException;

    protected abstract IRI getXsdDatatype();

    protected String getXsdName() {
        return "xsd:" + this.getXsdDatatype().getLocalName();
    }

    protected abstract boolean isValidForDatatype(String var1);

    protected final ValueExprEvaluationException typeError(Value arg, Throwable cause) {
        return new ValueExprEvaluationException("Invalid argument for " + this.getXsdName() + " cast: " + arg, cause);
    }
}

