/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl;

import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class BindingAssigner
implements QueryOptimizer {
    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        if (bindings.size() > 0) {
            tupleExpr.visit(new VarVisitor(bindings));
        }
    }

    protected static class VarVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        protected BindingSet bindings;

        public VarVisitor(BindingSet bindings) {
            this.bindings = bindings;
        }

        @Override
        public void meet(Var var) {
            if (!var.hasValue() && this.bindings.hasBinding(var.getName())) {
                Value value = this.bindings.getValue(var.getName());
                var.setValue(value);
            }
        }
    }
}

