/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.AbstractModel;
import org.eclipse.rdf4j.model.impl.FilteredModel;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.SailStore;
import org.eclipse.rdf4j.sail.nativerdf.SailSourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class MemoryOverflowModel
extends AbstractModel {
    private static final long serialVersionUID = 4119844228099208169L;
    private static final Runtime RUNTIME = Runtime.getRuntime();
    private static final int LARGE_BLOCK = 10000;
    private static final int MIN_AVAILABLE_MEM_BEFORE_OVERFLOWING = 0x2000000;
    final Logger logger = LoggerFactory.getLogger(MemoryOverflowModel.class);
    private LinkedHashModel memory;
    transient File dataDir;
    transient SailStore store;
    transient SailSourceModel disk;
    private long baseline = 0L;
    private long maxBlockSize = 0L;
    SimpleValueFactory vf = SimpleValueFactory.getInstance();

    public MemoryOverflowModel() {
        this.memory = new LinkedHashModel(10000);
    }

    public MemoryOverflowModel(Model model) {
        this(model.getNamespaces());
        this.addAll((Collection)model);
    }

    public MemoryOverflowModel(Set<Namespace> namespaces, Collection<? extends Statement> c) {
        this(namespaces);
        this.addAll(c);
    }

    public MemoryOverflowModel(Set<Namespace> namespaces) {
        this.memory = new LinkedHashModel(namespaces, 10000);
    }

    public synchronized void closeIterator(Iterator<?> iter) {
        super.closeIterator(iter);
        if (this.disk != null) {
            this.disk.closeIterator(iter);
        }
    }

    public synchronized Set<Namespace> getNamespaces() {
        return this.memory.getNamespaces();
    }

    public synchronized Optional<Namespace> getNamespace(String prefix) {
        return this.memory.getNamespace(prefix);
    }

    public synchronized Namespace setNamespace(String prefix, String name) {
        return this.memory.setNamespace(prefix, name);
    }

    public void setNamespace(Namespace namespace) {
        this.memory.setNamespace(namespace);
    }

    public synchronized Optional<Namespace> removeNamespace(String prefix) {
        return this.memory.removeNamespace(prefix);
    }

    public boolean contains(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        return this.getDelegate().contains(subj, pred, obj, contexts);
    }

    public boolean add(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        this.checkMemoryOverflow();
        return this.getDelegate().add(subj, pred, obj, contexts);
    }

    public boolean add(Statement st) {
        this.checkMemoryOverflow();
        return this.getDelegate().add((Object)st);
    }

    public boolean remove(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        return this.getDelegate().remove(subj, pred, obj, contexts);
    }

    public int size() {
        return this.getDelegate().size();
    }

    public Iterator<Statement> iterator() {
        return this.getDelegate().iterator();
    }

    public boolean clear(Resource ... contexts) {
        return this.getDelegate().clear(contexts);
    }

    public Model filter(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        return new FilteredModel(this, subj, pred, obj, contexts){
            private static final long serialVersionUID = -475666402618133101L;

            public int size() {
                return MemoryOverflowModel.this.getDelegate().filter(this.subj, this.pred, this.obj, this.contexts).size();
            }

            public Iterator<Statement> iterator() {
                return MemoryOverflowModel.this.getDelegate().filter(this.subj, this.pred, this.obj, this.contexts).iterator();
            }

            protected void removeFilteredTermIteration(Iterator<Statement> iter, Resource subj, IRI pred, Value obj, Resource ... contexts) {
                MemoryOverflowModel.this.removeTermIteration(iter, subj, pred, obj, contexts);
            }
        };
    }

    public synchronized void removeTermIteration(Iterator<Statement> iter, Resource subj, IRI pred, Value obj, Resource ... contexts) {
        if (this.disk == null) {
            this.memory.removeTermIteration(iter, subj, pred, obj, contexts);
        } else {
            this.disk.removeTermIteration(iter, subj, pred, obj, contexts);
        }
    }

    protected abstract SailStore createSailStore(File var1) throws IOException, SailException;

    synchronized Model getDelegate() {
        if (this.disk == null) {
            return this.memory;
        }
        return this.disk;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Model delegate = this.getDelegate();
        s.writeInt(delegate.size());
        for (Statement st : delegate) {
            Resource subj = st.getSubject();
            IRI pred = st.getPredicate();
            Value obj = st.getObject();
            Resource ctx = st.getContext();
            s.writeObject(this.vf.createStatement(subj, pred, obj, ctx));
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            this.add((Statement)s.readObject());
        }
    }

    private synchronized void checkMemoryOverflow() {
        int size;
        if (this.disk == null && (size = this.size()) >= 10000 && size % 10000 == 0) {
            long maxMemory = RUNTIME.maxMemory();
            long totalMemory = RUNTIME.totalMemory();
            long freeMemory = RUNTIME.freeMemory();
            long used = totalMemory - freeMemory;
            long freeToAllocateMemory = maxMemory - used;
            if (this.baseline > 0L) {
                long blockSize = used - this.baseline;
                if (blockSize > this.maxBlockSize) {
                    this.maxBlockSize = blockSize;
                }
                if (freeToAllocateMemory < 0x2000000L || (double)freeToAllocateMemory < Math.min(0.15 * (double)maxMemory, (double)this.maxBlockSize)) {
                    this.logger.debug("syncing at {} triples. max block size: {}", (Object)size, (Object)this.maxBlockSize);
                    this.overflowToDisk();
                }
            }
            this.baseline = used;
        }
    }

    private synchronized void overflowToDisk() {
        try {
            assert (this.disk == null);
            this.dataDir = Files.createTempDirectory("model", new FileAttribute[0]).toFile();
            this.logger.debug("memory overflow using temp directory {}", (Object)this.dataDir);
            this.store = this.createSailStore(this.dataDir);
            this.disk = new SailSourceModel(this.store);
            this.disk.addAll((Collection)this.memory);
            this.memory = new LinkedHashModel(this.memory.getNamespaces(), 10000);
            this.logger.debug("overflow synced to disk");
        }
        catch (IOException | SailException e) {
            String path = this.dataDir != null ? this.dataDir.getAbsolutePath() : "(unknown)";
            this.logger.error("Error while writing to overflow directory " + path, e);
        }
    }
}

