/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.targets;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ExternalPredicateObjectFilter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnorderedSelect;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.targets.Target;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;

public class TargetClass
extends Target {
    private final Set<Resource> targetClass;

    public TargetClass(Set<Resource> targetClass) {
        this.targetClass = targetClass;
        assert (!this.targetClass.isEmpty());
    }

    @Override
    public IRI getPredicate() {
        return SHACL.TARGET_CLASS;
    }

    @Override
    public PlanNode getAdded(ConnectionsGroup connectionsGroup, Resource[] dataGraph, ConstraintComponent.Scope scope) {
        return this.getAddedRemovedInner(connectionsGroup.getAddedStatements(), dataGraph, scope);
    }

    private PlanNode getAddedRemovedInner(SailConnection connection, Resource[] dataGraph, ConstraintComponent.Scope scope) {
        PlanNode planNode;
        if (this.targetClass.size() == 1) {
            Resource clazz = (Resource)this.targetClass.stream().findAny().get();
            planNode = new UnorderedSelect(connection, null, RDF.TYPE, (Value)clazz, dataGraph, UnorderedSelect.Mapper.SubjectScopedMapper.getFunction(scope));
        } else {
            planNode = new Select(connection, this.getQueryFragment("?a", "?c", null, new StatementMatcher.StableRandomVariableProvider()), "?a", b -> new ValidationTuple(b.getValue("a"), scope, false, dataGraph), dataGraph);
        }
        return Unique.getInstance(planNode, false);
    }

    @Override
    public String getQueryFragment(String subjectVariable, String objectVariable, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        Set<Object> targets = this.targetClass;
        if (rdfsSubClassOfReasoner != null) {
            targets = targets.stream().flatMap(target -> rdfsSubClassOfReasoner.backwardsChain((Resource)target).stream()).collect(Collectors.toSet());
        }
        assert (targets.size() >= 1);
        return targets.stream().map(r -> "<" + r + ">").sorted().map(r -> String.join((CharSequence)"\n", "", "{", "\tBIND(rdf:type as " + stableRandomVariableProvider.next().asSparqlVariable() + ")", "\tBIND(" + r + " as " + objectVariable + ")", "\t" + subjectVariable + " " + stableRandomVariableProvider.current().asSparqlVariable() + objectVariable + ".", "}")).reduce((l, r) -> l + " UNION " + r).get();
    }

    @Override
    public PlanNode getTargetFilter(ConnectionsGroup connectionsGroup, Resource[] dataGraph, PlanNode parent) {
        return new ExternalPredicateObjectFilter(connectionsGroup.getBaseConnection(), dataGraph, RDF.TYPE, this.targetClass, parent, true, ExternalPredicateObjectFilter.FilterOn.activeTarget);
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        this.targetClass.forEach(t -> model.add(subject, this.getPredicate(), (Value)t, new Resource[0]));
    }

    @Override
    public Stream<StatementMatcher> getStatementMatcher(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner) {
        assert (subject == null);
        Stream<Object> stream = this.targetClass.stream();
        if (rdfsSubClassOfReasoner != null) {
            stream = stream.map(rdfsSubClassOfReasoner::backwardsChain).flatMap(Collection::stream).distinct();
        }
        return stream.map(t -> new StatementMatcher(object, new StatementMatcher.Variable((Value)RDF.TYPE), new StatementMatcher.Variable((Value)t)));
    }

    @Override
    public String getTargetQueryFragment(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        assert (subject == null);
        Collection<Object> targetClass = rdfsSubClassOfReasoner != null ? (Collection)this.targetClass.stream().map(rdfsSubClassOfReasoner::backwardsChain).flatMap(Collection::stream).distinct().collect(Collectors.toList()) : this.targetClass;
        if (targetClass.size() == 1) {
            return targetClass.stream().findFirst().map(r -> object.asSparqlVariable() + " a <" + r + "> .").orElseThrow(IllegalStateException::new);
        }
        String in = targetClass.stream().map(r -> "<" + r + ">").sorted().reduce((a, b) -> a + " , " + b).orElse("");
        String randomSparqlVariable = stableRandomVariableProvider.next().asSparqlVariable();
        return object.asSparqlVariable() + " a " + randomSparqlVariable + ".\nFILTER(" + randomSparqlVariable + " in ( " + in + " )) \n";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetClass that = (TargetClass)o;
        return this.targetClass.equals(that.targetClass);
    }

    public int hashCode() {
        return Objects.hash(this.targetClass);
    }
}

