/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra;

import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.ValueExpr;

public class If
extends AbstractQueryModelNode
implements ValueExpr {
    private ValueExpr condition;
    private ValueExpr result;
    private ValueExpr alternative;

    public If() {
    }

    public If(ValueExpr condition) {
        this.setCondition(condition);
    }

    public If(ValueExpr condition, ValueExpr result) {
        this.setCondition(condition);
        this.setResult(result);
    }

    public If(ValueExpr condition, ValueExpr result, ValueExpr alternative) {
        this.setCondition(condition);
        this.setResult(result);
        this.setAlternative(alternative);
    }

    public ValueExpr getCondition() {
        return this.condition;
    }

    public void setCondition(ValueExpr condition) {
        assert (condition != null) : "arg must not be null";
        condition.setParentNode(this);
        this.condition = condition;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        this.condition.visit(visitor);
        if (this.result != null) {
            this.result.visit(visitor);
        }
        if (this.alternative != null) {
            this.alternative.visit(visitor);
        }
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        if (this.condition == current) {
            this.setCondition((ValueExpr)replacement);
        } else if (this.result == current) {
            this.setResult((ValueExpr)replacement);
        } else if (this.alternative == current) {
            this.setAlternative((ValueExpr)replacement);
        } else {
            super.replaceChildNode(current, replacement);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof If) {
            If o = (If)other;
            boolean equal = this.condition.equals(o.getCondition());
            if (!equal) {
                return equal;
            }
            boolean bl = this.result == null ? o.getResult() == null : (equal = this.result.equals(o.getResult()));
            if (!equal) {
                return equal;
            }
            equal = this.alternative == null ? o.getAlternative() == null : this.alternative.equals(o.getAlternative());
            return equal;
        }
        return false;
    }

    public int hashCode() {
        int hashCode = this.condition.hashCode();
        if (this.result != null) {
            hashCode ^= this.result.hashCode();
        }
        if (this.alternative != null) {
            hashCode ^= this.alternative.hashCode();
        }
        return hashCode ^= "If".hashCode();
    }

    @Override
    public If clone() {
        If clone = (If)super.clone();
        clone.setCondition(this.condition.clone());
        if (this.result != null) {
            clone.setResult(this.result.clone());
        }
        if (this.alternative != null) {
            clone.setAlternative(this.alternative.clone());
        }
        return clone;
    }

    public void setResult(ValueExpr result) {
        result.setParentNode(this);
        this.result = result;
    }

    public ValueExpr getResult() {
        return this.result;
    }

    public void setAlternative(ValueExpr alternative) {
        alternative.setParentNode(this);
        this.alternative = alternative;
    }

    public ValueExpr getAlternative() {
        return this.alternative;
    }
}

