/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.event.util;

import java.io.PrintStream;
import java.util.Arrays;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.event.RepositoryConnectionListener;

public class DebugRepositoryConnectionListener
implements RepositoryConnectionListener {
    private boolean printing;
    private PrintStream stream;
    private boolean dumpingStack;

    public DebugRepositoryConnectionListener() {
        this(System.err);
    }

    public DebugRepositoryConnectionListener(PrintStream stream) {
        this.stream = stream;
        this.printing = stream != null;
        this.dumpingStack = false;
    }

    public boolean isPrinting() {
        return this.printing;
    }

    public void setPrinting(boolean printing) {
        this.printing = printing;
    }

    public PrintStream getStream() {
        return this.stream;
    }

    public void setStream(PrintStream stream) {
        this.stream = stream;
    }

    public boolean isDumpingStack() {
        return this.dumpingStack;
    }

    public void setDumpingStack(boolean dumpingStack) {
        this.dumpingStack = dumpingStack;
    }

    @Override
    public void close(RepositoryConnection conn) {
        if (this.printing) {
            this.stream.println("CLOSE (" + this.getConnectionID(conn) + ")");
        }
        if (this.dumpingStack) {
            Thread.dumpStack();
        }
    }

    @Override
    @Deprecated
    public void setAutoCommit(RepositoryConnection conn, boolean autoCommit) {
        if (this.printing) {
            this.stream.println("SETAUTOCOMMIT (" + this.getConnectionID(conn) + ") " + autoCommit);
        }
        if (this.dumpingStack) {
            Thread.dumpStack();
        }
    }

    @Override
    public void commit(RepositoryConnection conn) {
        if (this.printing) {
            this.stream.println("COMMIT (" + this.getConnectionID(conn) + ")");
        }
        if (this.dumpingStack) {
            Thread.dumpStack();
        }
    }

    @Override
    public void rollback(RepositoryConnection conn) {
        if (this.printing) {
            this.stream.println("ROLLBACK (" + this.getConnectionID(conn) + ")");
        }
        if (this.dumpingStack) {
            Thread.dumpStack();
        }
    }

    @Override
    public void add(RepositoryConnection conn, Resource subject, IRI predicate, Value object, Resource ... contexts) {
        if (this.printing) {
            this.stream.println("ADD (" + this.getConnectionID(conn) + ") " + subject + ", " + predicate + ", " + object + ", " + Arrays.toString(contexts));
        }
        if (this.dumpingStack) {
            Thread.dumpStack();
        }
    }

    @Override
    public void remove(RepositoryConnection conn, Resource subject, IRI predicate, Value object, Resource ... contexts) {
        if (this.printing) {
            this.stream.println("REMOVE (" + this.getConnectionID(conn) + ") " + subject + ", " + predicate + ", " + object + ", " + Arrays.toString(contexts));
        }
        if (this.dumpingStack) {
            Thread.dumpStack();
        }
    }

    @Override
    public void clear(RepositoryConnection conn, Resource ... contexts) {
        if (this.printing) {
            this.stream.println("CLEAR (" + this.getConnectionID(conn) + ") " + Arrays.toString(contexts));
        }
        if (this.dumpingStack) {
            Thread.dumpStack();
        }
    }

    @Override
    public void setNamespace(RepositoryConnection conn, String prefix, String name) {
        if (this.printing) {
            this.stream.println("SETNAMESPACE  (" + this.getConnectionID(conn) + ") " + prefix + ", " + name);
        }
        if (this.dumpingStack) {
            Thread.dumpStack();
        }
    }

    @Override
    public void removeNamespace(RepositoryConnection conn, String prefix) {
        if (this.printing) {
            this.stream.println("REMOVENAMESPACE (" + this.getConnectionID(conn) + ") " + prefix);
        }
        if (this.dumpingStack) {
            Thread.dumpStack();
        }
    }

    @Override
    public void clearNamespaces(RepositoryConnection conn) {
        if (this.printing) {
            this.stream.println("CLEARNAMESPACES (" + this.getConnectionID(conn) + ")");
        }
        if (this.dumpingStack) {
            Thread.dumpStack();
        }
    }

    protected String getConnectionID(RepositoryConnection conn) {
        int maxLength;
        String id = conn.toString();
        int length = id.length();
        return length <= (maxLength = 20) ? id : "..." + id.substring(length - maxLength);
    }

    @Override
    public void execute(RepositoryConnection conn, QueryLanguage ql, String update, String baseURI, Update operation) {
        if (this.printing) {
            this.stream.println("EXECUTE (" + this.getConnectionID(conn) + ") " + update);
        }
        if (this.dumpingStack) {
            Thread.dumpStack();
        }
    }

    @Override
    public void begin(RepositoryConnection conn) {
        if (this.printing) {
            this.stream.println("BEGIN (" + this.getConnectionID(conn) + ")");
        }
        if (this.dumpingStack) {
            Thread.dumpStack();
        }
    }
}

