/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.concurrent.locks.diagnostics;

import java.lang.ref.Cleaner;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.ConcurrentCleaner;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.LockMonitoring;
import org.slf4j.Logger;

@InternalUseOnly
public class LockTracking<T extends Lock>
implements LockMonitoring<T> {
    public static final int LOGGED_STALLED_LOCKS_MINIMUM_WAIT_TO_COLLECT = 1000;
    private final Logger logger;
    private static final ConcurrentCleaner cleaner = new ConcurrentCleaner();
    private static final AtomicLong seq = new AtomicLong();
    private final ReentrantLock staleLoggingLock = new ReentrantLock();
    private final Map<SimpleLock<T>, WeakReference<SimpleLock<T>>> locks = Collections.synchronizedMap(new WeakHashMap());
    private final Lock.ExtendedSupplier<T> supplier;
    private final boolean stacktrace;
    private final int waitToCollect;
    private final String alias;
    private int currentWaitToCollect;
    private long previousCleanup = 0L;
    private long previousActiveLocksSignature = 0L;

    public LockTracking(boolean stacktrace, String alias, Logger logger, int waitToCollect, Lock.ExtendedSupplier<T> supplier) {
        this.stacktrace = stacktrace;
        this.supplier = supplier;
        this.waitToCollect = waitToCollect;
        this.currentWaitToCollect = waitToCollect;
        this.logger = logger;
        this.alias = alias;
    }

    private long getActiveLocksSignature() {
        return this.locks.keySet().stream().filter(Objects::nonNull).filter(SimpleLock::isActive).mapToLong(s -> s.state.acquiredId).sum();
    }

    private void logStalledLocks() {
        Thread currentThread = Thread.currentThread();
        this.locks.keySet().stream().filter(Objects::nonNull).filter(SimpleLock::isActive).forEach(simpleLock -> {
            if (simpleLock.state.thread == currentThread) {
                this.logger.warn("{} is possibly deadlocked waiting on \"{}\" with id {} acquired in the same thread", new Object[]{currentThread.getName(), simpleLock.state.alias, simpleLock.state.acquiredId, simpleLock.state.stack});
            } else {
                this.logger.info("Current thread ({}) is waiting on a possibly stalled lock \"{}\" with id {} acquired in {}", new Object[]{currentThread.getName(), simpleLock.state.alias, simpleLock.state.acquiredId, simpleLock.state.thread.getName(), simpleLock.state.stack});
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runCleanup() {
        if (this.previousCleanup == 0L) {
            this.previousCleanup = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - this.previousCleanup > (long)this.currentWaitToCollect) {
            boolean locked = false;
            try {
                locked = this.staleLoggingLock.tryLock();
                if (locked && System.currentTimeMillis() - this.previousCleanup > (long)this.currentWaitToCollect) {
                    this.previousCleanup = 0L;
                    System.gc();
                    long activeLocksSignature = this.getActiveLocksSignature();
                    if (this.previousActiveLocksSignature == activeLocksSignature) {
                        this.logStalledLocks();
                        this.currentWaitToCollect = Math.max(this.currentWaitToCollect, 1000);
                    } else {
                        this.currentWaitToCollect = this.waitToCollect;
                    }
                    this.previousActiveLocksSignature = activeLocksSignature;
                    this.previousCleanup = System.currentTimeMillis();
                }
            }
            finally {
                if (locked) {
                    this.staleLoggingLock.unlock();
                }
            }
        }
    }

    @Override
    public Lock getLock() throws InterruptedException {
        return this.getLock(this.alias);
    }

    @Override
    public Lock getLock(String alias) throws InterruptedException {
        return this.getLockInner(this.supplier.getLock(), alias);
    }

    @Override
    public T unsafeInnerLock(Lock lock) {
        if (lock instanceof SimpleLock) {
            return ((SimpleLock)lock).state.lock;
        }
        throw new IllegalArgumentException("Supplied lock is not instanceof SimpleLock");
    }

    @Override
    public Lock tryLock() {
        T lock = this.supplier.tryLock();
        if (lock != null) {
            return this.getLockInner(lock, this.alias);
        }
        return null;
    }

    private SimpleLock<T> getLockInner(T lock, String alias) {
        Thread thread = Thread.currentThread();
        long sequenceNumber = seq.incrementAndGet();
        Throwable stack = this.stacktrace ? new Throwable(alias + " lock " + sequenceNumber + " acquired in " + thread.getName()) : null;
        SimpleLock<T> simpleLock = new SimpleLock<T>(lock, alias, sequenceNumber, stack, thread, this.logger);
        this.locks.put(simpleLock, new WeakReference<SimpleLock<T>>(simpleLock));
        return simpleLock;
    }

    @Override
    public boolean requiresManualCleanup() {
        return true;
    }

    @Override
    public Lock register(T lock) {
        return this.getLockInner(lock, this.alias);
    }

    @Override
    public void unregister(Lock lock) {
        assert (!lock.isActive());
        if (!(lock instanceof SimpleLock)) {
            throw new IllegalArgumentException("Supplied lock is not instanceof SimpleLock");
        }
        ((SimpleLock)lock).cleanable.clean();
    }

    public static class SimpleLock<T extends Lock>
    implements Lock {
        private final State<T> state;
        private final Cleaner.Cleanable cleanable;

        public SimpleLock(T lock, String alias, long acquiredId, Throwable stack, Thread thread, Logger logger) {
            this.state = new State<T>(lock, alias, acquiredId, stack, thread, logger);
            this.cleanable = cleaner.register(this, this.state);
        }

        @Override
        public boolean isActive() {
            return this.state.lock.isActive();
        }

        @Override
        public void release() {
            this.state.lock.release();
            this.cleanable.clean();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SimpleLock)) {
                return false;
            }
            SimpleLock that = (SimpleLock)o;
            return this.state.acquiredId == that.state.acquiredId;
        }

        public int hashCode() {
            return Long.hashCode(this.state.acquiredId);
        }

        static class State<T extends Lock>
        implements Runnable {
            private final T lock;
            private final String alias;
            private final long acquiredId;
            private final Throwable stack;
            private final Thread thread;
            private final Logger logger;

            public State(T lock, String alias, long acquiredId, Throwable stack, Thread thread, Logger logger) {
                this.lock = lock;
                this.alias = alias;
                this.acquiredId = acquiredId;
                this.stack = stack;
                this.logger = logger;
                this.thread = thread;
            }

            @Override
            public void run() {
                if (this.lock.isActive()) {
                    this.lock.release();
                    this.logAbandoned(this.logger);
                }
            }

            void logAbandoned(Logger logger) {
                if (this.stack == null) {
                    logger.warn("\"{}\" lock abandoned; lock was acquired in {}; consider setting the {} system property", new Object[]{this.alias, this.thread.getName(), "info.aduna.concurrent.locks.trackLocks"});
                } else {
                    logger.warn("\"{}\" lock abandoned; lock was acquired in {}", new Object[]{this.alias, this.thread.getName(), this.stack});
                }
            }
        }
    }
}

