/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.sparql;

import org.eclipse.rdf4j.common.text.StringUtil;
import org.eclipse.rdf4j.model.Namespace;

public class SPARQLQueries {
    public static String getPrefixClauses(Iterable<Namespace> namespaces) {
        StringBuilder sb = new StringBuilder();
        for (Namespace namespace : namespaces) {
            sb.append(String.format("PREFIX %s: <%s>\n", namespace.getPrefix(), namespace.getName()));
        }
        return sb.toString();
    }

    public static String escape(String s) {
        s = StringUtil.gsub((String)"\\", (String)"\\\\", (String)s);
        s = StringUtil.gsub((String)"\t", (String)"\\t", (String)s);
        s = StringUtil.gsub((String)"\n", (String)"\\n", (String)s);
        s = StringUtil.gsub((String)"\r", (String)"\\r", (String)s);
        s = StringUtil.gsub((String)"\b", (String)"\\b", (String)s);
        s = StringUtil.gsub((String)"\f", (String)"\\f", (String)s);
        s = StringUtil.gsub((String)"\"", (String)"\\\"", (String)s);
        s = StringUtil.gsub((String)"'", (String)"\\'", (String)s);
        return s;
    }

    public static String unescape(String s) {
        int backSlashIdx = s.indexOf(92);
        if (backSlashIdx == -1) {
            return s;
        }
        int startIdx = 0;
        int sLength = s.length();
        StringBuilder sb = new StringBuilder(sLength);
        while (backSlashIdx != -1) {
            sb.append(s.substring(startIdx, backSlashIdx));
            if (backSlashIdx + 1 >= sLength) {
                throw new IllegalArgumentException("Unescaped backslash in: " + s);
            }
            char c = s.charAt(backSlashIdx + 1);
            switch (c) {
                case 't': {
                    sb.append('\t');
                    startIdx = backSlashIdx + 2;
                    break;
                }
                case 'n': {
                    sb.append('\n');
                    startIdx = backSlashIdx + 2;
                    break;
                }
                case 'r': {
                    sb.append('\r');
                    startIdx = backSlashIdx + 2;
                    break;
                }
                case 'b': {
                    sb.append('\b');
                    startIdx = backSlashIdx + 2;
                    break;
                }
                case 'f': {
                    sb.append('\f');
                    startIdx = backSlashIdx + 2;
                    break;
                }
                case '\"': {
                    sb.append('\"');
                    startIdx = backSlashIdx + 2;
                    break;
                }
                case '\'': {
                    sb.append('\'');
                    startIdx = backSlashIdx + 2;
                    break;
                }
                case '\\': {
                    sb.append('\\');
                    startIdx = backSlashIdx + 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unescaped backslash in: " + s);
                }
            }
            backSlashIdx = s.indexOf(92, startIdx);
        }
        sb.append(s.substring(startIdx));
        return sb.toString();
    }
}

