/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.common.iteration.UnionIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Statements;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.helpers.SailConnectionWrapper;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
@InternalUseOnly
public class VerySimpleRdfsBackwardsChainingConnection
extends SailConnectionWrapper {
    private final RdfsSubClassOfReasoner rdfsSubClassOfReasoner;
    private static final Logger logger = LoggerFactory.getLogger(VerySimpleRdfsBackwardsChainingConnection.class);

    VerySimpleRdfsBackwardsChainingConnection(SailConnection wrappedCon, RdfsSubClassOfReasoner rdfsSubClassOfReasoner) {
        super(wrappedCon);
        this.rdfsSubClassOfReasoner = rdfsSubClassOfReasoner;
    }

    @Override
    public boolean hasStatement(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        boolean hasStatement = super.hasStatement(subj, pred, obj, false, contexts);
        if (hasStatement) {
            return true;
        }
        if (this.rdfsSubClassOfReasoner != null && includeInferred && obj != null && obj.isResource() && RDF.TYPE.equals(pred)) {
            Set<Resource> types = this.rdfsSubClassOfReasoner.backwardsChain((Resource)obj);
            if (types.size() > 10) {
                try (CloseableIteration<? extends Statement, SailException> statements = super.getStatements(subj, RDF.TYPE, null, false, contexts);){
                    boolean bl = statements.stream().map(Statement::getObject).filter(Value::isResource).map(type -> (Resource)type).anyMatch(types::contains);
                    return bl;
                }
            }
            return types.stream().anyMatch(type -> super.hasStatement(subj, pred, (Value)type, false, contexts));
        }
        return false;
    }

    @Override
    public CloseableIteration<? extends Statement, SailException> getStatements(Resource subj, IRI pred, final Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        Set<Resource> inferredTypes;
        if (this.rdfsSubClassOfReasoner != null && includeInferred && obj != null && obj.isResource() && RDF.TYPE.equals(pred) && !(inferredTypes = this.rdfsSubClassOfReasoner.backwardsChain((Resource)obj)).isEmpty()) {
            final CloseableIteration[] statementsMatchingInferredTypes = (CloseableIteration[])inferredTypes.stream().map(r -> super.getStatements(subj, pred, (Value)r, false, contexts)).toArray(CloseableIteration[]::new);
            return new LookAheadIteration<Statement, SailException>(){
                final UnionIteration<Statement, SailException> unionIteration;
                final HashSet<Statement> dedupe;
                {
                    this.unionIteration = new UnionIteration(statementsMatchingInferredTypes);
                    this.dedupe = new HashSet();
                }

                @Override
                protected Statement getNextElement() throws SailException {
                    Statement next = null;
                    while (next == null && this.unionIteration.hasNext()) {
                        Statement temp = (Statement)this.unionIteration.next();
                        temp = Statements.statement(temp.getSubject(), temp.getPredicate(), obj, temp.getContext());
                        if (!this.dedupe.isEmpty()) {
                            boolean contains = this.dedupe.contains(temp);
                            if (contains) continue;
                            next = temp;
                            this.dedupe.add(next);
                            continue;
                        }
                        next = temp;
                        this.dedupe.add(next);
                    }
                    return next;
                }

                @Override
                public void remove() throws SailException {
                    throw new IllegalStateException("Not implemented");
                }

                @Override
                protected void handleClose() throws SailException {
                    try {
                        this.unionIteration.close();
                    }
                    finally {
                        super.handleClose();
                    }
                }
            };
        }
        return super.getStatements(subj, pred, obj, includeInferred, contexts);
    }
}

