/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;

public class LeftJoinIterator
extends LookAheadIteration<BindingSet, QueryEvaluationException> {
    private final EvaluationStrategy strategy;
    private final LeftJoin join;
    private final Set<String> scopeBindingNames;
    private final CloseableIteration<BindingSet, QueryEvaluationException> leftIter;
    private CloseableIteration<BindingSet, QueryEvaluationException> rightIter;

    public LeftJoinIterator(EvaluationStrategy strategy, LeftJoin join, BindingSet bindings) throws QueryEvaluationException {
        this.strategy = strategy;
        this.join = join;
        this.scopeBindingNames = join.getBindingNames();
        this.leftIter = strategy.evaluate(join.getLeftArg(), bindings);
        this.rightIter = new EmptyIteration<BindingSet, QueryEvaluationException>();
        join.setAlgorithm(this);
    }

    @Override
    protected BindingSet getNextElement() throws QueryEvaluationException {
        try {
            CloseableIteration<BindingSet, QueryEvaluationException> nextRightIter = this.rightIter;
            while (nextRightIter.hasNext() || this.leftIter.hasNext()) {
                BindingSet leftBindings = null;
                if (!nextRightIter.hasNext()) {
                    leftBindings = (BindingSet)this.leftIter.next();
                    nextRightIter.close();
                    nextRightIter = this.rightIter = this.strategy.evaluate(this.join.getRightArg(), leftBindings);
                }
                while (nextRightIter.hasNext()) {
                    BindingSet rightBindings = (BindingSet)nextRightIter.next();
                    try {
                        if (this.join.getCondition() == null) {
                            return rightBindings;
                        }
                        QueryBindingSet scopeBindings = new QueryBindingSet(rightBindings);
                        scopeBindings.retainAll(this.scopeBindingNames);
                        if (!this.strategy.isTrue(this.join.getCondition(), scopeBindings)) continue;
                        return rightBindings;
                    }
                    catch (ValueExprEvaluationException valueExprEvaluationException) {
                    }
                }
                if (leftBindings == null) continue;
                return leftBindings;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return null;
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        try {
            super.handleClose();
        }
        finally {
            try {
                this.leftIter.close();
            }
            finally {
                this.rightIter.close();
            }
        }
    }
}

