/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.http.CookieCompliance;
import org.eclipse.jetty.http.DateGenerator;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.Syntax;
import org.eclipse.jetty.util.QuotedStringTokenizer;

public class HttpCookie {
    private static final String __COOKIE_DELIM = "\",;\\ \t";
    private static final String __01Jan1970_COOKIE = DateGenerator.formatCookieDate(0L).trim();
    private final String _name;
    private final String _value;
    private final String _comment;
    private final String _domain;
    private final long _maxAge;
    private final String _path;
    private final boolean _secure;
    private final int _version;
    private final boolean _httpOnly;
    private final long _expiration;

    public HttpCookie(String name, String value) {
        this(name, value, -1L);
    }

    public HttpCookie(String name, String value, String domain, String path) {
        this(name, value, domain, path, -1L, false, false);
    }

    public HttpCookie(String name, String value, long maxAge) {
        this(name, value, null, null, maxAge, false, false);
    }

    public HttpCookie(String name, String value, String domain, String path, long maxAge, boolean httpOnly, boolean secure) {
        this(name, value, domain, path, maxAge, httpOnly, secure, null, 0);
    }

    public HttpCookie(String name, String value, String domain, String path, long maxAge, boolean httpOnly, boolean secure, String comment, int version) {
        this._name = name;
        this._value = value;
        this._domain = domain;
        this._path = path;
        this._maxAge = maxAge;
        this._httpOnly = httpOnly;
        this._secure = secure;
        this._comment = comment;
        this._version = version;
        this._expiration = maxAge < 0L ? -1L : System.nanoTime() + TimeUnit.SECONDS.toNanos(maxAge);
    }

    public HttpCookie(String setCookie) {
        List<java.net.HttpCookie> cookies = java.net.HttpCookie.parse(setCookie);
        if (cookies.size() != 1) {
            throw new IllegalStateException();
        }
        java.net.HttpCookie cookie = cookies.get(0);
        this._name = cookie.getName();
        this._value = cookie.getValue();
        this._domain = cookie.getDomain();
        this._path = cookie.getPath();
        this._maxAge = cookie.getMaxAge();
        this._httpOnly = cookie.isHttpOnly();
        this._secure = cookie.getSecure();
        this._comment = cookie.getComment();
        this._version = cookie.getVersion();
        this._expiration = this._maxAge < 0L ? -1L : System.nanoTime() + TimeUnit.SECONDS.toNanos(this._maxAge);
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public String getComment() {
        return this._comment;
    }

    public String getDomain() {
        return this._domain;
    }

    public long getMaxAge() {
        return this._maxAge;
    }

    public String getPath() {
        return this._path;
    }

    public boolean isSecure() {
        return this._secure;
    }

    public int getVersion() {
        return this._version;
    }

    public boolean isHttpOnly() {
        return this._httpOnly;
    }

    public boolean isExpired(long timeNanos) {
        return this._expiration >= 0L && timeNanos >= this._expiration;
    }

    public String asString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName()).append("=").append(this.getValue());
        if (this.getDomain() != null) {
            builder.append(";$Domain=").append(this.getDomain());
        }
        if (this.getPath() != null) {
            builder.append(";$Path=").append(this.getPath());
        }
        return builder.toString();
    }

    private static void quoteOnlyOrAppend(StringBuilder buf, String s, boolean quote) {
        if (quote) {
            QuotedStringTokenizer.quoteOnly((Appendable)buf, (String)s);
        } else {
            buf.append(s);
        }
    }

    private static boolean isQuoteNeededForCookie(String s) {
        if (s == null || s.length() == 0) {
            return true;
        }
        if (QuotedStringTokenizer.isQuoted((String)s)) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (__COOKIE_DELIM.indexOf(c) >= 0) {
                return true;
            }
            if (c >= ' ' && c < '\u007f') continue;
            throw new IllegalArgumentException("Illegal character in cookie value");
        }
        return false;
    }

    public String getSetCookie(CookieCompliance compliance) {
        switch (compliance) {
            case RFC2965: {
                return this.getRFC2965SetCookie();
            }
            case RFC6265: {
                return this.getRFC6265SetCookie();
            }
        }
        throw new IllegalStateException();
    }

    public String getRFC2965SetCookie() {
        if (this._name == null || this._name.length() == 0) {
            throw new IllegalArgumentException("Bad cookie name");
        }
        StringBuilder buf = new StringBuilder();
        boolean quote_name = HttpCookie.isQuoteNeededForCookie(this._name);
        HttpCookie.quoteOnlyOrAppend(buf, this._name, quote_name);
        buf.append('=');
        boolean quote_value = HttpCookie.isQuoteNeededForCookie(this._value);
        HttpCookie.quoteOnlyOrAppend(buf, this._value, quote_value);
        boolean has_domain = this._domain != null && this._domain.length() > 0;
        boolean quote_domain = has_domain && HttpCookie.isQuoteNeededForCookie(this._domain);
        boolean has_path = this._path != null && this._path.length() > 0;
        boolean quote_path = has_path && HttpCookie.isQuoteNeededForCookie(this._path);
        int version = this._version;
        if (version == 0 && (this._comment != null || quote_name || quote_value || quote_domain || quote_path || QuotedStringTokenizer.isQuoted((String)this._name) || QuotedStringTokenizer.isQuoted((String)this._value) || QuotedStringTokenizer.isQuoted((String)this._path) || QuotedStringTokenizer.isQuoted((String)this._domain))) {
            version = 1;
        }
        if (version == 1) {
            buf.append(";Version=1");
        } else if (version > 1) {
            buf.append(";Version=").append(version);
        }
        if (has_path) {
            buf.append(";Path=");
            HttpCookie.quoteOnlyOrAppend(buf, this._path, quote_path);
        }
        if (has_domain) {
            buf.append(";Domain=");
            HttpCookie.quoteOnlyOrAppend(buf, this._domain, quote_domain);
        }
        if (this._maxAge >= 0L) {
            buf.append(";Expires=");
            if (this._maxAge == 0L) {
                buf.append(__01Jan1970_COOKIE);
            } else {
                DateGenerator.formatCookieDate(buf, System.currentTimeMillis() + 1000L * this._maxAge);
            }
            if (version >= 1) {
                buf.append(";Max-Age=");
                buf.append(this._maxAge);
            }
        }
        if (this._secure) {
            buf.append(";Secure");
        }
        if (this._httpOnly) {
            buf.append(";HttpOnly");
        }
        if (this._comment != null) {
            buf.append(";Comment=");
            HttpCookie.quoteOnlyOrAppend(buf, this._comment, HttpCookie.isQuoteNeededForCookie(this._comment));
        }
        return buf.toString();
    }

    public String getRFC6265SetCookie() {
        if (this._name == null || this._name.length() == 0) {
            throw new IllegalArgumentException("Bad cookie name");
        }
        Syntax.requireValidRFC2616Token(this._name, "RFC6265 Cookie name");
        Syntax.requireValidRFC6265CookieValue(this._value);
        StringBuilder buf = new StringBuilder();
        buf.append(this._name).append('=').append(this._value == null ? "" : this._value);
        if (this._path != null && this._path.length() > 0) {
            buf.append("; Path=").append(this._path);
        }
        if (this._domain != null && this._domain.length() > 0) {
            buf.append("; Domain=").append(this._domain);
        }
        if (this._maxAge >= 0L) {
            buf.append("; Expires=");
            if (this._maxAge == 0L) {
                buf.append(__01Jan1970_COOKIE);
            } else {
                DateGenerator.formatCookieDate(buf, System.currentTimeMillis() + 1000L * this._maxAge);
            }
            buf.append("; Max-Age=");
            buf.append(this._maxAge);
        }
        if (this._secure) {
            buf.append("; Secure");
        }
        if (this._httpOnly) {
            buf.append("; HttpOnly");
        }
        return buf.toString();
    }

    public static class SetCookieHttpField
    extends HttpField {
        final HttpCookie _cookie;

        public SetCookieHttpField(HttpCookie cookie, CookieCompliance compliance) {
            super(HttpHeader.SET_COOKIE, cookie.getSetCookie(compliance));
            this._cookie = cookie;
        }

        public HttpCookie getHttpCookie() {
            return this._cookie;
        }
    }
}

